/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.idp;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.state.AuthenticationFailed;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.templates.mgmt.DefaultTemplateParams;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.ErrorCodeException;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.PseudonymService;
import org.sourceid.saml20.service.PseudonymServiceException;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class SsoRespSupport {
    private static final byte NULL_CHAR_BYTE = 0;
    private static final int DEFAULT_TRANSIENT_ID_SIZE = 255;
    private static final AttributeValue PERSISTENT_ATR_VAL = new AttributeValue("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
    private static final AttributeValue TRANSIENT_ATR_VAL = new AttributeValue("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
    private final PseudonymService pseudonymService = GlobalRegistry.getService(PseudonymService.class);
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final MetadataLocal localMetadata = MetaDataFactory.getLocalMetaData();
    static TargetResourceValidationMgr redirectValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);
    private final Log log = LogFactory.getLog(this.getClass());

    public void nameId(String spEntityId, String virtualEntityId, SpConnection sp, IdpAuthenticationResult authnResult, boolean allowCreate, AttributeMap attributes, String requestedFormat) throws PseudonymServiceException, StatusResponseException {
        boolean doPseudonym;
        String nameIdFormatKey = AssertionMapKeys.getNameIdFormatKey();
        String nameIdFormat = sp.getNameIdFormat();
        attributes.putIfNotPresent(nameIdFormatKey, new AttributeValue(nameIdFormat));
        boolean doTransient = this.config.getBooleanValue("FulfillTransientNameIdRequests", true);
        doTransient &= "urn:oasis:names:tc:SAML:2.0:nameid-format:transient".equals(requestedFormat);
        boolean bl = doPseudonym = !(doTransient |= sp.sendTransientAsNameId()) && sp.sendPseudonymAsNameId();
        if (doPseudonym) {
            String pseudonym;
            String localIdentification;
            AttributeMap pseudonymSourceAttrs = authnResult.getPseudonymAttributeSource();
            List<String> fieldsForLinkingIdGeneration = authnResult.getPseudonymAttributeNames();
            ArrayList<String> auditPseudonyms = new ArrayList<String>();
            if (fieldsForLinkingIdGeneration.size() == 1) {
                String key = fieldsForLinkingIdGeneration.iterator().next();
                AttributeValue o = (AttributeValue)pseudonymSourceAttrs.get((Object)key);
                if (o == null) {
                    throw this.nullPseudoInput(key, fieldsForLinkingIdGeneration, authnResult);
                }
                localIdentification = o.toString();
                auditPseudonyms.add(o.sensitiveToString());
            } else if (fieldsForLinkingIdGeneration.size() > 1) {
                MessageDigest digester = HashUtil.getMessageDigester((HashAlgorithm)HashAlgorithm.SHA1);
                for (String fieldName : fieldsForLinkingIdGeneration) {
                    AttributeValue o = (AttributeValue)pseudonymSourceAttrs.get((Object)fieldName);
                    if (o == null) {
                        throw this.nullPseudoInput(fieldName, fieldsForLinkingIdGeneration, authnResult);
                    }
                    try {
                        digester.update(o.toString().getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    digester.update((byte)0);
                    auditPseudonyms.add(o.sensitiveToString());
                }
                byte[] digestBytes = digester.digest();
                localIdentification = B64.encode((byte[])digestBytes);
            } else {
                Object sourceName = "";
                String details = "";
                if (!authnResult.isFromAuthnSelectionApc()) {
                    AuthnSourceKey authnSourceKey = authnResult.getLastAuthnSourceKey();
                    if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
                        sourceName = "IdP adapter '" + authnResult.getLastAuthnSourceKey().getId() + "'";
                        details = " In the admin console, configure your IdP adapter and mark at least one attribute from its contract that will be used for pseudonym creation.";
                    } else {
                        sourceName = "IdP connecton '" + authnResult.getLastAuthnSourceKey().getId() + "'";
                    }
                } else {
                    sourceName = "authentication policy contract '" + authnResult.getSourceMappingId() + "'";
                }
                String msg = "The " + (String)sourceName + " doesn't have any attributes defined for pseudonym creation, but is used in a pseudonymous SP connection." + details;
                throw new ProcessRuntimeException(msg);
            }
            if (!auditPseudonyms.isEmpty()) {
                IdpAuditLogger.setUserName(StringUtils.join(auditPseudonyms, (String)","));
            }
            if (StringUtils.isBlank((String)(pseudonym = this.pseudonymService.getPseudonym(localIdentification, spEntityId, allowCreate)))) {
                String statusMessage = "A pseudonym (persistent name id) does not already exist for the subject";
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", statusMessage);
            }
            attributes.put(AssertionMapKeys.getNameIdValueKey(), new AttributeValue(pseudonym));
            attributes.put(nameIdFormatKey, PERSISTENT_ATR_VAL);
            this.setQualifiers((Map<String, AttributeValue>)attributes, spEntityId, virtualEntityId);
        } else if (doTransient) {
            int transientIdSize = this.config.getIntValue("TransientIdSize", 255);
            String transientIdentifier = IDGenerator.rndAlphaNumeric(transientIdSize);
            attributes.put(AssertionMapKeys.getNameIdValueKey(), new AttributeValue(transientIdentifier));
            attributes.put(nameIdFormatKey, TRANSIENT_ATR_VAL);
            this.setQualifiers((Map<String, AttributeValue>)attributes, spEntityId, virtualEntityId);
        }
    }

    private ProcessRuntimeException nullPseudoInput(String name, List<String> fields, IdpAuthenticationResult authnResult) {
        Object msg;
        if (authnResult.isFromAuthnSelectionApc()) {
            msg = "The authentication policy contract's 'subject' attribute must be non-null to generate a proper pseudonym.";
        } else {
            AuthnSourceKey authnSourceKey = authnResult.getLastAuthnSourceKey();
            if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
                StringBuilder sb = new StringBuilder();
                sb.append("All attributes used to generate the pseudonym must have a non-null value. The IdP adapter (");
                sb.append(authnSourceKey.getId()).append(") is configured to use the following attributes for pseudonym generation: ");
                sb.append(fields).append(".  However the adapter did not return a value for the attribute: ").append(name);
                msg = sb.toString();
            } else {
                msg = "The IdP connection (" + authnSourceKey.getId() + ") must have a non-null '" + AssertionMapKeys.getNameIdValueKey() + "' attribute to generate a proper pseudonym.";
            }
        }
        throw new ProcessRuntimeException((String)msg);
    }

    private void setQualifiers(Map<String, AttributeValue> attributes, String spEntityId, String virtualEntityId) {
        attributes.put(AssertionMapKeys.getNameIdQualifierKey(), new AttributeValue(virtualEntityId));
        attributes.put(AssertionMapKeys.getNameIdSpQualifierKey(), new AttributeValue(spEntityId));
    }

    public AttributeValue getAuthnCtxFromAuthnAttrs(AttributeMap incomingAuthnAttrs, IdpHashableAuthnBean[] beans, String defaultAuthnCtx) {
        String authnCtxValue = defaultAuthnCtx;
        if (beans != null) {
            for (IdpHashableAuthnBean bean : beans) {
                AttributeValue beanAuthnCtxValue;
                if (bean == null) continue;
                if (bean.getAuthnIdentifiersMap().containsKey(AssertionMapKeys.getAuthnCtxOverrideKey())) {
                    beanAuthnCtxValue = bean.getAuthnCtx();
                    if (beanAuthnCtxValue == null) break;
                    authnCtxValue = beanAuthnCtxValue.getValue();
                    break;
                }
                beanAuthnCtxValue = bean.getAuthnCtx();
                if (beanAuthnCtxValue == null) continue;
                authnCtxValue = beanAuthnCtxValue.getValue();
            }
        }
        if (incomingAuthnAttrs.containsKey((Object)AssertionMapKeys.getAuthnCtxKey())) {
            AttributeValue v = (AttributeValue)incomingAuthnAttrs.get((Object)AssertionMapKeys.getAuthnCtxKey());
            authnCtxValue = v.getValue();
        }
        if (authnCtxValue == null) {
            return null;
        }
        return new AttributeValue(authnCtxValue);
    }

    private Long getAuthnInstantInMills(IdpHashableAuthnBean bean, boolean defaultToBeanCreationTime) {
        String keyName;
        Map<String, Object> authnIdentifiersMap = bean.getAuthnIdentifiersMap();
        Object object = authnIdentifiersMap.get(keyName = AssertionMapKeys.getAuthnInstantKey());
        if (object == null && bean instanceof IdpConnHashableAuthnBean) {
            IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)bean;
            IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), false);
            if (idpConn != null && idpConn.getProtocol() == Protocol.OIDC && (object = authnIdentifiersMap.get("auth_time")) != null && object instanceof AttributeValue) {
                object = Long.parseLong(((AttributeValue)object).getValue()) * 1000L;
            }
        }
        if (bean.getAuthnSourceKey().getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
            Object adapterInstant = authnIdentifiersMap.get("org.sourceid.saml20.adapter.idp.authn.authnInst");
            if (object == null && adapterInstant != null) {
                keyName = "org.sourceid.saml20.adapter.idp.authn.authnInst";
                object = adapterInstant;
            }
        }
        if (object == null && defaultToBeanCreationTime) {
            object = bean.getCreationTimeMillis();
        }
        if (object != null) {
            if (object instanceof AttributeValue) {
                object = ((AttributeValue)object).getObjectValue();
            }
            return this.toMillis(object, keyName);
        }
        return null;
    }

    private Long toMillis(Object object, String keyName) {
        if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            return calendar.getTimeInMillis();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return date.getTime();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            String s = (String)object;
            try {
                return Long.parseLong(s);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder();
                msg.append("Unable to parse authn instant value as Long from string value ").append(s);
                msg.append(" returned by authentication source for key ").append(LogGuard.encode(keyName));
                this.log.info((Object)msg);
            }
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append("Unable to set authn instant value because the ");
            msg.append("authentication source returned ").append(object).append(" of type ").append(object.getClass());
            msg.append(" for key ").append(LogGuard.encode(keyName));
            this.log.info((Object)msg);
        }
        return null;
    }

    public Long getLatestAuthnInstantValue(AttributeMap sourceAttrs, IdpHashableAuthnBean[] authnBeans) {
        return this.getLatestAuthnInstantFromSources(sourceAttrs, authnBeans, false);
    }

    private Long getLatestAuthnInstantFromSources(AttributeMap sourceAttrs, IdpHashableAuthnBean[] authnBeans, boolean defaultToBeanCreationTime) {
        Long samlAuthnInstant;
        Long lastTime = null;
        if (authnBeans != null) {
            for (IdpHashableAuthnBean authnBean : authnBeans) {
                Long instantInMills;
                if (authnBean == null || (instantInMills = this.getAuthnInstantInMills(authnBean, defaultToBeanCreationTime || authnBean.isValidForSso())) == null || lastTime != null && lastTime >= instantInMills) continue;
                lastTime = instantInMills;
            }
        }
        if ((samlAuthnInstant = this.getSamlAuthnInstantInMills(sourceAttrs)) != null) {
            lastTime = samlAuthnInstant;
        }
        return lastTime;
    }

    public Calendar getAuthnInstantValue(AttributeMap sourceAttrs, IdpHashableAuthnBean[] authnBeans) {
        return this.getAuthnInstantValue(sourceAttrs, authnBeans, true);
    }

    public Calendar getAuthnInstantValue(AttributeMap sourceAttrs, IdpHashableAuthnBean[] authnBeans, boolean defaultToBeanCreationTime) {
        Long lastTime = this.getLatestAuthnInstantFromSources(sourceAttrs, authnBeans, defaultToBeanCreationTime);
        if (!defaultToBeanCreationTime && lastTime == null) {
            return null;
        }
        Calendar authnInst = this.getDefaultAuthnInstantValue();
        if (lastTime != null) {
            authnInst.setTimeInMillis(lastTime);
        }
        return authnInst;
    }

    public Long getSamlAuthnInstantInMills(AttributeMap attributes) {
        AttributeValue v = (AttributeValue)attributes.get((Object)AssertionMapKeys.getAuthnInstantKey());
        if (v != null) {
            return this.toMillis(v.getObjectValue(), AssertionMapKeys.getAuthnInstantKey());
        }
        return null;
    }

    public Calendar getDefaultAuthnInstantValue() {
        Calendar authnInst = Util.getUtcCalendar();
        authnInst.setTimeZone(Util.getUtcTimeZone());
        return authnInst;
    }

    public boolean isHandleExceptionLocally(InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        return inMsgCtx.isUnsolicitedResponse() && !this.config.getBooleanValue("SendErrorResponseForUnsolicited", false) || this.isHandleFailuresLocally(outMsgCtx);
    }

    public boolean isHandleFailuresLocally(OutMessageContext outMsgCtx) {
        return outMsgCtx != null && BooleanUtils.toBooleanDefaultIfNull((Boolean)outMsgCtx.getSupplementalContext("handleFailuresLocally", Boolean.class), (boolean)false);
    }

    public void handleException(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp, Role role) throws IOException {
        if (this.isHandleExceptionLocally(inMsgCtx, outMsgCtx)) {
            String adapterId = AuthnPolicyUtil.getDefault().getNonConnBasedAdapterId(req, stateParams);
            adapterId = adapterId == null ? "Unknown" : adapterId;
            this.handleException(e, req, resp, stateParams, inMsgCtx.getInErrorResource(), adapterId, outMsgCtx.getEntityId(), outMsgCtx.getXmlObject(), role);
        }
    }

    public void handleException(Exception e, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, String errorResource, String adapterId, String connectionId, XmlObject responseXml, Role role) throws IOException {
        ErrorCodeException errorCodeException = null;
        if (e instanceof ErrorCodeException) {
            errorCodeException = (ErrorCodeException)((Object)e);
        } else if (e.getCause() instanceof ErrorCodeException) {
            errorCodeException = (ErrorCodeException)((Object)e.getCause());
        }
        String error = "";
        String errorDetail = "";
        if (errorCodeException != null) {
            error = errorCodeException.getErrorCode();
            errorDetail = LocaleUtil.getLocalizedString(req, "pingfederate-messages", errorCodeException.getErrorDetail(), errorCodeException.getErrorDetailParameters());
        }
        boolean inErrorValidationFailed = false;
        if (!StringUtils.isBlank((String)errorResource) && !AuthnApiSupport.getDefault().isApiRequest(req)) {
            try {
                redirectValidationMgr.validateInErrorResource(errorResource);
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                if (!StringUtils.isEmpty((String)error)) {
                    paramsMap.put("error", error);
                }
                if (!StringUtils.isEmpty((String)errorDetail)) {
                    paramsMap.put("errorDetail", errorDetail);
                }
                errorResource = Util.appendQueryParams(errorResource, paramsMap);
                resp.sendRedirect(errorResource);
            }
            catch (InvalidRedirectValidationException ex) {
                inErrorValidationFailed = true;
            }
        }
        if (StringUtils.isBlank((String)errorResource) || inErrorValidationFailed || AuthnApiSupport.getDefault().isApiRequest(req)) {
            String errorPageMsg;
            ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
            HashMap<String, Object> pageParams = new HashMap<String, Object>();
            pageParams.put("exception", e);
            pageParams.put("error", error);
            pageParams.put("errorDetail", errorDetail);
            if (StringUtils.isEmpty((String)errorDetail)) {
                pageParams.put("exceptionMessage", e.getMessage());
            } else {
                pageParams.put("exceptionMessage", "");
            }
            pageParams.put("fullStackTrace", ExceptionUtil.getStackTrace(e));
            if (Role.IDP.equals((Object)role)) {
                pageParams.put("adapterId", adapterId);
                errorPageMsg = this.localMetadata.getErrorPageMsg();
            } else {
                errorPageMsg = "errorDetail.spSsoFailure";
            }
            pageParams.put("errorText", LocaleUtil.getLocalizedString(req, "pingfederate-messages", errorPageMsg, null));
            if (connectionId != null) {
                pageParams.putAll(new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.IDP).entityId(connectionId).build());
                pageParams.put("connectionID", connectionId);
                pageParams.put("entityId", connectionId);
            }
            if (responseXml != null) {
                pageParams.put("responseXml", responseXml);
            }
            AuthenticationFailed authnFailedModel = this.makeAuthnFailedModel(req, resp, error, errorDetail, e, adapterId);
            if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                this.sendApiErrorResponse(req, resp, stateParams, authnFailedModel);
            } else if (!this.checkRedirectAuthnApiApplication(req, resp, stateParams, authnFailedModel)) {
                if (Role.IDP.equals((Object)role)) {
                    renderer.render(req, resp, "idp.sso.error.page.template.html", pageParams);
                } else {
                    renderer.render(req, resp, "sp.sso.error.page.template.html", pageParams);
                }
            }
        }
    }

    public boolean checkRedirectAuthnApiApplication(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, AuthenticationFailed authnFailedModel) throws IOException {
        if (stateParams == null) {
            return false;
        }
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            return false;
        }
        AuthnApiPolicyUtil authnApiUtil = AuthnApiPolicyUtil.getDefault();
        AuthnApiApplication authnApiAppForErrors = authnApiUtil.getEffectiveAuthnApiApplication(stateParams);
        if (authnApiAppForErrors == null) {
            return false;
        }
        String resumePath = this.saveAuthnFailedModel(req, resp, stateParams, authnFailedModel, true);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Error occurred, redirecting to authn API application '" + authnApiAppForErrors.getName() + "'"));
        }
        StateSupport stateSupport = new StateSupport(MetaDataFactory.getLocalMetaData());
        authnApiUtil.redirectAuthnApiApplication(resp, stateSupport.getContextId(resumePath), authnApiAppForErrors);
        return true;
    }

    public AuthenticationFailed makeAuthnFailedModel(HttpServletRequest req, HttpServletResponse resp, String errorCode, String userMessage, Exception e, String adapterId) {
        if (StringUtils.isEmpty((String)errorCode) || "UNDEFINED".equals(errorCode)) {
            errorCode = "AUTHENTICATION_FAILED";
        }
        String trackingId = TrackingIdSupport.getTrackingId();
        AuthenticationFailed authnFailed = new AuthenticationFailed();
        authnFailed.setCode(errorCode);
        if (e.getMessage() != null) {
            authnFailed.setMessage(LocaleUtil.getLocalizedString(req, "pingfederate-messages", e.getMessage(), null));
        }
        if (StringUtils.isNotEmpty((String)userMessage)) {
            authnFailed.setUserMessage(userMessage);
        } else {
            authnFailed.setUserMessage(LocaleUtil.getLocalizedString(req, "pingfederate-messages", "errorDetail.authenticationFailed", null));
        }
        authnFailed.setTrackingId(trackingId);
        authnFailed.setAdapterId(adapterId);
        return authnFailed;
    }

    private void sendApiErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, AuthenticationFailed authnFailedModel) throws IOException {
        this.saveAuthnFailedModel(req, resp, stateParams, authnFailedModel, false);
        AuthnState authnState = CommonStateSpec.FAILED.makeInstance(req, (Object)authnFailedModel);
        AuthnApiSupport.getDefault().writeAuthnStateResponse(req, resp, authnState);
    }

    private String saveAuthnFailedModel(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, AuthenticationFailed authnFailedModel, boolean newFlowId) {
        AuthnApiPolicyUtil authnApiUtil = AuthnApiPolicyUtil.getDefault();
        authnApiUtil.saveAuthnFailedModel(stateParams, authnFailedModel);
        StateSupport stateSupport = new StateSupport(MetaDataFactory.getLocalMetaData());
        return stateSupport.saveState(req, resp, null, null, stateParams, null, newFlowId);
    }

    public AttributeMap executeAuthnSourceToAssertionMapping(IdpAuthenticationResult authnResult, SpConnection spConnection, AttributeMap contextAttributes, Map<String, Object> otherState) throws StatusResponseException {
        AttributeMap authnAttrs = authnResult.getAuthnAttrs();
        if (authnResult.isFromAuthnSelectionApc()) {
            return spConnection.executeC2cMapping(authnResult.getSourceMappingId(), authnAttrs, contextAttributes, otherState);
        }
        AuthnSourceKey authnSourceKey = authnResult.getLastAuthnSourceKey();
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
            String adapterId = authnSourceKey.getId();
            IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstanceWithConnectionOverride(adapterId, spConnection.getEntityId());
            if (instance != null) {
                adapterId = instance.getId();
            }
            return spConnection.executeAdapterMapping(adapterId, authnAttrs, contextAttributes, otherState);
        }
        String idpConnId = authnSourceKey.getId();
        String contractId = MgmtFactory.getC2cContractManager().findMappedContractId(spConnection, idpConnId);
        return spConnection.executeC2cMapping(contractId, authnAttrs, contextAttributes, otherState);
    }
}

