/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp;

import com.pingidentity.adapter.virtual.VirtualAuthnAdapter;
import com.pingidentity.locale.LocaleUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.a2a.Apc2SpaMappingAuthnSupport;
import org.sourceid.a2a.Apc2SpaMappingSpAdapterSupport;
import org.sourceid.a2a.domain.mgmt.Adapter2AdapterManager;
import org.sourceid.a2a.domain.mgmt.Apc2SpAdapterManager;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.Util;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.ErrorCodeException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.sp.SLOSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupportBase;
import org.sourceid.saml20.profiles.sp.TargetUrlMappingUtil;
import org.sourceid.saml20.service.AccountLinkingServiceException;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.PseudonymServiceException;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.servlet.QuietException;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.LicenseObject;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumableRequestCreatorBase;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuditLoggerSupport;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.sp.IdpIdCookieSupport;
import org.sourceid.websso.profiles.sp.IdpSelector;
import org.sourceid.websso.profiles.sp.SSOStarter;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.profiles.sp.SsoRespSupport;
import org.sourceid.websso.servlet.SessionIdUtil;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class CreateSsoRequest
extends ResumableRequestCreatorBase
implements ResumeRequestFromAuthnResponseHandler {
    private static final String SSO_CTX_KEY = "ctx";
    private static final String AUTHN_SESSION_KEY = "authnSession";
    private static final String TARGET_SESSION_ID_KEY = "targetSessionId";
    private final Map<Protocol, SSOStarter> starters = new EnumMap<Protocol, SSOStarter>(Protocol.class);
    private final Apc2SpaMappingAuthnSupport authnSupport = new Apc2SpaMappingAuthnSupport();
    private final Apc2SpaMappingSpAdapterSupport apc2SpaAdapterSupport = new Apc2SpaMappingSpAdapterSupport();
    private final SpAdapterSupport spAdapterSupport = new SpAdapterSupport();
    private final MetadataLocal localMetaData;
    private final org.sourceid.websso.profiles.idp.SsoRespSupport idpRespSupport;
    private final SsoRespSupport spRespSupport;
    private final TargetUrlMappingUtil urlAdapterUtil;
    private final Apc2SpAdapterManager apc2SpaManager = MgmtFactory.getApc2SpAdapterManager();
    private final Adapter2AdapterManager a2aManager = MgmtFactory.getAdapter2AdapterManager();
    private final MetadataDirectory metadataDir = MetaDataFactory.getMetadataDirectory();
    private final SLOSupport sloSupport = new SLOSupport();

    public CreateSsoRequest(MetadataLocal localMetaData) {
        this.localMetaData = localMetaData;
        this.idpRespSupport = new org.sourceid.websso.profiles.idp.SsoRespSupport();
        this.spRespSupport = new SsoRespSupport(localMetaData);
        this.urlAdapterUtil = new TargetUrlMappingUtil();
    }

    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean isUsingAuthnPolicy;
        OutMessageContext ctx = new OutMessageContext(Role.IDP);
        boolean bl = isUsingAuthnPolicy = MgmtFactory.getAuthnSelectionConfigManager().isEnableSpAuthnSelection() || this.isVirtualAdapterRequested(req);
        if (!isUsingAuthnPolicy) {
            Collection<ConnectionDbEntry> activeIdpConnections;
            int cnt;
            String partnerIdpId = null;
            if (req.getParameter("PartnerIdpId") == null && req.getParameter("SpSessionAuthnAdapterId") == null && req.getParameter("TargetResource") == null && req.getParameter("TARGET") == null && (cnt = MgmtFactory.getConnectionDb().getEntryCountByRoleAndStatus(Role.IDP, true, false)) == 1 && (activeIdpConnections = MgmtFactory.getConnectionDb().getEntriesByRoleAndStatus(Role.IDP, true, false)).size() == 1) {
                ConnectionDbEntry conn = activeIdpConnections.iterator().next();
                partnerIdpId = conn.getEntityId();
            }
            if (partnerIdpId == null) {
                partnerIdpId = ProprietaryURLParams.getParam(req, "PartnerIdpId");
            }
            if (partnerIdpId == null && IdpIdCookieSupport.isEnableIdpIdCookie() && (partnerIdpId = IdpIdCookieSupport.getIdpIdFromCookie(req)) == null && IdpIdCookieSupport.isShowIdpSelectionList()) {
                List<String> idpList = IdpIdCookieSupport.getIdpList();
                IdpSelector.renderIdpSelectionPage(req, resp, idpList, false);
                return null;
            }
            if (partnerIdpId != null) {
                return this.processIdpConnection(partnerIdpId, req, resp, ctx);
            }
        } else if (ProprietaryURLParams.getParam(req, "SpSessionAuthnAdapterId") != null || ProprietaryURLParams.getParam(req, "TargetResource") != null || ProprietaryURLParams.getParam(req, "TARGET") != null) {
            return this.processAuthnPolicyOrSession(null, req, resp, null);
        }
        AuditLogger.setStatus("failure");
        SpAuditLogger.setEvent("SSO");
        String msg = "/sp/startSSO.ping missing required parameter";
        AuditLogger.setDescription(msg);
        SpAuditLogger.log(msg);
        this.renderMissingReqParameterException(req, resp, isUsingAuthnPolicy);
        return null;
    }

    private boolean isVirtualAdapterRequested(HttpServletRequest req) {
        String spAdapterId = ProprietaryURLParams.getParam(req, "SpSessionAuthnAdapterId");
        if (spAdapterId == null) {
            return false;
        }
        AuthnAdapterInstance spInstance = MgmtFactory.getAdapterManager().getSpAuthnAdapterInstance(spAdapterId);
        return spInstance != null && spInstance.isVirtualInstance();
    }

    private void renderMissingReqParameterException(HttpServletRequest req, HttpServletResponse resp, boolean isAuthnPolicyEnabled) throws IOException {
        String[] errorDetailParameters = new String[]{"PartnerIdpId", "SpSessionAuthnAdapterId", "TargetResource"};
        String error = "INVALID_REQUEST_PARAMETER";
        String errorKey = isAuthnPolicyEnabled ? "errorDetail.createSsoRequest.missingStartParameter.withAuthnPolicy" : "errorDetail.createSsoRequest.missingStartParameter";
        String errorDetail = LocaleUtil.getLocalizedString(req, "pingfederate-messages", errorKey, errorDetailParameters);
        String inErrorResource = ProprietaryURLParams.getParam(req, "InErrorResource");
        boolean inErrorValidationFailed = false;
        if (!StringUtils.isBlank((String)inErrorResource)) {
            try {
                TargetResourceValidationMgr redirectValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);
                redirectValidationMgr.validateInErrorResource(inErrorResource);
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("error", error);
                paramsMap.put("errorDetail", errorDetail);
                inErrorResource = Util.appendQueryParams(inErrorResource, paramsMap);
                resp.sendRedirect(inErrorResource);
            }
            catch (InvalidRedirectValidationException ex) {
                inErrorValidationFailed = true;
            }
        }
        if (StringUtils.isBlank((String)inErrorResource) || inErrorValidationFailed) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("error", error);
            params.put("errorDetail", errorDetail);
            params.put("exceptionMessage", "");
            params.put("errorText", "");
            ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
            renderer.render(req, resp, "sp.sso.error.page.template.html", params);
        }
    }

    public OutMessageContext processIdpConnection(String partnerIdpId, HttpServletRequest req, HttpServletResponse resp, OutMessageContext ctx) throws IOException {
        IdpConnection idpConnection = MetadataSupport.getIdpConnection(partnerIdpId);
        String adapterId = req.getParameter("SpSessionAuthnAdapterId");
        String targetResource = ProprietaryURLParams.getParam(req, "TargetResource", "TARGET");
        String inErrorResource = ProprietaryURLParams.getParam(req, "InErrorResource");
        ctx.setEntityId(partnerIdpId);
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)ctx, req).getVirtualEntityId(DomainMode.RUNTIME);
        ctx.setVirtualServerId(virtualServerId);
        SpAuditLogger.setVirtualServerId(virtualServerId);
        if (adapterId != null) {
            HashSet<String> allowedAdapterIds = new HashSet<String>();
            Collection<TargetAttributeMapping> adapterMappings = idpConnection.getTargetAttributeMappings();
            for (TargetAttributeMapping mapping : adapterMappings) {
                if (virtualServerId != null && mapping.isRestrictVirtualServerIds() && !mapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
                allowedAdapterIds.add(mapping.getBaseAdapterInstanceId());
            }
            if (allowedAdapterIds.contains(adapterId)) {
                ctx.setAdapterId(adapterId);
            }
        }
        ctx.setTargetResource(targetResource);
        ctx.setInErrorResource(inErrorResource);
        AuthnPolicy authnPolicy = CreateSsoRequest.getAuthnPolicy(req);
        IdpConnHashableAuthnBean session = (IdpConnHashableAuthnBean)IdpSessionRegistrySupport.getRegisteredAuthnSession(req, resp, null, new IdpConnAuthnSourceKey(idpConnection.getId()), null, virtualServerId, authnPolicy);
        if (session != null) {
            IdpAuditLogger.logAuthnSession("Using existing authentication session", IdpAuditLogger.AuthnSessionEvent.EVENT_AUTHN_SESSION_USE_EXISTING, session);
            ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"SP");
            SpAuditLogger.setPartnerId(idpConnection.getEntityId());
            SpAuditLogger.setProtocol(idpConnection.getProtocol().toString());
            return this.processAuthnPolicyOrSession(ctx, req, resp, session);
        }
        return this.completeBasicSsoReqCtx(req, resp, idpConnection, ctx, authnPolicy);
    }

    public static AuthnPolicy getAuthnPolicy(HttpServletRequest req) {
        return CreateSsoRequest.getAuthnPolicy(CreateSsoRequest.getAuthnPolicyParams(req));
    }

    public OutMessageContext completeBasicSsoReqCtx(HttpServletRequest req, HttpServletResponse resp, IdpConnection idpConnection, OutMessageContext ctx, AuthnPolicy authnPolicy) {
        EndpointGroup singleSignOnServices;
        Endpoint parEndpoint;
        LicenseManager.checkLicenseForConnection(idpConnection);
        Protocol protocol = idpConnection.getProtocol();
        Endpoint endpoint = parEndpoint = idpConnection.getOidcSettings() == null ? null : idpConnection.getOidcSettings().getPushedAuthorizationRequestEndpoint();
        if (Protocol.OIDC.equals(protocol) && parEndpoint != null && StringUtils.isNotEmpty((String)parEndpoint.getFullLocation())) {
            Endpoint parEndpointWithBinding = new Endpoint("oauth:par", idpConnection.getOidcSettings().getPushedAuthorizationRequestEndpoint().getFullLocation());
            singleSignOnServices = new EndpointGroup(parEndpointWithBinding);
        } else {
            singleSignOnServices = idpConnection.getSingleSignOnServices();
        }
        if (singleSignOnServices == null || Util.isEmpty(singleSignOnServices.getEndpoints())) {
            String s = "No SSO profile configured for " + idpConnection.getEntityId() + " to start the SSO process.";
            throw new ProcessRuntimeException(s);
        }
        Endpoint singleSignOnService = singleSignOnServices.getPrimaryEndpoint();
        ctx.setBinding(singleSignOnService.getBinding());
        ctx.setEndpoint(singleSignOnService.getFullLocation());
        SSOStarter ssoStarter = this.starters.get(protocol);
        if (ssoStarter == null) {
            throw new ProcessRuntimeException("Local support not enabled for protocol " + protocol);
        }
        OutMessageContext outCtx = ssoStarter.startSso(req, resp, ctx, idpConnection, authnPolicy);
        outCtx.populateOutUrlAuditLogParameter();
        outCtx.populateRequestJtiAuditLogParameter();
        this.auditAuthnAttempt(idpConnection);
        return outCtx;
    }

    private void auditAuthnAttempt(IdpConnection idpConnection) {
        AuditLogger.setAuthnSourceId(idpConnection);
        SpAuditLogger.logAuthnAttempt("Attempting authentication with IdP partner");
        SpAuditLogger.cleanupAuthnAttempt();
    }

    public void setSSOStarter(Protocol protocol, SSOStarter starter) {
        this.starters.put(protocol, starter);
    }

    private OutMessageContext processAuthnPolicyOrSession(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, IdpConnHashableAuthnBean session) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String spAdapterId = ProprietaryURLParams.getParam(req, "SpSessionAuthnAdapterId");
        params.put("SpSessionAuthnAdapterId", spAdapterId);
        String targetResource = ProprietaryURLParams.getParam(req, "TargetResource");
        if (targetResource == null) {
            targetResource = ProprietaryURLParams.getParam(req, "TARGET");
        }
        params.put("TARGET", targetResource);
        String errorResource = ProprietaryURLParams.getParam(req, "InErrorResource");
        params.put("InErrorResource", errorResource);
        String vsid = VirtualIdentityUtil.extractVsid(req);
        params.put("chainedVsid", vsid);
        String policyAction = ProprietaryURLParams.getParam(req, "PolicyAction");
        params.put("PolicyAction", policyAction);
        params.put("AccountLinking", ProprietaryURLParams.getParam(req, "AccountLinking"));
        this.addTrackedParams(req, params);
        if (session != null) {
            params.put(AUTHN_SESSION_KEY, session);
        }
        params.putAll(CreateSsoRequest.getAuthnPolicyParams(req));
        return this.resume(reqMsgCtx, req, resp, params);
    }

    private static AuthnPolicy getAuthnPolicy(Map<String, Object> params) {
        LinkedHashSet<String> requestedAuthnContextsSet = new LinkedHashSet<String>();
        String[] authnCtxClassRefs = (String[])params.get("RequestedAuthnCtx");
        if (authnCtxClassRefs != null) {
            requestedAuthnContextsSet.addAll(Arrays.asList(authnCtxClassRefs));
        }
        boolean isPassive = Boolean.parseBoolean((String)params.get("IsPassive"));
        boolean forceAuthn = Boolean.parseBoolean((String)params.get("ForceAuthn"));
        AuthnPolicy authnPolicy = new AuthnPolicy(!isPassive, forceAuthn, new ArrayList(requestedAuthnContextsSet));
        return authnPolicy;
    }

    private static Map<String, Object> getAuthnPolicyParams(HttpServletRequest req) {
        String forceAuthn;
        String isPassive;
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] authnCtxClassRefs = req.getParameterValues("RequestedAuthnCtx");
        if (authnCtxClassRefs != null) {
            params.put("RequestedAuthnCtx", authnCtxClassRefs);
        }
        if ((isPassive = req.getParameter("IsPassive")) != null) {
            params.put("IsPassive", isPassive);
        }
        if ((forceAuthn = req.getParameter("ForceAuthn")) != null) {
            params.put("ForceAuthn", forceAuthn);
        }
        return params;
    }

    @Override
    protected OutMessageContext doResume(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, GeneralAdapterException {
        this.resumeAuthnPolicyOrSession(reqMsgCtx, req, resp, params);
        return null;
    }

    private void resumeAuthnPolicyOrSession(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, GeneralAdapterException {
        block4: {
            try {
                SpAuditLogger.setEvent("SSO");
                this.doResumeAuthnPolicyOrSession(reqMsgCtx, req, resp, params);
            }
            catch (Exception e) {
                SpAuditLogger.setStatus("failure");
                SpAuditLogger.setDescription(e.getMessage());
                SpAuditLogger.log(e.getMessage());
                if (!(e.getCause() instanceof QuietException)) {
                    this.logEx(e);
                }
                String errorResource = (String)params.get("InErrorResource");
                String spAdapterId = (String)params.get("SpSessionAuthnAdapterId");
                if (spAdapterId == null) {
                    spAdapterId = "Unknown";
                }
                if (resp.isCommitted()) break block4;
                this.idpRespSupport.handleException(e, req, resp, params, errorResource, spAdapterId, null, null, Role.SP);
            }
        }
    }

    private void logEx(Exception e) {
        if (!(e instanceof QuietException)) {
            this.log.error((Object)"Unexpected error.", (Throwable)e);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)e.getMessage());
        }
    }

    private void doResumeAuthnPolicyOrSession(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, AuthnProcessorException, AuthorizationException, AuthnFailedException, AuthnAdapterException, AttrLookupException, AccountLinkingServiceException {
        TargetSessionId targetSessionId = this.getTargetSessionId(params);
        SpAuditLogger.setTargetSessionId(targetSessionId);
        SsoContext ssoContext = (SsoContext)params.get(SSO_CTX_KEY);
        if (ssoContext == null) {
            IdpAuthenticationResult authnResult = this.getAuthnResultFromSession(reqMsgCtx, req, params);
            if (authnResult == null) {
                String resumePath = this.saveState(req, resp, reqMsgCtx, params);
                authnResult = this.authnSupport.lookupAuthNs(req, resp, CreateSsoRequest.getAuthnPolicy(params), resumePath, params, null, reqMsgCtx, this, false);
            }
            if (authnResult != null && !Util.isEmpty(authnResult.getAuthnAttrs())) {
                this.checkLicense(authnResult, targetSessionId);
            }
            if (resp.isCommitted()) {
                return;
            }
            this.checkAuthn(authnResult);
            String targetUrl = this.getTargetUrl(authnResult, params);
            if (this.checkDoAccountLinking(reqMsgCtx, req, resp, params, targetSessionId, targetUrl)) {
                return;
            }
            this.addTargetUrlToAttributes(authnResult.getAuthnAttrs(), targetUrl);
            AttributeValue authnCtxValue = this.idpRespSupport.getAuthnCtxFromAuthnAttrs(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans(), "unspecified");
            AttributeMap mappedAttributes = this.mapAttributes(req, resp, params, authnResult, authnCtxValue, targetSessionId);
            if (this.getSessionBean(params) != null) {
                SpAuditLogger.setUserName((Map<String, AttributeValue>)authnResult.getAuthnAttrs());
                SpAuditLogger.setAttributes(authnResult.getAuthnAttrs().toString());
            } else {
                IdpAuditLoggerSupport.getInstance().constructAuditId(authnResult);
                IdpAuditLogger.setAttributes(mappedAttributes.toString());
            }
            ssoContext = this.createSsoCtx(targetUrl, authnResult, authnCtxValue, mappedAttributes);
            params.put(SSO_CTX_KEY, ssoContext);
        }
        String resumePath = this.saveState(req, resp, reqMsgCtx, params);
        SpHashableAuthnBean spAuthnBean = this.getSpAdapterSupport(params).createAuthN(ssoContext, req, resp, targetSessionId, resumePath, reqMsgCtx, null, this.getSessionBean(params));
        if (SpAdapterSupportBase.isCreateAuthnComplete(req, resp)) {
            this.checkRegisterSessionForSLO(spAuthnBean, targetSessionId, params);
            this.spRespSupport.finishAndRedirect(req, resp, ssoContext, false);
        }
    }

    private boolean checkDoAccountLinking(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, TargetSessionId targetSessionId, String targetUrl) throws AccountLinkingServiceException, AuthnAdapterException, IOException {
        IdpConnHashableAuthnBean idpConnBean = this.getSessionBean(params);
        if (idpConnBean == null) {
            return false;
        }
        IdpConnection idpConnection = this.metadataDirectory.getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), true);
        return this.spRespSupport.accountLinking(idpConnection, idpConnBean.getVirtualServerId(), idpConnBean.getAssertionAttrs(), null, params, targetSessionId, targetUrl, req, resp, reqMsgCtx, this);
    }

    private void checkRegisterSessionForSLO(SpHashableAuthnBean spAuthnBean, TargetSessionId targetSessionId, Map<String, Object> params) {
        IdpConnHashableAuthnBean idpConnBean = this.getSessionBean(params);
        if (idpConnBean != null) {
            IdpConnection idpConnection = this.metadataDirectory.getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), true);
            if (this.sloSupport.checkRegisterSpAuthnBean(idpConnection, targetSessionId)) {
                SpSessionRegistrySupport.registerSessionReceived(spAuthnBean, idpConnBean);
            }
        } else if (this.sloSupport.checkRegisterSpAuthnBean(null, targetSessionId)) {
            SpSessionRegistrySupport.registerAuthnBean(spAuthnBean);
        }
    }

    private SpAdapterSupportBase getSpAdapterSupport(Map<String, Object> params) {
        if (this.getSessionBean(params) != null) {
            return this.spAdapterSupport;
        }
        return this.apc2SpaAdapterSupport;
    }

    private IdpConnHashableAuthnBean getSessionBean(Map<String, Object> params) {
        return (IdpConnHashableAuthnBean)params.get(AUTHN_SESSION_KEY);
    }

    private IdpAuthenticationResult getAuthnResultFromSession(OutMessageContext reqMsgCtx, HttpServletRequest req, Map<String, Object> params) {
        IdpConnHashableAuthnBean session = this.getSessionBean(params);
        if (session == null) {
            return null;
        }
        return new IdpAuthenticationResult(new IdpHashableAuthnBean[]{session}, session.getAssertionAttrs(), false, reqMsgCtx.getEntityId());
    }

    private void addTargetUrlToAttributes(AttributeMap sourceAttrs, String targetUrl) {
        if (targetUrl != null) {
            sourceAttrs.put("TargetResource", new AttributeValue(targetUrl));
        }
    }

    private void checkLicense(IdpAuthenticationResult authnResult, TargetSessionId targetSessionId) {
        LicenseManager.checkLicenseForConnection(this.getLicenseObject(authnResult, targetSessionId));
    }

    private LicenseObject getLicenseObject(IdpAuthenticationResult authnResult, TargetSessionId targetSessionId) {
        if (authnResult.isFromAuthnSelectionApc()) {
            return this.apc2SpaManager.getMapping(authnResult.getSourceMappingId(), targetSessionId.getId());
        }
        AuthnSourceKey lastAuthnSourceKey = authnResult.getLastAuthnSourceKey();
        switch (lastAuthnSourceKey.getType()) {
            case ADAPTER: {
                return this.a2aManager.getMapping(lastAuthnSourceKey.getId(), targetSessionId.getId());
            }
            case IDP_CONN: {
                return this.metadataDir.getIdpConnectionBySystemId(lastAuthnSourceKey.getId(), false);
            }
        }
        return null;
    }

    private SsoContext createSsoCtx(String targetUrl, IdpAuthenticationResult authnResult, AttributeValue authnCtxValue, AttributeMap mappedAttrs) {
        String partnerEntityId = authnResult.getSourceMappingId();
        Calendar instantCal = this.idpRespSupport.getAuthnInstantValue(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans());
        Date authnInstant = instantCal.getTime();
        return new SsoContext(mappedAttrs, null, null, partnerEntityId, targetUrl, authnCtxValue.getValue(), authnInstant);
    }

    private TargetSessionId getTargetSessionId(Map<String, Object> params) throws IOException {
        TargetSessionId targetSessionId = (TargetSessionId)params.get(TARGET_SESSION_ID_KEY);
        if (targetSessionId != null) {
            return targetSessionId;
        }
        String spAdapterId = (String)params.get("SpSessionAuthnAdapterId");
        if (!StringUtils.isBlank((String)spAdapterId)) {
            targetSessionId = new TargetSessionId(TargetSessionId.TargetSessionType.ADAPTER, spAdapterId);
        } else {
            IdpConnHashableAuthnBean session = this.getSessionBean(params);
            if (session != null) {
                targetSessionId = this.getTargetSessionIdForSession(session, params);
            } else {
                String targetUrl = (String)params.get("TARGET");
                if (!StringUtils.isBlank((String)targetUrl)) {
                    List<TargetSessionId> targetSessionIds = this.urlAdapterUtil.mapToTargetIds(targetUrl);
                    for (TargetSessionId mappedTargetSessionId : targetSessionIds) {
                        if (mappedTargetSessionId.getType() != TargetSessionId.TargetSessionType.ADAPTER) continue;
                        spAdapterId = mappedTargetSessionId.getId();
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug((Object)("No SpSessionAuthnAdapterId specified so mapped from " + targetUrl + " to " + spAdapterId));
                        break;
                    }
                }
                if (StringUtils.isBlank((String)spAdapterId)) {
                    throw new ProcessRuntimeException("Unable to determine SP Adapter - please specify a SpSessionAuthnAdapterId parameter or ensure that the given TargetResource parameter (or default) maps to a SP Adapter Instance ID");
                }
                params.put("SpSessionAuthnAdapterId", spAdapterId);
                targetSessionId = new TargetSessionId(TargetSessionId.TargetSessionType.ADAPTER, spAdapterId);
            }
        }
        params.put(TARGET_SESSION_ID_KEY, targetSessionId);
        return targetSessionId;
    }

    private String getTargetUrl(IdpAuthenticationResult authnResult, Map<String, Object> params) {
        String targetUrl = (String)params.get("TARGET");
        if (StringUtils.isBlank((String)targetUrl)) {
            String spAdapterId = (String)params.get("SpSessionAuthnAdapterId");
            if (authnResult.isFromAuthnSelectionApc()) {
                targetUrl = this.apc2SpaManager.getTargetUrl(authnResult.getSourceMappingId(), spAdapterId);
            } else {
                AuthnSourceKey lastAuthnSourceKey = authnResult.getLastAuthnSourceKey();
                switch (lastAuthnSourceKey.getType()) {
                    case ADAPTER: {
                        targetUrl = this.a2aManager.getTargetUrl(lastAuthnSourceKey.getId(), spAdapterId);
                        break;
                    }
                    case IDP_CONN: {
                        IdpConnection idpConn = this.metadataDir.getIdpConnectionBySystemId(lastAuthnSourceKey.getId(), false);
                        targetUrl = idpConn.getDefaultTargetResource();
                        break;
                    }
                }
            }
            if (StringUtils.isBlank((String)targetUrl)) {
                targetUrl = this.localMetaData.getApplicationURL("sp.after.sso");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("No TargetResource parameter specified so using default: " + targetUrl));
                }
            }
        }
        return targetUrl;
    }

    private TargetSessionId getTargetSessionIdForSession(IdpConnHashableAuthnBean session, Map<String, Object> params) throws IOException {
        IdpConnection idpConn = this.metadataDir.getIdpConnectionBySystemId(session.getAuthnSourceKey().getId(), true);
        String targetUrl = this.getTargetUrl(params, idpConn);
        return this.spRespSupport.getTargetSessionId(null, targetUrl, idpConn, session.getVirtualServerId());
    }

    private String getTargetUrl(Map<String, Object> params, IdpConnection idpConn) {
        String targetUrl = (String)params.get("TARGET");
        if (StringUtils.isBlank((String)targetUrl)) {
            targetUrl = idpConn.getDefaultTargetResource();
        }
        if (StringUtils.isBlank((String)targetUrl)) {
            targetUrl = this.localMetaData.getApplicationURL("sp.after.sso");
        }
        return targetUrl;
    }

    private void checkAuthn(IdpAuthenticationResult authnResult) throws AuthnFailedException {
        if (authnResult == null) {
            throw new AuthnFailedException();
        }
    }

    private AttributeMap mapAttributes(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, IdpAuthenticationResult authnResult, AttributeValue authnCtxValue, TargetSessionId targetSessionId) throws AttrLookupException, AuthorizationException {
        AttributeMap contextAttributes = this.getContextAttributes(req, resp, authnResult, authnCtxValue, params);
        if (targetSessionId.getType() == TargetSessionId.TargetSessionType.SP_CONN) {
            IdpConnHashableAuthnBean idpConnBean = this.getSessionBean(params);
            if (idpConnBean == null) {
                throw new ProcessRuntimeException("Unexpected error: target is SP connection but session bean not found");
            }
            IdpConnection idpConnection = this.metadataDirectory.getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), true);
            String contractId = MgmtFactory.getC2cContractManager().findMappedContractId(idpConnection, targetSessionId.getId());
            if (contractId == null) {
                throw new ProcessRuntimeException("No APC found for IdP connection " + idpConnection.getEntityId() + " and SP connection " + targetSessionId.getId());
            }
            AttributeMap mappedAttributes = idpConnection.executeC2cMapping(authnResult.getAuthnAttrs(), contractId, contextAttributes);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Mapped APC Attributes: " + mappedAttributes));
            }
            return mappedAttributes;
        }
        if (targetSessionId.getType() == TargetSessionId.TargetSessionType.ADAPTER) {
            String spAdapterId = targetSessionId.getId();
            if (authnResult.isFromAuthnSelectionApc()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Executing mapping from APC '" + authnResult.getSourceMappingId() + "' to SP adapter '" + spAdapterId + "'"));
                }
                if (MgmtFactory.getAdapterManager().getSpAuthnAdapter(spAdapterId) instanceof VirtualAuthnAdapter) {
                    return authnResult.getAuthnAttrs();
                }
                Object spAdapterMapping = this.apc2SpaManager.getMapping(authnResult.getSourceMappingId(), spAdapterId);
                return ((AttributeMapping)spAdapterMapping).executeMapping(authnResult.getAuthnAttrs(), null, contextAttributes);
            }
            AuthnSourceKey lastAuthnSourceKey = authnResult.getLastAuthnSourceKey();
            switch (lastAuthnSourceKey.getType()) {
                case ADAPTER: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Executing mapping from IdP adapter '" + lastAuthnSourceKey.getId() + "' to SP adapter '" + spAdapterId + "'"));
                    }
                    Object spAdapterMapping = this.a2aManager.getMapping(lastAuthnSourceKey.getId(), spAdapterId);
                    return ((AttributeMapping)spAdapterMapping).executeMapping(authnResult.getAuthnAttrs(), null, contextAttributes);
                }
                case IDP_CONN: {
                    IdpConnection idpConn = this.metadataDir.getIdpConnectionBySystemId(lastAuthnSourceKey.getId(), false);
                    if (idpConn == null) break;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Executing mapping from IdP connection '" + idpConn.getEntityId() + "' to SP adapter '" + spAdapterId + "'"));
                    }
                    return idpConn.executeAdapterMapping(authnResult.getAuthnAttrs(), spAdapterId, contextAttributes);
                }
            }
            throw new ProcessRuntimeException("Unable to find SP Adapter mapping");
        }
        throw new ProcessRuntimeException("Unexpected target session type: " + targetSessionId.getType());
    }

    protected AttributeMap getContextAttributes(HttpServletRequest req, HttpServletResponse resp, IdpAuthenticationResult authnResult, AttributeValue authnCtxValue, Map<String, Object> params) {
        AttributeMap contextAttributes = new AttributeMap();
        IdpConnHashableAuthnBean bean = this.getSessionBean(params);
        if (bean == null) {
            bean = authnResult.getMappedIdpConnBean();
        }
        if (bean != null) {
            contextAttributes = this.spRespSupport.makeIdpConnContextAttributes(bean, req);
        } else {
            contextAttributes.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
            contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
            contextAttributes.put(SourceContextType.SRI.getId(), SessionIdUtil.getInstance().getExtendedSriV2(req, resp, params));
        }
        contextAttributes.put(SourceContextType.AUTHN_CTX.getId(), authnCtxValue);
        LinkedList authenticatingAuthorities = (LinkedList)params.get("authnAuthorityEntityIds");
        if (!Util.isEmpty(authenticatingAuthorities)) {
            contextAttributes.put(SourceContextType.AUTHENTICATING_AUTHORITY.getId(), new AttributeValue((Collection)authenticatingAuthorities));
        }
        return contextAttributes;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }

    @Override
    public void resumeAuthn(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws IOException {
        try {
            this.doResume(outMsgCtx, req, resp, otherState);
        }
        catch (GeneralAdapterException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void resumeSsoFromIdp(IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, InMessageContext reqInMsgCtx, OutMessageContext respOutMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue) throws PseudonymServiceException, RequestProcessingException {
        throw new UnsupportedOperationException();
    }

    private static class AuthnFailedException
    extends Exception
    implements QuietException,
    ErrorCodeException {
        private static final long serialVersionUID = 1L;

        private AuthnFailedException() {
        }

        @Override
        public String getMessage() {
            return "Authentication Failed";
        }

        @Override
        public String getErrorCode() {
            return "AUTHENTICATION_FAILED";
        }

        @Override
        public String getErrorDetail() {
            return "errorDetail.authenticationFailed";
        }

        @Override
        public String[] getErrorDetailParameters() {
            return null;
        }
    }
}

