/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp;

import com.pingidentity.common.util.CookieMonster;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.util.filter.ConnectionFilter;
import org.sourceid.saml20.domain.util.filter.FilterCriteria;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.SPLocalPathMappings;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;

public class IdpIdCookieSupport {
    private static ConfigStore config = ConfigStoreFarm.getConfig(IdpIdCookieSupport.class);
    private static boolean enableIdpIdCookie = config.getBooleanValue("EnableIdpIdCookie", false);
    private static String idpIdCookieName = config.getStringValue("IdpIdCookieName", "IdpId");
    private static int idpIdCookieLifeTimeInDays = config.getIntValue("IdpIdCookieLifeTimeInDays", 365);
    private static boolean showIdpSelectionList = config.getBooleanValue("ShowIdpSelectionList", true);
    private static int idpIdCookieLifeTimeInSecs = idpIdCookieLifeTimeInDays * 24 * 3600;
    private static Log log = LogFactory.getLog(IdpIdCookieSupport.class);
    private static MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private static MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    public static boolean isEnableIdpIdCookie() {
        return enableIdpIdCookie;
    }

    public static boolean isShowIdpSelectionList() {
        return showIdpSelectionList;
    }

    public static void writeIdpIdCookie(HttpServletResponse response, String idpId) {
        if (enableIdpIdCookie && idpId != null && IdpIdCookieSupport.isSpInitSsoEnabled(idpId) && idpIdCookieLifeTimeInSecs > 0) {
            String hexIdpId;
            try {
                hexIdpId = new String(Hex.encodeHex((byte[])idpId.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            String idpIdCookiePath = IdpIdCookieSupport.getIdpIdCookiePath();
            Cookie cookie = new Cookie(idpIdCookieName, hexIdpId);
            cookie.setMaxAge(idpIdCookieLifeTimeInSecs);
            if (StringUtils.isNotBlank((String)idpIdCookiePath)) {
                cookie.setPath(idpIdCookiePath);
            }
            response.addCookie(cookie);
        }
    }

    private static String getIdpIdCookiePath() {
        SPLocalPathMappings spLocalPaths = metadataLocal.getSpLocalPathMappings();
        String initiateSsoPath = spLocalPaths.getInitiateSSOPath();
        if (initiateSsoPath.lastIndexOf("/") == -1) {
            return "";
        }
        return initiateSsoPath.substring(0, initiateSsoPath.lastIndexOf("/"));
    }

    private static boolean isSpInitSsoEnabled(String idpId) {
        IdpConnection idpConnection = metadataDirectory.getIdpConnection(idpId, false);
        return idpConnection != null && idpConnection.getEnabledProfiles().isSpInitiatedSSOEnabled();
    }

    public static String getIdpIdFromCookie(HttpServletRequest req) {
        String hexIdpId;
        String idpId = null;
        if (enableIdpIdCookie && (hexIdpId = CookieMonster.getCookieValue(idpIdCookieName, req)) != null) {
            try {
                idpId = new String(Hex.decodeHex((char[])hexIdpId.toCharArray()), StandardCharsets.UTF_8);
                if (!IdpIdCookieSupport.isSpInitSsoEnabled(idpId)) {
                    log.info((Object)("Invalid idpid cookie " + idpId));
                    idpId = null;
                }
            }
            catch (DecoderException e) {
                log.info((Object)("Error decoding idpid cookie " + e.getMessage()));
                idpId = null;
            }
        }
        return idpId;
    }

    public static List<String> getIdpList() {
        FilterCriteria criteria = new FilterCriteria();
        criteria.setRoles(Role.IDP);
        criteria.setActive(true);
        criteria.setSpInitSSO(true);
        ConnectionFilter filter = new ConnectionFilter(criteria);
        ArrayList<String> idpList = new ArrayList<String>();
        Collection<IdpConnection> idpConnections = metadataDirectory.getIdpConnections();
        for (ConnectionBase idp : filter.filter(idpConnections)) {
            idpList.add(idp.getEntityId());
        }
        return idpList;
    }

    static {
        log.debug((Object)("enableIdpIdCookie=" + enableIdpIdCookie));
        if (idpIdCookieLifeTimeInDays <= 0) {
            log.info((Object)("Invalid IdpIdCookieLifeTimeInDays=" + idpIdCookieLifeTimeInDays));
        }
    }
}

