/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.Util;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.SPLocalPathMappings;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class IdpSelector {
    private static final String[] QS_PARAMS = new String[]{"SpSessionAuthnAdapterId", "TargetResource", "TARGET", "InErrorResource", "AllowCreate", "IsPassive", "RequestedFormat", "ForceAuthn", "Binding", "RequestedBinding", "RequestedACSIdx", "RequestedAuthnCtx"};
    private static final String VAR_IDP_LIST = "idpList";
    private static final String IDP_SELECTION_TEMPLATE = "sourceid-saml2-idp-selection-template.html";
    private static MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private static ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();

    public static void renderIdpSelectionPage(HttpServletRequest req, HttpServletResponse resp, List<String> idpList, Map<String, Object> params, boolean foundViaCDC) {
        HashMap<String, String> linkTable = IdpSelector.createHyperLinks(idpList, params);
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        objMap.put(VAR_IDP_LIST, linkTable);
        objMap.put("foundViaCDC", foundViaCDC);
        try {
            renderer.render(req, resp, IDP_SELECTION_TEMPLATE, objMap);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Unable to launch a IdP selection page.", ex);
        }
    }

    public static void renderIdpSelectionPage(HttpServletRequest req, HttpServletResponse resp, List<String> idpList, boolean foundViaCDC) {
        Map<String, Object> params = IdpSelector.getRelatedRequestParams(req);
        IdpSelector.renderIdpSelectionPage(req, resp, idpList, params, foundViaCDC);
    }

    private static HashMap<String, String> createHyperLinks(List<String> idpSet, Map<String, Object> params) {
        HashMap<String, String> linkTable = new HashMap<String, String>();
        for (String idp : idpSet) {
            String url = IdpSelector.createAuthnRequestUrl(idp, params);
            url = url.replaceFirst("/", "");
            linkTable.put(idp, url);
        }
        return linkTable;
    }

    public static String createAuthnRequestUrl(String idp, Map<String, Object> params) {
        params.put("PartnerIdpId", idp);
        String queryString = Util.createQueryString(params);
        SPLocalPathMappings spLocalPaths = localMetaData.getSpLocalPathMappings();
        return spLocalPaths.getInitiateSSOPath() + queryString;
    }

    public static Map<String, Object> getRelatedRequestParams(HttpServletRequest req) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String name : QS_PARAMS) {
            String value = req.getParameter(name);
            if (StringUtils.isBlank((String)value)) continue;
            params.put(name, value);
        }
        return params;
    }
}

