/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;

public class SloSupport {
    public static Collection<SpHashableAuthnBean> doCheckConsolidation(Collection<SpHashableAuthnBean> beans) {
        return SloSupport.doConsolidation(beans, ConfigStoreFarm.getConfig("consolidate-logout-by-sp-adapterid"));
    }

    static Collection<SpHashableAuthnBean> doConsolidation(Collection<SpHashableAuthnBean> beans, ConfigStore configStore) {
        Collection beansByAdapterId;
        HashMap targetIdToBeansMap = new HashMap();
        for (SpHashableAuthnBean bean : beans) {
            TargetSessionId targetId = bean.getTargetSessionId();
            beansByAdapterId = (LinkedList<SpHashableAuthnBean>)targetIdToBeansMap.get(targetId);
            if (beansByAdapterId == null) {
                beansByAdapterId = new LinkedList<SpHashableAuthnBean>();
                targetIdToBeansMap.put(targetId, beansByAdapterId);
            }
            beansByAdapterId.add(bean);
        }
        LinkedList<SpHashableAuthnBean> consolidated = new LinkedList<SpHashableAuthnBean>();
        for (Map.Entry e : targetIdToBeansMap.entrySet()) {
            beansByAdapterId = (Collection)e.getValue();
            TargetSessionId currTargetId = (TargetSessionId)e.getKey();
            if (currTargetId.getType() == TargetSessionId.TargetSessionType.ADAPTER && configStore.getBooleanValue(currTargetId.getId(), true)) {
                consolidated.add((SpHashableAuthnBean)beansByAdapterId.iterator().next());
                continue;
            }
            consolidated.addAll(beansByAdapterId);
        }
        return consolidated;
    }
}

