/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp;

import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.templates.mgmt.DefaultTemplateParams;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.handlers.AccessGrantRequestHandler;
import org.sourceid.oauth20.handlers.HandleAuthorizationRequest;
import org.sourceid.oauth20.handlers.OAuthResumableRequestHandlerBase;
import org.sourceid.oauth20.handlers.UserAuthorizationRequestHandler;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.adapter.state.KeyValueStateSupport;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ErrorCodeException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.C2CMappingDbEntryResult;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.sp.LinkingSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupportBase;
import org.sourceid.saml20.profiles.sp.TargetUrlMappingUtil;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.AccountLinkingServiceException;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.StatefulHandler;
import org.sourceid.websso.profiles.sp.ResumeRequestFromResponseSupport;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class SsoRespSupport {
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    public static final String KEY_SSO_CTX = "ssoctx";
    public static final String KEY_TEMP_SSO_CTX = "tmpssoctx";
    public static final String KEY_IDP_CONN_BEAN = "idpConnBean";
    public static final String KEY_TARGET_SESSION_ID = "targetsessionid";
    public static final String KEY_ATTEMPTED_LINK_LOOKUP = "triedit";
    public static final List<AssertionType> EMPTY_ASSERTION20_LIST = Collections.emptyList();
    private final Log log = LogFactory.getLog(this.getClass());
    private final MetadataLocal localMetadata;
    private final TargetUrlMappingUtil urlAdapterUtil = new TargetUrlMappingUtil();
    private final ConnectionManager connectionMgr = MgmtFactory.getConnectionManager();
    private final HandleAuthorizationRequest oauthAuthzHandler = new HandleAuthorizationRequest();
    private final AccessGrantRequestHandler oauthGrantHandler = new AccessGrantRequestHandler();
    private final OAuthResumableRequestHandlerBase oauthUserAuthzHandler = new UserAuthorizationRequestHandler(new KeyValueStateSupport(), MgmtFactory.getDeviceFlowManager(), MgmtFactory.getClientManager(), MgmtFactory.getAccountLockingService().getInstance(UserAuthorizationRequestHandler.class.getSimpleName()), ConfigStoreFarm.getConfig("oauth-device-flow"), MgmtFactory.getOAuthConsentManager(), MgmtFactory.getAuthzServerManager());
    private static TargetResourceValidationMgr redirectValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);

    public SsoRespSupport(MetadataLocal localMetadata) {
        this.localMetadata = localMetadata;
    }

    ErrorCodeException rummage4ErrorCodeException(Throwable e) {
        while (e != null) {
            if (e instanceof ErrorCodeException) {
                return (ErrorCodeException)((Object)e);
            }
            e = e.getCause();
        }
        return null;
    }

    public void handleException(InvalidResponseException e, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String error = "";
        String errorDetail = "";
        ErrorCodeException errCodeEx = this.rummage4ErrorCodeException(e);
        if (errCodeEx != null) {
            error = errCodeEx.getErrorCode();
            errorDetail = LocaleUtil.getLocalizedString(req, "pingfederate-messages", errCodeEx.getErrorDetail(), errCodeEx.getErrorDetailParameters());
        }
        if (ResumeRequestFromResponseSupport.handleException(e, errCodeEx, reqMsgCtx, req, resp)) {
            return;
        }
        String inErrorResource = this.getInErrorResource(reqMsgCtx, respMsgCtx);
        boolean inErrorValidationFailed = false;
        if (!StringUtils.isBlank((String)inErrorResource)) {
            try {
                redirectValidationMgr.validateInErrorResource(inErrorResource);
                if (errCodeEx != null) {
                    HashMap<String, String> paramsMap = new HashMap<String, String>();
                    paramsMap.put("error", error);
                    paramsMap.put("errorDetail", errorDetail);
                    inErrorResource = Util.appendQueryParams(inErrorResource, paramsMap);
                }
                resp.sendRedirect(inErrorResource);
            }
            catch (InvalidRedirectValidationException ex) {
                inErrorValidationFailed = true;
            }
        }
        if (StringUtils.isBlank((String)inErrorResource) || inErrorValidationFailed) {
            String errorPageMsg;
            String entityId = respMsgCtx.getEntityId();
            Map<String, Object> params = new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.SP).entityId(entityId).build();
            params.put("targetResource", this.getTargetResource(reqMsgCtx, respMsgCtx));
            params.put("connectionID", entityId);
            params.put("entityId", entityId);
            params.put("exception", e);
            params.put("exceptionMessage", errCodeEx != null ? "" : e.getMessage());
            params.put("error", error);
            params.put("errorDetail", errorDetail);
            params.put("fullStackTrace", ExceptionUtil.getStackTrace(e));
            params.put("responseXml", respMsgCtx.getXmlObject());
            try {
                IdpConnection idpConnection = MetadataSupport.getIdpConnection(entityId);
                errorPageMsg = idpConnection.getErrorPageMsg();
            }
            catch (ConfigurationException ce) {
                errorPageMsg = "";
            }
            params.put("errorText", LocaleUtil.getLocalizedString(req, "pingfederate-messages", errorPageMsg, null));
            ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
            renderer.render(req, resp, "sp.sso.error.page.template.html", params);
        }
    }

    private String getTargetResource(OutMessageContext reqMsgCtx, InMessageContext respMsgCtx) {
        String targetResource;
        String string = targetResource = reqMsgCtx != null ? reqMsgCtx.getTargetResource() : respMsgCtx.getTargetResource();
        if (targetResource == null && StringUtils.isBlank((String)(targetResource = this.getConnDefaultTargetResource(respMsgCtx.getEntityId())))) {
            targetResource = this.localMetadata.getApplicationURL("sp.after.sso");
        }
        return targetResource;
    }

    private String getInErrorResource(OutMessageContext reqMsgCtx, InMessageContext respMsgCtx) {
        return reqMsgCtx != null ? reqMsgCtx.getInErrorResource() : respMsgCtx.getInErrorResource();
    }

    public String getTargetUri(OutMessageContext reqMsgCtx, InMessageContext respMsgCtx) {
        String target = this.getConnDefaultTargetResource(respMsgCtx.getEntityId());
        if (StringUtils.isBlank((String)target)) {
            target = this.localMetadata.getApplicationURL("sp.after.sso");
        }
        String relayState = respMsgCtx.getRelayState();
        if (respMsgCtx.isUnsolicitedResponse()) {
            if (!StringUtils.isBlank((String)relayState)) {
                if (relayState.startsWith("/")) {
                    target = relayState;
                } else {
                    try {
                        URI targetURI = new URI(relayState);
                        target = targetURI.toString();
                    }
                    catch (URISyntaxException e) {
                        StringBuilder msg = new StringBuilder("relayState (").append(LogGuard.encode(relayState));
                        msg.append(") of unsolicited response is not a valid target URI. Using Default target (");
                        msg.append(target).append(")");
                        this.log.warn((Object)msg);
                    }
                }
            }
        } else {
            String targetResource = this.getTargetResource(reqMsgCtx, respMsgCtx);
            if (!StringUtils.isBlank((String)targetResource)) {
                target = targetResource;
            }
        }
        return target;
    }

    private String getConnDefaultTargetResource(String entityId) {
        IdpConnection idpConn = this.metadataDirectory.getIdpConnection(entityId, false);
        return idpConn != null ? idpConn.getDefaultTargetResource() : null;
    }

    public String getRequestedUserIdFromCtx(OutMessageContext reqMsgCtx) {
        if (reqMsgCtx == null) {
            return null;
        }
        State originalState = ResumeRequestFromResponseSupport.getSupplementalFedHubState(reqMsgCtx);
        if (originalState != null) {
            return (String)originalState.getParameters().get("chainedUserId");
        }
        return null;
    }

    public TargetSessionId getTargetSessionIdFromCtx(OutMessageContext reqMsgCtx, IdpConnection idpConn) {
        State originalState;
        if (reqMsgCtx == null) {
            return null;
        }
        String adapterId = reqMsgCtx.getAdapterId();
        if (adapterId != null) {
            if (idpConn == null) {
                return new TargetSessionId(TargetSessionId.TargetSessionType.ADAPTER, adapterId);
            }
            AuthnAdapterInstance instance = (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstanceWithConnectionOverride(adapterId, idpConn.getEntityId());
            if (instance != null) {
                return new TargetSessionId(TargetSessionId.TargetSessionType.ADAPTER, instance.getId());
            }
        }
        if ((originalState = ResumeRequestFromResponseSupport.getSupplementalFedHubState(reqMsgCtx)) != null) {
            if (ResumeRequestFromResponseSupport.isAuthnSelectionInProgress(originalState.getParameters())) {
                return new TargetSessionId(TargetSessionId.TargetSessionType.AUTHN_POLICY, null);
            }
            if (this.hasOAuthSuppCtx(reqMsgCtx)) {
                return new TargetSessionId(TargetSessionId.TargetSessionType.OAUTH, null);
            }
            InMessageContext originalInCtx = originalState.getInMsgCtx();
            return new TargetSessionId(TargetSessionId.TargetSessionType.SP_CONN, originalInCtx.getEntityId());
        }
        return null;
    }

    public TargetSessionId getTargetSessionId(TargetSessionId targetId, String targetUrl, IdpConnection idp, String virtualServerId) {
        if (targetId == null && !StringUtils.isBlank((String)targetUrl)) {
            Set<TargetSessionId> allowedTargetIds = this.getAllowedTargetSessionIds(idp, virtualServerId);
            switch (allowedTargetIds.size()) {
                case 0: {
                    throw new ProcessRuntimeException("No SP adapter or SP connection is allowed for this virtual server id: " + virtualServerId);
                }
                case 1: {
                    targetId = allowedTargetIds.iterator().next();
                    break;
                }
                default: {
                    List<TargetSessionId> targetIds = this.urlAdapterUtil.mapToTargetIds(targetUrl, allowedTargetIds, idp);
                    if (targetIds.isEmpty()) {
                        throw new ProcessRuntimeException(String.format("The target URL, %s, did not match any of the patterns associated with any existing adapter or sp connection.", targetUrl));
                    }
                    targetId = targetIds.get(0);
                }
            }
        }
        return targetId;
    }

    public TargetSessionId getSpAdapterTargetSessionId(String targetUrl, IdpConnection idp, String virtualServerId) {
        Set<TargetSessionId> allowedTargetIds = this.getAllowedTargetSessionIds(idp, virtualServerId);
        Set spAdapterTargets = allowedTargetIds.stream().filter(targetId -> targetId.getType() == TargetSessionId.TargetSessionType.ADAPTER).collect(Collectors.toSet());
        switch (spAdapterTargets.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (TargetSessionId)spAdapterTargets.iterator().next();
            }
        }
        if (StringUtils.isBlank((String)targetUrl)) {
            return null;
        }
        List<TargetSessionId> targetIds = this.urlAdapterUtil.mapToTargetIds(targetUrl, allowedTargetIds, idp);
        if (targetIds.isEmpty()) {
            return null;
        }
        return targetIds.get(0);
    }

    public Set<TargetSessionId> getAllowedTargetSessionIds(IdpConnection idp, String virtualServerId) {
        HashSet<TargetSessionId> allowedTargetIds = new HashSet<TargetSessionId>();
        Collection<TargetAttributeMapping> adapterMappings = idp.getTargetAttributeMappings();
        for (TargetAttributeMapping mapping : adapterMappings) {
            if (virtualServerId != null && mapping.isRestrictVirtualServerIds() && !mapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
            allowedTargetIds.add(new TargetSessionId(TargetSessionId.TargetSessionType.ADAPTER, mapping.getAdapterInstanceId()));
        }
        HashSet<String> mappedContractIds = new HashSet<String>();
        HashSet<String> mappedSpConnIds = new HashSet<String>();
        Collection<C2cContractAttributeMapping> c2cMappings = idp.getC2cContractMappings();
        for (C2cContractAttributeMapping mapping : c2cMappings) {
            if (virtualServerId != null && mapping.isRestrictVirtualServerIds() && !mapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
            mappedContractIds.add(mapping.getContractId());
        }
        for (String mappedContractId : mappedContractIds) {
            Collection<C2CMappingDbEntryResult> results = MgmtFactory.getC2CMappingDb().getEntriesByContractId(mappedContractId);
            block3: for (C2CMappingDbEntryResult entry : results) {
                SpConnection conn;
                if (!entry.getConnType().equals((Object)Role.SP) || !entry.getActive() || (conn = this.connectionMgr.getSpConnectionBySystemId(entry.getSystemId())) == null) continue;
                for (C2cContractToAssertionMapping mapping : conn.getC2cMappings()) {
                    if (!mapping.getContractId().equals(mappedContractId) || mapping.isRestrictVirtualServerIds() && virtualServerId != null && !mapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
                    mappedSpConnIds.add(conn.getEntityId());
                    continue block3;
                }
            }
        }
        for (String mappedSpConnId : mappedSpConnIds) {
            allowedTargetIds.add(new TargetSessionId(TargetSessionId.TargetSessionType.SP_CONN, mappedSpConnId));
        }
        return allowedTargetIds;
    }

    public DeviceSharingType getDeviceSharingTypeFromCtx(OutMessageContext reqMsgCtx) {
        State reqState = ResumeRequestFromResponseSupport.getSupplementalFedHubState(reqMsgCtx);
        Map<String, Object> reqParam = new HashMap<String, Object>();
        if (reqState != null) {
            reqParam = reqState.getParameters();
        }
        return IdpSessionRegistrySupport.getDeviceSharingTypeFromStateParams(reqParam);
    }

    public boolean accountLinking(IdpConnection idpConnection, String virtualServerId, AttributeMap assertionAttributes, InMessageContext respMsgCtx, Map<String, Object> params, TargetSessionId targetId, String targetUrl, HttpServletRequest req, HttpServletResponse resp, OutMessageContext reqMsgCtx, StatefulHandler handler) throws AccountLinkingServiceException, IOException, AuthnAdapterException {
        if (!idpConnection.doAccountLinking()) {
            return false;
        }
        if ((targetId.getType() == TargetSessionId.TargetSessionType.OAUTH || targetId.getType() == TargetSessionId.TargetSessionType.AUTHN_POLICY) && (targetId = this.getSpAdapterTargetSessionId(targetUrl, idpConnection, virtualServerId)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Failed to identify SP adapter for account linking");
            }
            return false;
        }
        if (targetId.getType() == TargetSessionId.TargetSessionType.ADAPTER) {
            String partnerEntityId = idpConnection.getEntityId();
            AttributeValue attributeValue = (AttributeValue)assertionAttributes.get((Object)(idpConnection.getProtocol() == Protocol.OIDC ? "sub" : AssertionMapKeys.getNameIdValueKey()));
            String externalIdentifier = attributeValue.getValue();
            AttributeValue nameIdFmtAttrVal = (AttributeValue)assertionAttributes.get((Object)AssertionMapKeys.getNameIdFormatKey());
            if (nameIdFmtAttrVal != null && "urn:oasis:names:tc:SAML:2.0:nameid-format:transient".equals(nameIdFmtAttrVal.getValue())) {
                Object message = "Account linking will not be attempted because a Transient Identifier was received";
                if (respMsgCtx != null) {
                    message = (String)message + ": " + respMsgCtx;
                }
                this.log.warn(message);
            } else {
                String localUserId = null;
                String adapterId = targetId.getId();
                if (params.get(KEY_ATTEMPTED_LINK_LOOKUP) == null) {
                    params.put(KEY_ATTEMPTED_LINK_LOOKUP, true);
                    localUserId = LinkingSupport.lookupLink(partnerEntityId, adapterId, externalIdentifier);
                }
                if (StringUtils.isBlank(localUserId)) {
                    String resumePath = handler.saveState(req, resp, respMsgCtx, reqMsgCtx, params);
                    localUserId = SpAdapterSupportBase.lookupLocalId(req, resp, adapterId, partnerEntityId, resumePath);
                    if (resp.isCommitted()) {
                        return true;
                    }
                    if (StringUtils.isBlank((String)localUserId)) {
                        throw new ProcessRuntimeException("Unable to store account link for " + externalIdentifier + " because local user id lookup returned null or empty string");
                    }
                    LinkingSupport.storeLink(localUserId, partnerEntityId, adapterId, externalIdentifier);
                }
                String localIdSubstitutionKey = IdpConnection.getLocalIdSubstitutionKey();
                this.log.info((Object)("Account Linking - local id: '" + localIdSubstitutionKey + "'='" + localUserId + "'"));
                SpAuditLogger.setLocalUserId(localUserId);
                assertionAttributes.put(localIdSubstitutionKey, new AttributeValue(localUserId));
            }
        }
        return false;
    }

    public String getAuthnCtx(IdpConnHashableAuthnBean bean) {
        AttributeValue attributeValue = bean.getAuthnCtx();
        return attributeValue != null ? attributeValue.getValue("unspecified") : "unspecified";
    }

    public Date getAuthnInst(AttributeMap assertionAttributes) {
        Object objectValue;
        AttributeValue attributeValue = (AttributeValue)assertionAttributes.get((Object)AssertionMapKeys.getAuthnInstantKey());
        Calendar cal = null;
        if (attributeValue != null && (objectValue = attributeValue.getObjectValue()) instanceof Calendar) {
            cal = (Calendar)objectValue;
        }
        return cal == null ? new Date() : cal.getTime();
    }

    public void finishAndRedirect(HttpServletRequest req, HttpServletResponse resp, SsoContext ssoContext, boolean doValidateRedirectUrl) throws IOException {
        SpAuditLogger.setAppUrl(ssoContext.getTargetResourceUrl());
        SpAuditLogger.setPartnerId(ssoContext.getIdpPartnerEntityId());
        SpAuditLogger.setEvent("SSO");
        SpAuditLogger.setStatus("success");
        SpAuditLogger.log("logging into application");
        if (!resp.isCommitted()) {
            this.finishAndRedirect(req, resp, ssoContext.getTargetResourceUrl(), ssoContext.getIdpPartnerEntityId(), doValidateRedirectUrl);
        }
    }

    public void finishAndRedirect(HttpServletRequest req, HttpServletResponse resp, String applicationURL, String connectionID, boolean doValidateRedirectUrl) throws IOException {
        if (!StringUtils.isBlank((String)applicationURL)) {
            if (doValidateRedirectUrl) {
                try {
                    redirectValidationMgr.validateTargetResourceSso(applicationURL, this.getConnDefaultTargetResource(connectionID), "sp.after.sso");
                }
                catch (InvalidRedirectValidationException e) {
                    throw new ProcessRuntimeException(e.getMessage());
                }
            }
            resp.sendRedirect(applicationURL);
        } else {
            ResponseTemplateRenderer renderingThing = ResponseTemplateRenderer.getInstance();
            Map<String, Object> pageParams = new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.SP).entityId(connectionID).build();
            if (StringUtils.isBlank((String)connectionID)) {
                connectionID = "unknown";
            }
            pageParams.put("connectionID", connectionID);
            pageParams.put("entityId", connectionID);
            renderingThing.render(req, resp, "sp.sso.success.page.template.html", pageParams);
        }
    }

    public boolean isResumeOtherHandler(OutMessageContext ssoReqMsgCtx, HttpServletRequest req, HttpServletResponse resp, IdpConnHashableAuthnBean idpConnBean, AttributeMap idpConnCtxAttrs) throws IOException {
        return this.oauthAuthzHandler.resumeFromSso(ssoReqMsgCtx, req, resp, idpConnBean, idpConnCtxAttrs) || this.oauthGrantHandler.resumeFromSso(ssoReqMsgCtx, req, resp, idpConnBean, idpConnCtxAttrs) || this.oauthUserAuthzHandler.resumeFromSso(ssoReqMsgCtx, req, resp, idpConnBean, idpConnCtxAttrs);
    }

    public boolean hasOAuthSuppCtx(OutMessageContext ssoReqMsgCtx) {
        return this.oauthAuthzHandler.hasOAuthSuppCtx(ssoReqMsgCtx) || this.oauthGrantHandler.hasOAuthSuppCtx(ssoReqMsgCtx);
    }

    public Map<String, Object> getOriginalStateParams(OutMessageContext reqMsgCtx, Map<String, Object> stateParams) {
        State originalState = ResumeRequestFromResponseSupport.getSupplementalFedHubState(reqMsgCtx);
        if (originalState != null) {
            return originalState.getParameters();
        }
        return stateParams;
    }

    public boolean isResumeFromException(InvalidResponseException e, OutMessageContext ssoReqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        return this.oauthAuthzHandler.resumeFromException(e, ssoReqMsgCtx, req, resp);
    }

    public AttributeMap executeIdpConnMapping(IdpConnection idpConnection, AttributeMap assertionAttributes, TargetSessionId targetId, AttributeMap contextAttributes) {
        if (targetId.getType() == TargetSessionId.TargetSessionType.ADAPTER) {
            AttributeMap mappedAttributes = idpConnection.executeAdapterMapping(assertionAttributes, targetId.getId(), contextAttributes);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Mapped SP adapter Attributes: " + mappedAttributes));
            }
            return mappedAttributes;
        }
        if (targetId.getType() == TargetSessionId.TargetSessionType.SP_CONN) {
            String contractId = MgmtFactory.getC2cContractManager().findMappedContractId(idpConnection, targetId.getId());
            AttributeMap mappedAttributes = idpConnection.executeC2cMapping(assertionAttributes, contractId, contextAttributes);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Mapped APC Attributes: " + mappedAttributes));
            }
            return mappedAttributes;
        }
        if (targetId.getType() == TargetSessionId.TargetSessionType.AUTHN_POLICY) {
            return assertionAttributes;
        }
        throw new IllegalStateException();
    }

    public AttributeMap makeIdpConnContextAttributes(IdpConnHashableAuthnBean bean, HttpServletRequest req) {
        AttributeValue accessToken;
        String authnCtx = this.getAuthnCtx(bean);
        AttributeMap contextAttributes = new AttributeMap();
        contextAttributes.put(SourceContextType.AUTHN_CTX.getId(), authnCtx);
        contextAttributes.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
        contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        contextAttributes.put(SourceContextType.VIRTUAL_SERVER_ID.getId(), bean.getVirtualServerId());
        contextAttributes.put(SourceContextType.SRI.getId(), bean.getSri());
        if (bean.getAuthenticatingAuthorities() != null && !bean.getAuthenticatingAuthorities().isEmpty()) {
            AttributeValue authnAuthoritiesAttributeValue = new AttributeValue(bean.getAuthenticatingAuthorities());
            contextAttributes.put(SourceContextType.AUTHENTICATING_AUTHORITY.getId(), authnAuthoritiesAttributeValue);
        }
        if ((accessToken = (AttributeValue)bean.getAssertionAttrs().get((Object)"access_token")) != null) {
            contextAttributes.put(SourceContextType.ACCESS_TOKEN.getId(), accessToken);
        }
        return contextAttributes;
    }
}

