/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning;

import com.pingidentity.common.util.ServiceInformation;
import java.util.List;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.provisioning.ExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.exceptions.SaaSProvisioningException;

public abstract class ExpressProvisioningProcessorBase
implements ExpressProvisioningProcessor,
ServiceInformation {
    private UserProvisioning userProvisioning;
    private AttributeMap evaledUserProvisioningAttrs;
    private AttributeMap attrsFromIdp;
    private AttributeSource source;
    private DataSource dataSource;

    public ExpressProvisioningProcessorBase(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) {
        this.userProvisioning = userProvisioning;
        this.evaledUserProvisioningAttrs = evaledUserProvisioningAttrs;
        this.attrsFromIdp = attrsFromIdp;
        this.source = userProvisioning.getAttributeSource();
        this.dataSource = this.source.getDataSource();
    }

    protected abstract ExpressProvisioningProcessor.ProvisioningStatus doAddUser(UserProvisioning var1, AttributeMap var2, AttributeMap var3) throws SaaSProvisioningException;

    protected abstract ExpressProvisioningProcessor.ProvisioningStatus doModifyUser(UserProvisioning var1, AttributeMap var2, AttributeMap var3) throws SaaSProvisioningException;

    protected abstract boolean doesUserAlreadyExist(UserProvisioning var1, AttributeMap var2, AttributeMap var3);

    protected abstract List<String> doTestAddUser(UserProvisioning var1, AttributeMap var2, AttributeMap var3) throws SaaSProvisioningException;

    public String getServiceName() {
        return "express-provisioning";
    }

    @Override
    public boolean doProvision() throws SaaSProvisioningException {
        if (this.doesUserAlreadyExist(this.userProvisioning, this.evaledUserProvisioningAttrs, this.attrsFromIdp)) {
            if (UserProvisioning.EventTriggerType.AllSAMLAssertions == this.userProvisioning.getEventTrigger()) {
                return this.doModifyUser(this.userProvisioning, this.evaledUserProvisioningAttrs, this.attrsFromIdp) == ExpressProvisioningProcessor.ProvisioningStatus.MODIFY_SUCCESS;
            }
            return true;
        }
        ExpressProvisioningProcessor.ProvisioningStatus status = this.doAddUser(this.userProvisioning, this.evaledUserProvisioningAttrs, this.attrsFromIdp);
        return status == ExpressProvisioningProcessor.ProvisioningStatus.ADD_SUCCESS || status == ExpressProvisioningProcessor.ProvisioningStatus.USER_ALREADY_EXISTS && UserProvisioning.EventTriggerType.NewUserOnly == this.userProvisioning.getEventTrigger();
    }

    @Override
    public List<String> doTestProvision() throws SaaSProvisioningException {
        return this.doTestAddUser(this.userProvisioning, this.evaledUserProvisioningAttrs, this.attrsFromIdp);
    }

    protected AttributeSource getSource() {
        return this.source;
    }

    protected void setSource(AttributeSource source) {
        this.source = source;
    }

    protected UserProvisioning getUserProvisioning() {
        return this.userProvisioning;
    }

    protected void setUserProvisioning(UserProvisioning userProvisioning) {
        this.userProvisioning = userProvisioning;
    }

    protected AttributeMap getEvaledUserProvisioningAttrs() {
        return this.evaledUserProvisioningAttrs;
    }

    protected void setEvaledUserProvisioningAttrs(AttributeMap evaledUserProvisioningAttrs) {
        this.evaledUserProvisioningAttrs = evaledUserProvisioningAttrs;
    }

    protected AttributeMap getAttrsFromIdp() {
        return this.attrsFromIdp;
    }

    protected void setAttrsFromIdp(AttributeMap attrsFromIdp) {
        this.attrsFromIdp = attrsFromIdp;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

