/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.impl.JdbcAttributeSource;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.provisioning.ExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.ExpressProvisioningProcessorBase;
import org.sourceid.websso.profiles.sp.provisioning.exceptions.SaaSProvisioningException;

public abstract class JdbcExpressProvisioningProcessor
extends ExpressProvisioningProcessorBase {
    private static final Log log = LogFactory.getLog(JdbcExpressProvisioningProcessor.class);
    protected static final String ERROR_PROVISIONING = "There was an error provisioning the user.";
    protected static final int TIMEOUT_IN_SEC = 10;
    private List<ResultInfo> columns;
    private String tableName;
    private String schemaName;
    private String storedProcedureName;
    private String uniqueColumnId;
    private String selectedDatasourceName;

    public JdbcExpressProvisioningProcessor(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp, List<ResultInfo> columns) {
        super(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp);
        this.columns = columns;
        this.tableName = this.getSource().getParameter("tableName");
        this.schemaName = this.getSource().getParameter("schema");
        this.storedProcedureName = this.getSource().getParameter("storedProcedure");
        this.uniqueColumnId = this.getSource().getParameter("filter");
        this.selectedDatasourceName = ((JdbcDataSource)this.getSource().getDataSource()).getJndiName();
    }

    protected abstract List<String> doUpdate(List<ResultInfo> var1) throws SaaSProvisioningException;

    protected abstract List<String> doInsert(List<ResultInfo> var1) throws SaaSProvisioningException;

    protected abstract List<String> loadResultInfoColumnList(List<ResultInfo> var1, AttributeMap var2) throws SaaSProvisioningException;

    protected List<String> insert(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) throws SaaSProvisioningException {
        this.loadResultInfoColumnList(this.columns, evaledUserProvisioningAttrs);
        return this.doInsert(this.columns);
    }

    protected List<String> update(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) throws SaaSProvisioningException {
        this.uniqueColumnId = this.getSource().getParameter("filter");
        this.loadResultInfoColumnList(this.columns, evaledUserProvisioningAttrs);
        return this.doUpdate(this.columns);
    }

    protected List<String> callStoredProcedure(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) throws SaaSProvisioningException {
        this.loadResultInfoColumnList(this.columns, evaledUserProvisioningAttrs);
        return this.doCallStoredProcedure(this.columns);
    }

    protected synchronized List<String> doCallStoredProcedure(List<ResultInfo> listToInsert) throws SaaSProvisioningException {
        return null;
    }

    @Override
    protected ExpressProvisioningProcessor.ProvisioningStatus doAddUser(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) throws SaaSProvisioningException {
        this.insert(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp);
        return ExpressProvisioningProcessor.ProvisioningStatus.ADD_SUCCESS;
    }

    @Override
    protected List<String> doTestAddUser(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) throws SaaSProvisioningException {
        return this.insert(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp);
    }

    @Override
    protected ExpressProvisioningProcessor.ProvisioningStatus doModifyUser(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) throws SaaSProvisioningException {
        this.update(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp);
        return ExpressProvisioningProcessor.ProvisioningStatus.MODIFY_SUCCESS;
    }

    @Override
    protected boolean doesUserAlreadyExist(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) {
        AttributeMap m = this.getUserAttrsFromJdbc(userProvisioning, evaledUserProvisioningAttrs);
        return m != null && m.size() > 0;
    }

    protected AttributeMap getUserAttrsFromJdbc(UserProvisioning userProvisioning, AttributeMap attrsFromIdp) {
        try {
            JdbcAttributeSource attributeSource = (JdbcAttributeSource)userProvisioning.getAttributeSource();
            AttributeMap existingLdapAttrs = attributeSource.executeJdbcAttributeLookupWithUniqueId(attrsFromIdp, new ArrayList<String>());
            return existingLdapAttrs;
        }
        catch (AttrLookupException e) {
            log.error((Object)("There was a problem looking up the user attributes: " + e));
            return null;
        }
    }

    protected List<ResultInfo> getColumns() {
        return this.columns;
    }

    protected void setColumns(List<ResultInfo> columns) {
        this.columns = columns;
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected String getSchemaName() {
        return this.schemaName;
    }

    protected void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    protected String getStoredProcedureName() {
        return this.storedProcedureName;
    }

    protected void setStoredProcedureName(String storedProcedureName) {
        this.storedProcedureName = storedProcedureName;
    }

    protected String getUniqueColumnId() {
        return this.uniqueColumnId;
    }

    protected void setUniqueColumnId(String uniqueColumnId) {
        this.uniqueColumnId = uniqueColumnId;
    }

    public String getSelectedDatasourceName() {
        return this.selectedDatasourceName;
    }

    public void setSelectedDatasourceName(String selectedDatasourceName) {
        this.selectedDatasourceName = selectedDatasourceName;
    }

    public static enum OPERATION {
        INSERT,
        UPDATE,
        DELETE;

    }
}

