/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.ldap.LDAPUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SchemaViolationException;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.impl.LdapAttributeSource;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.ProvisioningException;
import org.sourceid.websso.profiles.sp.provisioning.ExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.ExpressProvisioningProcessorBase;
import org.sourceid.websso.profiles.sp.provisioning.exceptions.SaaSProvisioningException;

public class LdapExpressProvisioningProcessor
extends ExpressProvisioningProcessorBase {
    private static final Log log = LogFactory.getLog(LdapExpressProvisioningProcessor.class);
    private static final String ERROR_PROVISIONING = "There was an error provisioning the user.";
    private static final String ERROR_CODE_46_SUGGESTION_1 = "If the caught exception above was 'LDAP: error code 65 - Object Class Violation' it may be caused by required attributes";
    private static final String ERROR_CODE_46_SUGGESTION_2 = "in the LDAP data store not being fulfilled by the JIT Provisioning attribute mapping.";

    public LdapExpressProvisioningProcessor(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) {
        super(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp);
    }

    @Override
    protected ExpressProvisioningProcessor.ProvisioningStatus doAddUser(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap assertionAttrs) {
        try {
            Attributes attrsToProvisionUser = LDAPUtil.loadAttrs(evaledUserProvisioningAttrs);
            AttributeSource attributeSource = userProvisioning.getAttributeSource();
            LDAPUtil ldapUtil = LDAPUtil.newInstance(attributeSource.getDataSource(), (ServiceInformation)this);
            ldapUtil.addUser(attributeSource, attrsToProvisionUser, assertionAttrs);
            return ExpressProvisioningProcessor.ProvisioningStatus.ADD_SUCCESS;
        }
        catch (NameAlreadyBoundException nabe) {
            log.debug((Object)"The user already exists in the LDAP store.");
            return ExpressProvisioningProcessor.ProvisioningStatus.USER_ALREADY_EXISTS;
        }
        catch (Substituter.UnknownKeyException | ProvisioningException uke) {
            log.error((Object)("There was an error provisioning the user. " + (Exception)uke));
        }
        catch (NamingException ne) {
            log.error((Object)("There was an error provisioning the user. " + ne));
            log.error((Object)ERROR_CODE_46_SUGGESTION_1);
            log.error((Object)ERROR_CODE_46_SUGGESTION_2);
        }
        return ExpressProvisioningProcessor.ProvisioningStatus.ADD_FAILURE;
    }

    @Override
    protected ExpressProvisioningProcessor.ProvisioningStatus doModifyUser(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) {
        BasicAttributes attrsToModifyUser = new BasicAttributes(true);
        try {
            AttributeMap existingLdapAttrs = this.getUserAttrsFromLdap(userProvisioning, attrsFromIdp);
            for (Map.Entry evaledUserProvisioningEntry : evaledUserProvisioningAttrs.entrySet()) {
                String key = (String)evaledUserProvisioningEntry.getKey();
                AttributeValue existingLdapAttrValue = (AttributeValue)existingLdapAttrs.get((Object)key);
                BasicAttribute basicAttr = new BasicAttribute(key);
                Iterable values = ((AttributeValue)evaledUserProvisioningEntry.getValue()).getValues();
                if (existingLdapAttrValue != null && existingLdapAttrValue.getValuesAsHashSet().equals(((AttributeValue)evaledUserProvisioningEntry.getValue()).getValuesAsHashSet())) continue;
                for (String v : values) {
                    basicAttr.add(v);
                    attrsToModifyUser.put(basicAttr);
                }
            }
            if (attrsToModifyUser.size() > 0) {
                AttributeSource attributeSource = userProvisioning.getAttributeSource();
                LDAPUtil ldapUtil = LDAPUtil.newInstance(attributeSource.getDataSource(), (ServiceInformation)this);
                ldapUtil.modifyUser(attributeSource, attrsToModifyUser, attrsFromIdp);
                log.debug((Object)"The LDAP datastore was modified successfully.");
            } else {
                log.debug((Object)"No change to the LDAP datastore was made.  The incoming attributes are identical to those in the datastore.");
            }
            return ExpressProvisioningProcessor.ProvisioningStatus.MODIFY_SUCCESS;
        }
        catch (NoPermissionException npe) {
            log.error((Object)("There was an error provisioning the user. Insufficient privileges provided: " + npe));
        }
        catch (SchemaViolationException sve) {
            log.error((Object)("There was an error provisioning the user. LDAP schema violation: " + sve));
            log.error((Object)ERROR_CODE_46_SUGGESTION_1);
            log.error((Object)ERROR_CODE_46_SUGGESTION_2);
        }
        catch (NameAlreadyBoundException nabe) {
            log.error((Object)("There was an error provisioning the user. The user already exists in the LDAP store: " + nabe));
        }
        catch (NamingException ne) {
            log.error((Object)("There was an error provisioning the user. " + ne));
            log.error((Object)ERROR_CODE_46_SUGGESTION_1);
            log.error((Object)ERROR_CODE_46_SUGGESTION_2);
        }
        return ExpressProvisioningProcessor.ProvisioningStatus.MODIFY_FAILURE;
    }

    @Override
    protected boolean doesUserAlreadyExist(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) {
        AttributeMap m = this.getUserAttrsFromLdap(userProvisioning, attrsFromIdp);
        return m != null && m.size() > 0;
    }

    private AttributeMap getUserAttrsFromLdap(UserProvisioning userProvisioning, AttributeMap attrsFromIdp) {
        try {
            AttributeSource ldapAttrSource = userProvisioning.getAttributeSource();
            LdapAttributeSource source = (LdapAttributeSource)SerializationUtils.clone((Serializable)ldapAttrSource);
            String baseDn = source.getParameter("filter") + "," + ldapAttrSource.getParameter("search_base");
            source.setParameter("search_base", baseDn);
            source.setParameter("search_scope", "OBJECT_SCOPE");
            source.setParameter("filter", null);
            AttributeMap existingLdapAttrs = source.executeAttributeLookup(LDAPUtil.nameEncodeValues(attrsFromIdp), userProvisioning.getAttributeMap().keySet());
            return existingLdapAttrs;
        }
        catch (AttrLookupException e) {
            log.error((Object)("There was a problem looking up the user attributes: " + e));
            return null;
        }
    }

    @Override
    public List<String> doTestProvision() throws SaaSProvisioningException {
        return null;
    }

    @Override
    protected List<String> doTestAddUser(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) {
        return null;
    }
}

