/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning;

import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.provisioning.ExpressDeprovisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.ExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.LdapExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.OracleExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.SqlServerExpressDeprovisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.SqlServerExpressProvStoredProcedureProcessor;
import org.sourceid.websso.profiles.sp.provisioning.SqlServerExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.exceptions.SaaSProvisioningException;

public class ProvisioningProcessorManager {
    private static ProvisioningProcessorManager mgr;
    private List<ResultInfo> columns;
    private String selectedDatasourceName = new String();
    private String schemaName = new String();
    private String tableName = new String();
    private String storedProcedure = new String();
    private static final String ERROR_PROVISIONING = "There was an error provisioning the user.";

    private ProvisioningProcessorManager() {
    }

    public static ProvisioningProcessorManager getInstance() {
        if (mgr == null) {
            mgr = new ProvisioningProcessorManager();
        }
        return mgr;
    }

    public ExpressProvisioningProcessor getProvisioningProcessor(DataSource dataSrc, UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) throws SaaSProvisioningException {
        if (DataSource.DSType.LDAP.getName().equals(dataSrc.getDataSourceType())) {
            return new LdapExpressProvisioningProcessor(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp);
        }
        if (DataSource.DSType.JDBC.getName().equals(dataSrc.getDataSourceType())) {
            JdbcDataSource jdbc = (JdbcDataSource)dataSrc;
            if (UserProvisioning.SqlMethodType.Table.equals((Object)userProvisioning.getSqlMethod())) {
                List<ResultInfo> resultInfoColumnList = this.getColumns(jdbc, userProvisioning);
                if (jdbc.isSqlServerDriver()) {
                    return new SqlServerExpressProvisioningProcessor(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp, resultInfoColumnList);
                }
                if (jdbc.isOracleDriver()) {
                    return new OracleExpressProvisioningProcessor(userProvisioning, evaledUserProvisioningAttrs, null, resultInfoColumnList);
                }
            } else if (UserProvisioning.SqlMethodType.StoredProcedure.equals((Object)userProvisioning.getSqlMethod()) && jdbc.isSqlServerDriver()) {
                List<ResultInfo> resultInfoColumnList = this.getStoredProcedureVariables(jdbc, userProvisioning);
                return new SqlServerExpressProvStoredProcedureProcessor(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp, resultInfoColumnList);
            }
        }
        throw new SaaSProvisioningException(this.getDatasourceNotSupportedError());
    }

    public ExpressDeprovisioningProcessor getDeprovisioningProcessor(JdbcDataSource jdbc, String schemaName, String tableName, ResultInfo uniqueIdColumn) throws SaaSProvisioningException {
        String selectedDataSourceName = jdbc.getJndiName();
        if (jdbc.isSqlServerDriver()) {
            return new SqlServerExpressDeprovisioningProcessor(selectedDataSourceName, schemaName, tableName, uniqueIdColumn);
        }
        if (jdbc.isOracleDriver()) {
            // empty if block
        }
        throw new SaaSProvisioningException(this.getDatasourceNotSupportedError());
    }

    private List<ResultInfo> getColumns(JdbcDataSource dataSource, UserProvisioning userProvisioningToCheck) {
        if (this.isTargetChanged(userProvisioningToCheck)) {
            this.columns = dataSource.getUnsortedColumnsWithMetadata(this.schemaName, this.tableName);
        }
        return this.copyMasterColumnList(this.columns);
    }

    private boolean isTargetChanged(UserProvisioning userProvisioningToCheck) {
        AttributeSource sourceToCheck = userProvisioningToCheck.getAttributeSource();
        JdbcDataSource dataSourceToCheck = (JdbcDataSource)sourceToCheck.getDataSource();
        String selectedDatasourceNameToCheck = dataSourceToCheck.getJndiName();
        String tableNameToCheck = sourceToCheck.getParameter("tableName");
        String schemaNameToCheck = sourceToCheck.getParameter("schema");
        String storedProcedureToCheck = sourceToCheck.getParameter("storedProcedure");
        UserProvisioning.SqlMethodType sqlMethod = userProvisioningToCheck.getSqlMethod();
        if (!(!UserProvisioning.SqlMethodType.Table.equals((Object)sqlMethod) || this.selectedDatasourceName.equals(selectedDatasourceNameToCheck) && this.schemaName.equals(schemaNameToCheck) && this.tableName.equals(tableNameToCheck))) {
            this.selectedDatasourceName = selectedDatasourceNameToCheck;
            this.schemaName = schemaNameToCheck;
            this.tableName = tableNameToCheck;
            return true;
        }
        if (!(!UserProvisioning.SqlMethodType.StoredProcedure.equals((Object)sqlMethod) || this.selectedDatasourceName.equals(selectedDatasourceNameToCheck) && this.schemaName.equals(schemaNameToCheck) && this.storedProcedure.equals(storedProcedureToCheck))) {
            this.selectedDatasourceName = selectedDatasourceNameToCheck;
            this.schemaName = schemaNameToCheck;
            this.storedProcedure = storedProcedureToCheck;
            return true;
        }
        return false;
    }

    private List<ResultInfo> copyMasterColumnList(List<ResultInfo> master) {
        ArrayList<ResultInfo> copy = new ArrayList<ResultInfo>();
        for (ResultInfo r : master) {
            ResultInfo newResultInfo = new ResultInfo(r);
            copy.add(newResultInfo);
        }
        return copy;
    }

    private List<String> getDatasourceNotSupportedError() {
        ArrayList<String> errors = new ArrayList<String>();
        errors.add("There was an error provisioning the user. The datasource is not supported.");
        return errors;
    }

    private List<ResultInfo> getStoredProcedureVariables(JdbcDataSource dataSource, UserProvisioning userProvisioningToCheck) {
        if (this.isTargetChanged(userProvisioningToCheck)) {
            this.columns = dataSource.getUnsortedStoredProcedureColumnsWithMetadata(this.schemaName, this.storedProcedure);
        }
        return this.copyMasterColumnList(this.columns);
    }

    public void refresh() {
        this.selectedDatasourceName = new String();
        this.schemaName = new String();
        this.tableName = new String();
        this.storedProcedure = new String();
    }
}

