/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning;

import com.pingidentity.common.util.JDBCHelper;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.provisioning.ExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.SqlServerExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.SqlStatementUtil;
import org.sourceid.websso.profiles.sp.provisioning.exceptions.SaaSProvisioningException;

public class SqlServerExpressProvStoredProcedureProcessor
extends SqlServerExpressProvisioningProcessor {
    private static final Log log = LogFactory.getLog(SqlServerExpressProvStoredProcedureProcessor.class);

    public SqlServerExpressProvStoredProcedureProcessor(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp, List<ResultInfo> columns) {
        super(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp, columns);
    }

    @Override
    public boolean doProvision() throws SaaSProvisioningException {
        ExpressProvisioningProcessor.ProvisioningStatus status = this.doAddUser(this.getUserProvisioning(), this.getEvaledUserProvisioningAttrs(), this.getAttrsFromIdp());
        return status == ExpressProvisioningProcessor.ProvisioningStatus.ADD_SUCCESS || status == ExpressProvisioningProcessor.ProvisioningStatus.USER_ALREADY_EXISTS && UserProvisioning.EventTriggerType.NewUserOnly == this.getUserProvisioning().getEventTrigger();
    }

    @Override
    protected ExpressProvisioningProcessor.ProvisioningStatus doAddUser(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) throws SaaSProvisioningException {
        this.callStoredProcedure(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp);
        return ExpressProvisioningProcessor.ProvisioningStatus.ADD_SUCCESS;
    }

    @Override
    protected List<String> doTestAddUser(UserProvisioning userProvisioning, AttributeMap evaledUserProvisioningAttrs, AttributeMap attrsFromIdp) throws SaaSProvisioningException {
        return this.callStoredProcedure(userProvisioning, evaledUserProvisioningAttrs, attrsFromIdp);
    }

    @Override
    protected synchronized List<String> doCallStoredProcedure(List<ResultInfo> listToInsert) throws SaaSProvisioningException {
        ArrayList<String> errors = new ArrayList<String>();
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = new JDBCHelper(this.getSelectedDatasourceName(), this);
            String callStatement = SqlStatementUtil.createInsertStoredProcedureStatement(this.getStoredProcedureName(), listToInsert);
            CallableStatement cstmt = jdbcHelper.getCallableStatement(callStatement);
            this.preparedStatementProcessing(cstmt, errors, listToInsert);
            if (!errors.isEmpty()) {
                log.error((Object)("The call to '" + this.getStoredProcedureName() + "' failed!"));
                throw new SaaSProvisioningException(errors);
            }
            cstmt.executeUpdate();
            cstmt.setQueryTimeout(10);
            cstmt.close();
            log.debug((Object)("The call to '" + this.getStoredProcedureName() + "' was successful."));
        }
        catch (SQLException | NamingException se) {
            String error = "There was an exception trying to call '" + this.getStoredProcedureName() + "': " + se;
            log.error((Object)error);
            errors.add(error);
            throw new SaaSProvisioningException(errors);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return null;
    }

    @Override
    protected String getProvisioningErrorWithColumnName(String paramName) {
        return "There was a problem resolving one of the provisioning parameters.  Parameter: " + paramName + " does not have a value.";
    }

    @Override
    protected String getProvisioningErrorWithoutColumnName() {
        return "There was a problem resolving one of the provisioning parameter.  Parameter Name is null";
    }
}

