/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.ResultInfo;

public class SqlStatementUtil {
    private static final String SPACE = " ";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String OPEN_BRACKET = "{";
    private static final String CLOSE_BRACKET = "}";

    public static String createInsertPreparedStatement(String schema, String table, List<ResultInfo> listToInsert) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        String schemaTableName = SqlStatementUtil.generateSchemaPlusTableName(schema, table);
        sb.append(schemaTableName + SPACE);
        sb.append("(");
        List<String> columns = SqlStatementUtil.getColumnNameList(listToInsert);
        sb.append(Util.listToCommaDelimString(columns));
        sb.append(")");
        sb.append(" VALUES ");
        sb.append("(");
        sb.append(Util.listToCommaDelimString(SqlStatementUtil.getQuestionMarks(columns.size())));
        sb.append(")");
        return sb.toString();
    }

    public static String createUpdateStatement(String schema, String table, List<ResultInfo> listToUpdate, String uniqueColumnId) {
        StringBuffer sb = new StringBuffer();
        String schemaTableName = SqlStatementUtil.generateSchemaPlusTableName(schema, table);
        sb.append("UPDATE " + schemaTableName + SPACE);
        sb.append("SET ");
        sb.append(Util.listToCommaDelimString(SqlStatementUtil.getUpdateValuesWithQuestionMarks(listToUpdate)));
        sb.append(SPACE);
        sb.append("WHERE ");
        for (ResultInfo info : listToUpdate) {
            if (!uniqueColumnId.equalsIgnoreCase(info.getColumnName())) continue;
            sb.append(DOUBLE_QUOTE + uniqueColumnId + DOUBLE_QUOTE);
            sb.append("=");
            sb.append(SINGLE_QUOTE + info.getValue() + SINGLE_QUOTE);
        }
        return sb.toString();
    }

    public static String createDeleteStatement(String schema, String table, ResultInfo uniqueId) {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ");
        String schemaTableName = SqlStatementUtil.generateSchemaPlusTableName(schema, table);
        sb.append(schemaTableName + SPACE);
        sb.append("WHERE ");
        switch (uniqueId.getDataType()) {
            case -16: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                sb.append(DOUBLE_QUOTE + uniqueId.getColumnName() + "\" LIKE ?");
                break;
            }
            default: {
                sb.append(DOUBLE_QUOTE + uniqueId.getColumnName() + "\"=?");
            }
        }
        return sb.toString();
    }

    public static String createInsertStoredProcedureStatement(String storedProcedureName, List<ResultInfo> infoFromInsert) {
        StringBuffer sb = new StringBuffer();
        sb.append("{call " + storedProcedureName + SPACE);
        sb.append("(");
        sb.append(Util.listToCommaDelimString(SqlStatementUtil.getQuestionMarks(infoFromInsert.size())));
        sb.append(")");
        sb.append(CLOSE_BRACKET);
        return sb.toString();
    }

    public static String createSelectForAttributeLookupStatement(String schema, String table, String attrName, Collection<String> attrNames) {
        StringBuffer sb = new StringBuffer();
        SqlStatementUtil.generateSelectFromClause(sb, attrNames);
        String schemaTableName = SqlStatementUtil.generateSchemaPlusTableName(schema, table);
        sb.append(schemaTableName + SPACE);
        sb.append("WHERE ");
        sb.append(DOUBLE_QUOTE + attrName + "\"=?");
        return sb.toString();
    }

    public static String createSelectForAttributeLookupStatement(String schema, String table, Collection<String> attrNames, String whereClause) {
        StringBuffer sb = new StringBuffer();
        SqlStatementUtil.generateSelectFromClause(sb, attrNames);
        String schemaTableName = SqlStatementUtil.generateSchemaPlusTableName(schema, table);
        sb.append(schemaTableName + SPACE);
        sb.append("WHERE ");
        sb.append(whereClause);
        return sb.toString();
    }

    public static String createSelectForAttributeLookupStatement(String schema, String table, String whereClause) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        String schemaTableName = SqlStatementUtil.generateSchemaPlusTableName(schema, table);
        sb.append(schemaTableName + SPACE);
        sb.append("WHERE ");
        sb.append(whereClause);
        return sb.toString();
    }

    public static StringBuffer createSelectAttributeBaseStatement(String schema, String table, Collection<String> attrNames) {
        StringBuffer sb = new StringBuffer();
        if (attrNames.isEmpty()) {
            sb.append("SELECT * FROM ");
        } else {
            SqlStatementUtil.generateSelectFromClause(sb, attrNames);
        }
        String schemaTableName = SqlStatementUtil.generateSchemaPlusTableName(schema, table);
        sb.append(schemaTableName + SPACE);
        sb.append("WHERE ");
        return sb;
    }

    private static void generateSelectFromClause(StringBuffer sb, Collection<String> attrNames) {
        sb.append("SELECT ");
        sb.append(Util.listToCommaDelimString(SqlStatementUtil.buildSelectList(attrNames)));
        sb.append(SPACE);
        sb.append("FROM ");
    }

    public static String createSelectAllForUniqueIdStatement(String schema, String table, String uniqueIdColumnName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        String schemaTableName = SqlStatementUtil.generateSchemaPlusTableName(schema, table);
        sb.append(schemaTableName + SPACE);
        sb.append("WHERE ");
        sb.append(DOUBLE_QUOTE + uniqueIdColumnName + "\"=?");
        return sb.toString();
    }

    public static List<String> getQuestionMarks(int numberOfColumns) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < numberOfColumns; ++i) {
            l.add("?");
        }
        return l;
    }

    public static List<String> getColumnNameList(List<ResultInfo> listToInsert) {
        ArrayList<String> l = new ArrayList<String>();
        for (ResultInfo r : listToInsert) {
            if (r.isSystemManaged()) continue;
            l.add(DOUBLE_QUOTE + r.getColumnName() + DOUBLE_QUOTE);
        }
        return l;
    }

    private static List<String> getUpdateValuesWithQuestionMarks(List<ResultInfo> listToUpdate) {
        ArrayList<String> l = new ArrayList<String>();
        for (ResultInfo info : listToUpdate) {
            if (info.isSystemManaged()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(DOUBLE_QUOTE + info.getColumnName() + DOUBLE_QUOTE);
            sb.append("=?");
            l.add(sb.toString());
        }
        return l;
    }

    private static List<String> buildSelectList(Collection<String> collection) {
        LinkedHashSet<String> uniqueItems = new LinkedHashSet<String>();
        uniqueItems.addAll(collection);
        ArrayList<String> l = new ArrayList<String>();
        for (String s : uniqueItems) {
            l.add(DOUBLE_QUOTE + s + DOUBLE_QUOTE);
        }
        return l;
    }

    private static String generateSchemaPlusTableName(String schema, String table) {
        String schemaTableName = StringUtils.isBlank((String)schema) ? DOUBLE_QUOTE + table + DOUBLE_QUOTE : DOUBLE_QUOTE + schema + "\".\"" + table + DOUBLE_QUOTE;
        return schemaTableName;
    }
}

