/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning.handlers;

import com.pingidentity.common.mgr.SqlFilterManager;
import com.pingidentity.common.util.LogGuard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.websso.profiles.sp.provisioning.handlers.JdbcDataHandler;

public class KeywordSqlInjectionHandler
extends JdbcDataHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private Map<String, String> sqlKeywords = new HashMap<String, String>();
    private static final String TABLE = "table";
    private static final String SCHEMA = "schema";
    private static final String COLUMN = "column";
    private static final String FUNCTION = "function";
    private static final String DROP = "drop";
    private static final String DELETE = "delete";
    private static final String MODIFY = "modify";
    private static final String ADD = "add";
    private static final String GRANT = "grant";
    private static final String CREATE = "create";
    private static final String PROC = "proc";
    private static final String FETCH = "fetch";
    private static final String ALTER = "alter";
    private static final String EXIT = "exit";
    private static final String USER = "user";
    private static final String EXEC = "exec";
    private static final String EXECUTE = "execute";
    private static final String COMMIT = "commit";
    private static final String REVOKE = "revoke";
    private static final String ROLLBACK = "rollback";

    public KeywordSqlInjectionHandler() {
        this.sqlKeywords.put(COLUMN, COLUMN);
        this.sqlKeywords.put(FUNCTION, FUNCTION);
        this.sqlKeywords.put(SCHEMA, SCHEMA);
        this.sqlKeywords.put(TABLE, TABLE);
        this.sqlKeywords.put(ADD, ADD);
        this.sqlKeywords.put(ALTER, ALTER);
        this.sqlKeywords.put(COMMIT, COMMIT);
        this.sqlKeywords.put(CREATE, CREATE);
        this.sqlKeywords.put(DELETE, DELETE);
        this.sqlKeywords.put(DROP, DROP);
        this.sqlKeywords.put(EXEC, EXEC);
        this.sqlKeywords.put(EXECUTE, EXECUTE);
        this.sqlKeywords.put(EXIT, EXIT);
        this.sqlKeywords.put(FETCH, FETCH);
        this.sqlKeywords.put(GRANT, GRANT);
        this.sqlKeywords.put(MODIFY, MODIFY);
        this.sqlKeywords.put(PROC, PROC);
        this.sqlKeywords.put(REVOKE, REVOKE);
        this.sqlKeywords.put(ROLLBACK, ROLLBACK);
        this.sqlKeywords.put(USER, USER);
    }

    @Override
    public boolean process(List<ResultInfo> resultInfo, List<String> errors) {
        SqlFilterManager mgr = SqlFilterManager.getInstance();
        if (mgr.isEnableSqlFilters()) {
            for (ResultInfo info : resultInfo) {
                String v = Util.stripSingleQuotes(new String(info.getValue()));
                String[] tokens = v.split("\\s");
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (StringUtils.isEmpty((String)token) || !this.sqlKeywords.containsKey(token.toLowerCase())) continue;
                    String error = "The value for column '" + info.getColumnName() + "' contains a SQL keyword: '" + v + "'";
                    this.log.error((Object)LogGuard.encode(error));
                    errors.add(error);
                    this.wasSuccessful = false;
                    break;
                }
                if (this.wasSuccessful) continue;
                break;
            }
        }
        if (this.next != null && this.wasSuccessful) {
            return this.next.process(resultInfo, errors);
        }
        return this.wasSuccessful;
    }
}

