/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.sp.provisioning.handlers;

import com.pingidentity.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.websso.profiles.sp.provisioning.JdbcExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.handlers.JdbcDataHandler;

public class SqlServerDataTypeCoersionHandler
extends JdbcDataHandler {
    private static final Log log = LogFactory.getLog(SqlServerDataTypeCoersionHandler.class);
    private final PreparedStatement ps;
    private final JdbcExpressProvisioningProcessor.OPERATION op;
    private boolean suppressLogErrors;
    public static final String TINYINTCOLUMN_MIN = "0";
    public static final String TINYINTCOLUMN_MAX = "255";
    public static final String SMALLINTCOLUMN_MIN = "-32768";
    public static final String SMALLINTCOLUMN_MAX = "32767";
    public static final String INTCOLUMN_MIN = "-2147483648";
    public static final String INTCOLUMN_MAX = "2147483647";
    public static final String BIGINT_MIN = "-9223372036854775808";
    public static final String BIGINT_MAX = "9223372036854775807";
    public static final String SMALLMONEYCOLUMN_MIN = "-214748.3648";
    public static final String SMALLMONEYCOLUMN_MAX = "214748.3647";
    public static final String MONEYCOLUMN_MIN = "-922337203685477.5808";
    public static final String MONEYCOLUMN_MAX = "922337203685477.5807";
    public static final String DECIMALCOLUMN_MIN = "-999999999999999999";
    public static final String DECIMALCOLUMN_MAX = "999999999999999999";
    public static final String REALCOLUMN_MAX = "3.40E38";
    public static final String REALCOLUMN_MIN = "-3.40E38";
    public static final String FLOATCOLUMN_MAX = "1.79E308";
    public static final String FLOATCOLUMN_MIN = "-1.79E308";

    public SqlServerDataTypeCoersionHandler(Statement ps, JdbcExpressProvisioningProcessor.OPERATION op) {
        this.ps = (PreparedStatement)ps;
        this.op = op;
    }

    public SqlServerDataTypeCoersionHandler(Statement ps, JdbcExpressProvisioningProcessor.OPERATION op, boolean suppressLogErrors) {
        this.ps = (PreparedStatement)ps;
        this.op = op;
        this.suppressLogErrors = suppressLogErrors;
    }

    @Override
    public boolean process(List<ResultInfo> resultInfo, List<String> errors) {
        int i = 1;
        try {
            for (ResultInfo info : resultInfo) {
                String v = info.getValue();
                int columnDataType = info.getDataType();
                String typeName = info.getTypeName();
                if (info.isSystemManaged() && (this.op == JdbcExpressProvisioningProcessor.OPERATION.INSERT || this.op == JdbcExpressProvisioningProcessor.OPERATION.DELETE)) continue;
                if ("NULL".equalsIgnoreCase(v) || this.isEmptyStringToNullCoersiveType(info) && StringUtils.isEmpty((String)v)) {
                    if (this.op != JdbcExpressProvisioningProcessor.OPERATION.INSERT) continue;
                    if (this.ps != null) {
                        this.ps.setNull(i, columnDataType);
                    }
                    ++i;
                    continue;
                }
                switch (columnDataType) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case -8: 
                    case -1: 
                    case 1: 
                    case 12: {
                        if ("xml".equalsIgnoreCase(typeName) || "uniqueidentifier".equalsIgnoreCase(typeName)) {
                            this.reportUnsupportedError(info, errors);
                            break;
                        }
                        if (v.length() <= info.getColumnSize()) {
                            if (this.ps == null) break;
                            this.ps.setString(i, v);
                            break;
                        }
                        this.reportSizeError(info, errors, TINYINTCOLUMN_MIN, Integer.toString(info.getColumnSize()));
                        break;
                    }
                    case 7: {
                        Number value;
                        Number min;
                        Number max;
                        try {
                            max = new BigDecimal(REALCOLUMN_MAX);
                            min = new BigDecimal(REALCOLUMN_MIN);
                            value = new BigDecimal(v);
                            if (((BigDecimal)value).compareTo((BigDecimal)max) <= 0 && ((BigDecimal)value).compareTo((BigDecimal)min) >= 0) {
                                if (this.ps == null) break;
                                this.ps.setFloat(i, ((BigDecimal)value).floatValue());
                                break;
                            }
                            this.reportSizeError(info, errors, REALCOLUMN_MIN, REALCOLUMN_MAX);
                        }
                        catch (NumberFormatException e) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case 6: 
                    case 8: {
                        Number value;
                        Number min;
                        Number max;
                        try {
                            max = new BigDecimal(FLOATCOLUMN_MAX);
                            min = new BigDecimal(FLOATCOLUMN_MIN);
                            value = new BigDecimal(v);
                            if (((BigDecimal)value).compareTo((BigDecimal)max) <= 0 && ((BigDecimal)value).compareTo((BigDecimal)min) >= 0) {
                                if (this.ps == null) break;
                                this.ps.setDouble(i, ((BigDecimal)value).doubleValue());
                                break;
                            }
                            this.reportSizeError(info, errors, FLOATCOLUMN_MIN, FLOATCOLUMN_MAX);
                        }
                        catch (NumberFormatException e) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case -5: {
                        Number value;
                        Number min;
                        Number max;
                        try {
                            max = new BigInteger(BIGINT_MAX);
                            min = new BigInteger(BIGINT_MIN);
                            value = new BigInteger(v);
                            if (((BigInteger)value).compareTo((BigInteger)max) <= 0 && ((BigInteger)value).compareTo((BigInteger)min) >= 0) {
                                if (this.ps == null) break;
                                this.ps.setLong(i, ((BigInteger)value).longValue());
                                break;
                            }
                            this.reportSizeError(info, errors, BIGINT_MIN, BIGINT_MAX);
                        }
                        catch (NumberFormatException e) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case 4: {
                        Number value;
                        Number min;
                        Number max;
                        try {
                            max = new BigInteger(INTCOLUMN_MAX);
                            min = new BigInteger(INTCOLUMN_MIN);
                            value = new BigInteger(v);
                            if (((BigInteger)value).compareTo((BigInteger)max) <= 0 && ((BigInteger)value).compareTo((BigInteger)min) >= 0) {
                                if (this.ps == null) break;
                                this.ps.setInt(i, ((BigInteger)value).intValue());
                                break;
                            }
                            this.reportSizeError(info, errors, INTCOLUMN_MIN, INTCOLUMN_MAX);
                        }
                        catch (NumberFormatException e) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case 5: {
                        Number value;
                        Number min;
                        Number max;
                        try {
                            max = new BigInteger(SMALLINTCOLUMN_MAX);
                            min = new BigInteger(SMALLINTCOLUMN_MIN);
                            value = new BigInteger(v);
                            if (((BigInteger)value).compareTo((BigInteger)max) <= 0 && ((BigInteger)value).compareTo((BigInteger)min) >= 0) {
                                if (this.ps == null) break;
                                this.ps.setShort(i, value.shortValue());
                                break;
                            }
                            this.reportSizeError(info, errors, SMALLINTCOLUMN_MIN, SMALLINTCOLUMN_MAX);
                        }
                        catch (NumberFormatException e) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case -6: {
                        Number value;
                        Number min;
                        Number max;
                        try {
                            max = new BigInteger(TINYINTCOLUMN_MAX);
                            min = new BigInteger(TINYINTCOLUMN_MIN);
                            value = new BigInteger(v);
                            if (((BigInteger)value).compareTo((BigInteger)max) <= 0 && ((BigInteger)value).compareTo((BigInteger)min) >= 0) {
                                if (this.ps == null) break;
                                this.ps.setShort(i, value.shortValue());
                                break;
                            }
                            this.reportSizeError(info, errors, TINYINTCOLUMN_MIN, TINYINTCOLUMN_MAX);
                        }
                        catch (NumberFormatException e) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case -7: {
                        try {
                            if ("true".equalsIgnoreCase(v) || "false".equalsIgnoreCase(v)) {
                                if (this.ps == null) break;
                                this.ps.setBoolean(i, Boolean.valueOf(v));
                                break;
                            }
                            BigInteger value = new BigInteger(v);
                            BigInteger zero = new BigInteger(TINYINTCOLUMN_MIN);
                            if (this.ps == null) break;
                            this.ps.setBoolean(i, value.compareTo(zero) != 0);
                        }
                        catch (NumberFormatException e) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case 3: {
                        BigDecimal value;
                        Number min;
                        Number max;
                        try {
                            max = null;
                            min = null;
                            MathContext mc = null;
                            if ("smallmoney".equalsIgnoreCase(typeName)) {
                                mc = new MathContext(10, RoundingMode.HALF_EVEN);
                                max = new BigDecimal(SMALLMONEYCOLUMN_MAX, mc);
                                min = new BigDecimal(SMALLMONEYCOLUMN_MIN, mc);
                            } else if ("decimal".equalsIgnoreCase(typeName)) {
                                mc = new MathContext(18, RoundingMode.HALF_EVEN);
                                max = new BigDecimal(DECIMALCOLUMN_MAX, mc);
                                min = new BigDecimal(DECIMALCOLUMN_MIN, mc);
                            } else if ("money".equalsIgnoreCase(typeName)) {
                                mc = new MathContext(19, RoundingMode.HALF_EVEN);
                                max = new BigDecimal(MONEYCOLUMN_MAX, mc);
                                min = new BigDecimal(MONEYCOLUMN_MIN, mc);
                            }
                            if (max != null && min != null) {
                                value = new BigDecimal(v, mc);
                                if (value.compareTo((BigDecimal)max) <= 0 && value.compareTo((BigDecimal)min) >= 0) {
                                    if (this.ps == null) break;
                                    this.ps.setBigDecimal(i, value);
                                    break;
                                }
                                this.reportSizeError(info, errors, ((BigDecimal)min).toString(), ((BigDecimal)max).toString());
                                break;
                            }
                            this.reportUnsupportedError(info, errors);
                        }
                        catch (NumberFormatException e) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case 2: {
                        BigDecimal value;
                        MathContext mc = new MathContext(18, RoundingMode.HALF_EVEN);
                        BigDecimal max = new BigDecimal(DECIMALCOLUMN_MAX, mc);
                        BigDecimal min = new BigDecimal(DECIMALCOLUMN_MIN, mc);
                        try {
                            if (max != null && min != null) {
                                value = new BigDecimal(v, mc);
                                if (value.compareTo(max) <= 0 && value.compareTo(min) >= 0) {
                                    if (this.ps == null) break;
                                    this.ps.setBigDecimal(i, value);
                                    break;
                                }
                                this.reportSizeError(info, errors, min.toString(), max.toString());
                                break;
                            }
                            this.reportUnsupportedError(info, errors);
                        }
                        catch (NumberFormatException e) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case 93: {
                        try {
                            java.util.Date dateVal = Converter.str2Date(v);
                            Date dateVar = new Date(dateVal.getTime());
                            this.ps.setTimestamp(i, new Timestamp(dateVar.getTime()));
                        }
                        catch (ParseException ex) {
                            this.reportCoersionError(info, errors);
                        }
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        this.reportUnsupportedError(info, errors);
                        break;
                    }
                    default: {
                        this.reportTypeDoesNotExistError(info, errors);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            String error = "There was an exception trying to insert into the database: " + e;
            if (!this.suppressLogErrors) {
                log.error((Object)error);
            }
            errors.add(error);
        }
        if (this.next != null && this.wasSuccessful) {
            return this.next.process(resultInfo, errors);
        }
        return this.wasSuccessful;
    }

    private void reportTypeDoesNotExistError(ResultInfo info, List<String> errors) {
        this.wasSuccessful = false;
        String typeErrorMsg = "' represents a type that does not exist for SQL Server 2005: ";
        String typeErrorMsg2 = ".  A text value of null is the only acceptable value for this column.";
        String error = "'" + info.getColumnName() + typeErrorMsg + info.getTypeName() + typeErrorMsg2;
        if (!this.suppressLogErrors) {
            log.error((Object)error);
        }
        errors.add(error);
    }

    private void reportUnsupportedError(ResultInfo info, List<String> errors) {
        this.wasSuccessful = false;
        String typeErrorMsg = "' represents a type that is not supported by PingFederate JDBC Provisioning at this time: ";
        String typeErrorMsg2 = ".  A text value of null is the only acceptable value for this column.";
        String error = "The column '" + info.getColumnName() + typeErrorMsg + info.getTypeName() + typeErrorMsg2;
        if (!this.suppressLogErrors) {
            log.error((Object)error);
        }
        errors.add(error);
    }

    private void reportCoersionError(ResultInfo info, List<String> errors) {
        this.wasSuccessful = false;
        String typeErrorMsg = "' cannot be translated from a string to the type: ";
        String error = "The value for '" + info.getColumnName() + typeErrorMsg + info.getTypeName();
        if (!this.suppressLogErrors) {
            log.error((Object)error);
        }
        errors.add(error);
    }

    private void reportSizeError(ResultInfo info, List<String> errors, String min, String max) {
        this.wasSuccessful = false;
        String typeErrorMsg = "' is out of range for the column: ";
        String error = "The value for '" + info.getColumnName() + typeErrorMsg + info.getTypeName() + ". min = " + min + ", max = " + max;
        if (!this.suppressLogErrors) {
            log.error((Object)error);
        }
        errors.add(error);
    }

    public boolean doesResultInfoHaveSupportedType(ResultInfo info, List<String> errors) {
        String v = info.getValue();
        if ("NULL".equalsIgnoreCase(v)) {
            return true;
        }
        switch (info.getDataType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                String typeName = info.getTypeName();
                if (!"xml".equalsIgnoreCase(typeName) && !"uniqueidentifier".equalsIgnoreCase(typeName)) break;
                this.reportUnsupportedError(info, errors);
                return false;
            }
            case 93: {
                break;
            }
            case -150: 
            case -4: 
            case -3: 
            case -2: 
            case 91: {
                this.reportUnsupportedError(info, errors);
                return false;
            }
        }
        return !info.isSystemManaged();
    }

    private boolean isEmptyStringToNullCoersiveType(ResultInfo info) {
        switch (info.getDataType()) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public String doesColumnHaveBannedType(ResultInfo info) {
        switch (info.getDataType()) {
            case -150: {
                return "SQL Variant";
            }
        }
        return null;
    }
}

