/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.protocol;

import java.text.MessageFormat;
import java.util.Calendar;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.wrapper.Assertion;

public class TimeConditionUtil {
    private int notBeforetimeToleranceInMinutes;
    protected int maxFutureValidityInMinutes;
    private long maxFutureValidityInMills;
    private boolean enforceMaxFuture;

    public TimeConditionUtil() {
        ConfigStore configStore = ConfigStoreFarm.getConfig("time-condition-validation-utility");
        this.setNotBeforeTimeToleranceInMinutes(configStore.getIntValue("NotBeforeTimeShiftToleranceInMinutes", 5));
        this.setMaxFutureValidityInMinutes(configStore.getIntValue("MaxFutureValidityInMinutes", 75));
        this.enforceMaxFuture = true;
    }

    public void setNotBeforeTimeToleranceInMinutes(int minutes) {
        this.notBeforetimeToleranceInMinutes = minutes;
    }

    public void setMaxFutureValidityInMinutes(int maxFutureValidityInMinutes) {
        this.maxFutureValidityInMinutes = maxFutureValidityInMinutes;
        this.maxFutureValidityInMills = 60000L * (long)maxFutureValidityInMinutes;
    }

    public void setEnforceMaxFuture(boolean enforceMaxFuture) {
        this.enforceMaxFuture = enforceMaxFuture;
    }

    public void validateNotBefore(Calendar notBefore, Calendar now) throws InvalidTimeConditionException {
        Calendar adjustedNotBefore = (Calendar)notBefore.clone();
        adjustedNotBefore.add(12, -1 * this.notBeforetimeToleranceInMinutes);
        if (now.before(adjustedNotBefore)) {
            String message = MessageFormat.format(this.getNotBeforeMsgPattern(), now, notBefore, adjustedNotBefore);
            throw new InvalidTimeConditionException(message);
        }
    }

    protected String getNotBeforeMsgPattern() {
        return "Time condition: now ({0}) is before NotBefore ({1}) and the adjusted tolerance NotBefore ({2}).";
    }

    protected String getNotOnOrAfterMessagePattern() {
        return "Time condition: now ({0}) is on/after NotOnOrAfter ({1}).";
    }

    protected String getTooFarInFutureMessagePattern() {
        return "Time condition: for security reasons NotOnOrAfter ({0}) cannot be more than {1} minutes ahead of the current time ({2})";
    }

    public void validateNotOnOrAfter(Calendar notOnOrAfter, Calendar now) throws InvalidTimeConditionException {
        if (!now.before(notOnOrAfter)) {
            String message = MessageFormat.format(this.getNotOnOrAfterMessagePattern(), now, notOnOrAfter);
            throw new InvalidTimeConditionException(message);
        }
        if (this.enforceMaxFuture && notOnOrAfter.getTimeInMillis() - now.getTimeInMillis() > this.maxFutureValidityInMills) {
            String msg = MessageFormat.format(this.getTooFarInFutureMessagePattern(), notOnOrAfter, this.maxFutureValidityInMinutes, now);
            throw new TooFarInFutureException(msg);
        }
    }

    public int getMaxFutureValidityInMinutes() {
        return this.maxFutureValidityInMinutes;
    }

    public boolean validateNotBefore(Assertion assertion, Calendar notBefore, Calendar now) {
        try {
            this.validateNotBefore(notBefore, now);
            return true;
        }
        catch (InvalidTimeConditionException e) {
            assertion.addInvalidRemark(e.getMessage());
            return false;
        }
    }

    public boolean validateNotOnOrAfter(Assertion assertion, Calendar notOnOrAfter, Calendar now) {
        try {
            this.validateNotOnOrAfter(notOnOrAfter, now);
            return true;
        }
        catch (InvalidTimeConditionException e) {
            assertion.addInvalidRemark(e.getMessage());
            return false;
        }
    }

    public class TooFarInFutureException
    extends InvalidTimeConditionException {
        public TooFarInFutureException(String message) {
            super(message);
        }
    }

    public class InvalidTimeConditionException
    extends Exception {
        public InvalidTimeConditionException(String message) {
            super(message);
        }
    }
}

