/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.CookieMonster;
import com.pingidentity.configservice.Reloadable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.token.jwt.JwtTokenGeneratorImpl;
import org.sourceid.token.jwt.PFInternalTokenException;
import org.sourceid.token.jwt.PFSimpleTokenTranslator;
import org.sourceid.token.jwt.SystemKeyState;
import org.sourceid.token.jwt.TokenInfo;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class BaseSessionIdUtil
implements Reloadable {
    private static final Log log = LogFactory.getLog(BaseSessionIdUtil.class);
    private static final String ID_CLAIM = "id";
    protected static final String PF_CLAIM = "pf";
    public static final String SESSION_ID_VALUE_ATTR_NAME = "value";
    public static final String ATTR_VALUE_INVALID = "(invalid)";
    public static final String EXTENDED_ATTRS_ATTR_NAME = "attrs";
    private final ConfigStore config;
    private final String attrPrefix;
    private volatile String cookieName;
    private volatile int cookieLength;
    private volatile boolean cookieSecure;
    private volatile boolean cookieHttpOnly;
    private volatile int cookieMaxAge;
    private volatile String cookieDomain;
    private volatile boolean writeCookieWhenUnchanged = true;
    private volatile Format format = Format.TEXT;
    private volatile char[] chars;
    private JwtTokenGeneratorImpl jwtTokenGenerator = new JwtTokenGeneratorImpl(new PFSimpleTokenTranslator("sessionCookie"));

    protected BaseSessionIdUtil() {
        this.config = null;
        this.attrPrefix = null;
    }

    protected BaseSessionIdUtil(String configFileName, String attrPrefix) {
        this.config = ConfigStoreFarm.getConfig(configFileName);
        this.attrPrefix = attrPrefix;
        ConfigStoreFarm.registerForReloadEvents(this);
        this.load();
    }

    protected int loadCookieLength() {
        return this.config.getIntValue("cookie-length", 22);
    }

    private void load() {
        this.cookieName = this.config.getStringValue("cookie-name", "PF");
        this.cookieLength = this.loadCookieLength();
        this.cookieSecure = this.config.getBooleanValue("cookie-secure-flag", false);
        this.cookieHttpOnly = this.config.getBooleanValue("cookie-httponly-flag", true);
        int maxAge = this.config.getIntValue("cookie-max-age", -1);
        this.cookieMaxAge = maxAge <= 0 ? -1 : maxAge;
        this.getCookieDomain();
        this.chars = this.config.getStringValue("chars", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789").toCharArray();
        this.writeCookieWhenUnchanged = this.config.getBooleanValue("write-when-unchanged", true);
        String COOKIE_FORMAT = "cookie-format";
        String formatStr = this.config.getStringValue("cookie-format", Format.TEXT.name());
        formatStr = formatStr.trim();
        if (formatStr.equalsIgnoreCase(Format.TEXT.name())) {
            this.format = Format.TEXT;
        } else if (formatStr.equalsIgnoreCase(Format.JWT.name())) {
            this.format = Format.JWT;
        } else {
            log.warn((Object)("Unrecognized value for cookie-format: " + formatStr));
        }
        log.debug((Object)("Setting format for " + this.cookieName + " cookie to " + this.format));
    }

    private void getCookieDomain() {
        this.cookieDomain = this.config.getStringValue("cookie-domain", "");
        if (StringUtils.isNotBlank((String)this.cookieDomain)) {
            try {
                new URI(this.cookieDomain);
            }
            catch (URISyntaxException e) {
                log.warn((Object)("Invalid cookie domain: " + this.cookieDomain));
                this.cookieDomain = "";
            }
        }
    }

    public String getPrimaryValue(HttpServletRequest request, HttpServletResponse response) {
        return this.getPrimaryValue(request, response, true);
    }

    public String createInitialPrimaryValue(HttpServletRequest request, HttpServletResponse response) {
        String newValue = this.newValue();
        this.writeValue(request, response, newValue, false);
        return newValue;
    }

    public String getPrimaryValue(HttpServletRequest request, HttpServletResponse response, boolean createIfNecessary) {
        String rawValue = this.getValue(request, response);
        String pfSessionId = this.parsePrimaryValue(rawValue);
        if (pfSessionId == null && createIfNecessary) {
            rawValue = this.recoverValueFromRequest(request, response);
            pfSessionId = rawValue == null ? this.createInitialPrimaryValue(request, response) : this.parsePrimaryValue(rawValue);
        }
        return pfSessionId;
    }

    public String hashIdForLog(String identifier) {
        if (identifier == null) {
            return null;
        }
        byte[] bytes = HashUtil.hashToBytes((String)identifier, (HashAlgorithm)HashAlgorithm.SHA1);
        return Base64URL.encodeToString((byte[])bytes);
    }

    @Override
    public void reload() {
        this.load();
    }

    public boolean isSessionCookie(String cookieName) {
        return this.cookieName.equals(cookieName);
    }

    public String newValue() {
        return IDGenerator.rndStr(this.cookieLength, this.chars);
    }

    public void clearValue(HttpServletRequest request, HttpServletResponse response) {
        this.writeValue(request, response, "", true);
    }

    public Format getFormat() {
        return this.format;
    }

    public Map<String, AttributeValue> getExtendedAttrs(HttpServletRequest req, HttpServletResponse resp) {
        this.getPrimaryValue(req, resp, false);
        Map extendedAttrs = (Map)this.getAttribute(req, EXTENDED_ATTRS_ATTR_NAME);
        if (extendedAttrs == null) {
            return Collections.emptyMap();
        }
        return extendedAttrs;
    }

    public void checkUpdateAdditionalCookieAttrs(HttpServletRequest req, HttpServletResponse resp) {
        String value;
        if (this.getFormat() == Format.JWT && (value = this.getPrimaryValue(req, resp, false)) != null) {
            this.writeValue(req, resp, value, false);
        }
    }

    protected String recoverValueFromRequest(HttpServletRequest req, HttpServletResponse resp) {
        return null;
    }

    protected String getValue(HttpServletRequest request, HttpServletResponse response) {
        String fullValue = (String)this.getAttribute(request, SESSION_ID_VALUE_ATTR_NAME);
        if (fullValue == null) {
            String rawCookie;
            fullValue = rawCookie = this.getRawCookie(request);
            MutableBoolean reencrypt = new MutableBoolean();
            if (this.format == Format.JWT) {
                fullValue = this.getValueFromJwt(request, rawCookie, reencrypt);
            }
            if (this.parsePrimaryValue(fullValue) != null) {
                this.checkCopyValueToResponse(request, response, rawCookie, fullValue, reencrypt.booleanValue());
            } else {
                fullValue = ATTR_VALUE_INVALID;
            }
            this.setAttribute(request, SESSION_ID_VALUE_ATTR_NAME, fullValue);
        } else if (fullValue.equals(ATTR_VALUE_INVALID)) {
            return null;
        }
        return fullValue;
    }

    protected void checkCopyValueToResponse(HttpServletRequest req, HttpServletResponse resp, String rawCookie, String value, boolean reencrypt) {
        if (this.writeCookieWhenUnchanged || reencrypt) {
            if (this.format == Format.JWT && reencrypt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Re-encrypting cookie " + this.cookieName + " with current system key"));
                }
                this.writeValue(req, resp, value, false);
            } else {
                this.writeRawCookie(resp, rawCookie, false);
            }
        }
    }

    protected String getRawCookie(HttpServletRequest request) {
        return CookieMonster.getCookieValue(this.cookieName, request);
    }

    protected String parsePrimaryValue(String cookieValue) {
        return this.parseValue(cookieValue, 0);
    }

    protected void writeValue(HttpServletRequest request, HttpServletResponse response, String value, boolean clearCookie) {
        if (clearCookie) {
            this.setAttribute(request, SESSION_ID_VALUE_ATTR_NAME, ATTR_VALUE_INVALID);
        } else {
            this.setAttribute(request, SESSION_ID_VALUE_ATTR_NAME, value);
        }
        if (!clearCookie && this.format == Format.JWT) {
            value = this.makeJwtFromValue(request, response, value);
        }
        this.writeRawCookie(response, value, clearCookie);
    }

    protected void writeRawCookie(HttpServletResponse response, String value, boolean clearCookie) {
        Cookie cookie = new Cookie(this.cookieName, clearCookie ? "" : value);
        cookie.setHttpOnly(this.cookieHttpOnly);
        if (clearCookie) {
            cookie.setMaxAge(0);
        } else {
            cookie.setMaxAge(this.cookieMaxAge);
        }
        cookie.setSecure(this.cookieSecure);
        if (StringUtils.isNotBlank((String)this.cookieDomain)) {
            cookie.setDomain(this.cookieDomain);
        }
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    protected String parseValue(String raw, int index) {
        int length;
        String value = null;
        if (raw != null && index >= 0 && (length = raw.length()) % this.cookieLength == 0) {
            int start = index * this.cookieLength;
            int end = (index + 1) * this.cookieLength;
            if (length > start && length >= end) {
                value = raw.substring(start, end);
            }
        }
        return value;
    }

    protected String makeFullAttrName(String attrName) {
        return this.attrPrefix + "." + attrName;
    }

    protected void setAttribute(HttpServletRequest req, String attrName, Object attrValue) {
        req.setAttribute(this.makeFullAttrName(attrName), attrValue);
    }

    protected Object getAttribute(HttpServletRequest req, String attrName) {
        return req.getAttribute(this.makeFullAttrName(attrName));
    }

    protected void removeAttribute(HttpServletRequest req, String attrName) {
        req.removeAttribute(this.makeFullAttrName(attrName));
    }

    protected Map<String, AttributeValue> makeAdditionalCookieAttrs(HttpServletRequest req, HttpServletResponse resp) {
        return Collections.emptyMap();
    }

    private String makeJwtFromValue(HttpServletRequest req, HttpServletResponse resp, String value) {
        HashMap<String, AttributeValue> attrs = new HashMap<String, AttributeValue>();
        attrs.put(ID_CLAIM, new AttributeValue(value));
        Map<String, AttributeValue> additionalAttrs = this.makeAdditionalCookieAttrs(req, resp);
        attrs.putAll(additionalAttrs);
        this.setAttribute(req, EXTENDED_ATTRS_ATTR_NAME, attrs);
        try {
            return this.jwtTokenGenerator.encrypt((Map<String, AttributeValue>)attrs);
        }
        catch (PFInternalTokenException e) {
            throw new ProcessRuntimeException("Unexpected error encrypting session cookie", e);
        }
    }

    private String getValueFromJwt(HttpServletRequest req, String jwt, MutableBoolean reencrypt) {
        if (StringUtils.isBlank((String)jwt)) {
            return null;
        }
        try {
            TokenInfo<String, AttributeValue> tokenInfo = this.jwtTokenGenerator.decryptWithInfo(jwt);
            AttributeValue idAttr = tokenInfo.getAttributes().get(ID_CLAIM);
            this.setAttribute(req, EXTENDED_ATTRS_ATTR_NAME, tokenInfo.getAttributes());
            if (idAttr == null) {
                return null;
            }
            reencrypt.setValue(tokenInfo.getKeyState() == SystemKeyState.PREVIOUS);
            return idAttr.getValue();
        }
        catch (PFInternalTokenException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error decrypting cookie " + this.cookieName + ": " + ExceptionUtil.toStringWithCauses(e)));
            }
            return null;
        }
    }

    public static enum Format {
        TEXT,
        JWT;

    }
}

