/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.websso.commondomain.ReadCookieHandler;
import org.sourceid.websso.commondomain.WriteCookieHandler;
import org.sourceid.websso.servlet.EnforcerServletBase;

public class CommonDomainServiceControllerServlet
extends EnforcerServletBase {
    private static final long serialVersionUID = 1L;
    private WriteCookieHandler writeCookieHandler = new WriteCookieHandler();
    private ReadCookieHandler readCookieHandler = new ReadCookieHandler();
    private MetadataLocal localMetadata;

    @Override
    public void process(HttpServletRequest request, HttpServletResponse response, boolean isPost) throws ServletException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(request.getMethod() + ": " + request.getRequestURL()));
        }
        String servletPath = request.getServletPath();
        boolean isValidRequestPath = false;
        IdpDiscovery idpDiscoveryParams = this.localMetadata.getIdpDiscovery();
        if (idpDiscoveryParams.isCommonDomainServer() && this.localMetadata.getEnableIdpDiscovery()) {
            if (idpDiscoveryParams.getWriteCookiePath().equals(servletPath)) {
                isValidRequestPath = true;
                this.writeCookieHandler.process(request, response);
            } else if (idpDiscoveryParams.getReadCookiePath().equals(servletPath)) {
                isValidRequestPath = true;
                this.readCookieHandler.process(request, response);
            }
        }
        if (!isValidRequestPath) {
            response.sendError(404, "Common Domain Server is not enabled, or the requested path is not valid.");
        }
    }

    public void init() throws ServletException {
        this.localMetadata = MetaDataFactory.getLocalMetaData();
    }
}

