/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeferredInitServlet
extends HttpServlet {
    private static final long serialVersionUID = -8364547353254563625L;
    private static final Log log = LogFactory.getLog(DeferredInitServlet.class);
    private static List<TargetMethodCall> initCalls = new LinkedList<TargetMethodCall>();
    private static List<TargetMethodCall> destroyCalls = new LinkedList<TargetMethodCall>();
    private static boolean started = false;

    public void init() throws ServletException {
        log.info((Object)"Initializing...");
        DeferredInitServlet.callMethods(initCalls);
        started = true;
    }

    public void destroy() {
        DeferredInitServlet.shutdown();
    }

    public static void shutdown() {
        log.debug((Object)"calling shutdown undeployment hooks...");
        DeferredInitServlet.callMethods(destroyCalls);
    }

    public static void addInitCall(Object target, String methodName) {
        initCalls.add(new TargetMethodCall(target, methodName));
    }

    public static void addDestroyCall(Object target, String methodName) {
        destroyCalls.add(new TargetMethodCall(target, methodName));
    }

    public static boolean isStarted() {
        return started;
    }

    private static synchronized void callMethods(List<TargetMethodCall> targetMethodCalls) {
        Iterator<TargetMethodCall> iter = targetMethodCalls.iterator();
        while (iter.hasNext()) {
            TargetMethodCall call = iter.next();
            iter.remove();
            Object target = call.getTarget();
            String methodName = call.getMethodName();
            DeferredInitServlet.callMethod(target, methodName);
        }
    }

    private static void callMethod(Object target, String methodName) {
        log.debug((Object)("invoking " + methodName + " on " + target));
        try {
            Method method = target.getClass().getMethod(methodName, new Class[0]);
            method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)("Exception in invoking " + methodName + " on " + target + "."), (Throwable)e);
        }
    }

    private static class TargetMethodCall {
        Object target;
        String methodName;

        public TargetMethodCall(Object target, String methodName) {
            this.target = target;
            this.methodName = methodName;
        }

        public Object getTarget() {
            return this.target;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

