/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import java.util.HashSet;
import java.util.Set;
import org.sourceid.websso.servlet.ExtendedSessionIdListener;

public class ExtendedSessionIdManager {
    private static ExtendedSessionIdManager instance = new ExtendedSessionIdManager();
    private Set<ExtendedSessionIdListener> listeners = new HashSet<ExtendedSessionIdListener>();

    public static ExtendedSessionIdManager getInstance() {
        return instance;
    }

    public synchronized void addListener(ExtendedSessionIdListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ExtendedSessionIdListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyExtendedSessionIdUpdated(ExtendedSessionIdListener sender, String oldId, String newId) {
        if (oldId == null || newId == null || oldId.equals(newId)) {
            return;
        }
        HashSet<ExtendedSessionIdListener> listenersCopy = null;
        ExtendedSessionIdManager extendedSessionIdManager = this;
        synchronized (extendedSessionIdManager) {
            listenersCopy = new HashSet<ExtendedSessionIdListener>(this.listeners);
        }
        for (ExtendedSessionIdListener listener : listenersCopy) {
            listener.onExtendedSessionIdUpdated(sender, oldId, newId);
        }
    }
}

