/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import com.pingidentity.common.event.impl.ChangePasswordEmailNotificationEventListener;
import com.pingidentity.jmx.JmxBootstrapper;
import com.pingidentity.monitoring.ThreadPoolExhaustionService;
import com.pingidentity.monitoring.jmx.MetricsMBean;
import com.pingidentity.monitoring.metrics.MeterManager;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.services.ConfigurationBootstrapServiceManager;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.DataDeployer;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.domain.util.InitMigrationUtil;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.SystemUtil;
import org.sourceid.util.UpgradeInfo;

public class InitServlet
extends HttpServlet {
    private static final long serialVersionUID = 20050515L;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void init() throws ServletException {
        this.log.info((Object)"Initializing...");
        try {
            DataDeployer initialDeployer = new DataDeployer();
            DataDeployer.DeployDataResult deployDataResult = initialDeployer.attemptDeployData();
            if (initialDeployer.shouldReplicateAfterDeploy() && deployDataResult == DataDeployer.DeployDataResult.FAILURE && !initialDeployer.isForceImport()) {
                SystemUtil.hardShutdown("Failed to deploy configuration archive from drop-in-deployer during start-up with replicate after drop-in deployment enabled.");
            }
            Mediator mediator = MgmtFactory.getMediator();
            AdminNodeConfigManager adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();
            if (DataDeployer.DeployDataResult.FAILURE != deployDataResult) {
                new ConfigurationBootstrapServiceManager(mediator, adminNodeConfigManager).applyConfiguration();
            }
            if (mediator.isDistributable()) {
                MgmtFactory.getNodeIndexRegistry();
            }
            StateMgmtFactory.getInterRequestStateMgmt();
            StateMgmtFactory.getSpSessionRegistry();
            StateMgmtFactory.getIdpSessionRegistry();
            StateMgmtFactory.getArtifactPersistenceService();
            StateMgmtFactory.getBearerAssertionReplayPreventionSvc();
            StateMgmtFactory.getSessionRevocationService();
            MgmtFactory.getCertificateService().init();
            MgmtFactory.getKerberosRealmManager().init();
            MgmtFactory.getJwkFacilitator();
            DataSourceManager dsm = MgmtFactory.getDataSourceManager();
            dsm.deployJdbcDataSources();
            JmxBootstrapper.getJmxBootstrapper();
            MeterManager.getInstance();
            MetricsMBean.registerMBeans();
            if (ModeSupport.isConsole()) {
                MgmtFactory.getAdminUserManager().updateConfiguration();
            }
            MgmtFactory.getPingOneAdminService().reload();
            if (ModeSupport.isConsole()) {
                MgmtFactory.getDSignRotationSettingsManager().startDigitalCertRotationTask();
            }
            MgmtFactory.getMetadataUpdateScheduleManager().reload();
            MgmtFactory.getPingOneAdminService().upgradeConfiguration();
            MgmtFactory.getAuthzServerManager().upgradeLegacyUserKeyToAccessTokenMappingIds();
            MgmtFactory.getAuthzServerManager().upgradeLegacyConfigStoreSettings();
            MgmtFactory.getAuthzServerManager().handleLegacyClientCredentialToAccessTokenMappingIds();
            MgmtFactory.getPFInternalTokenSettingsManager().init();
            MgmtFactory.getAuthnApiManager().init();
            InitMigrationUtil.addPolicyIdToAuthnPolicies();
            InitMigrationUtil.createDefaultNotificationPublisher();
            InitMigrationUtil.createDefaultCaptchaProvider();
            ChangePasswordEmailNotificationEventListener.getListener();
            if (MgmtFactory.getMediator().isConsole()) {
                MgmtFactory.getMetadataDirectory().getIdpConnections();
                MgmtFactory.getMetadataDirectory().getSpConnections();
            }
            if (ModeSupport.isEngine()) {
                ResponseTemplateRenderer.getInstance();
                MgmtFactory.getMediator().configurePlugins();
            }
            this.checkForNewAuthnApiMessages();
            if (MgmtFactory.getMediator().isDistributable()) {
                if (MgmtFactory.getMediator().isConsole()) {
                    MgmtFactory.getConfigSynchronizationService().init();
                }
                MgmtFactory.getConfigReplicationService().setListenForReplicationEvents(true);
                if (MgmtFactory.getMediator().isEngine() || MgmtFactory.getMediator().isConsole() && MgmtFactory.getAdminNodeConfigManager().isPassiveNode()) {
                    MgmtFactory.getConfigReplicationService().updateConfigFromCluster();
                }
            }
            MgmtFactory.getMediator().checkPublishConfig();
            MgmtFactory.getTimerTaskManager().scheduleTasks();
            ThreadPoolExhaustionService.getInstance().start();
            if (!MgmtFactory.getAdminNodeConfigManager().isEnabledAndPassiveNode()) {
                UpgradeInfo.setPostUpgradeProcessingRequired(false);
            }
        }
        catch (RuntimeException e) {
            SystemUtil.hardShutdown("Error Initializing: " + ((Object)((Object)this)).getClass().getSimpleName(), e);
        }
    }

    public void destroy() {
    }

    private void checkForNewAuthnApiMessages() {
        LanguagePackMessages externalMessages;
        LanguagePackMessages embeddedMessages;
        try {
            embeddedMessages = new LanguagePackMessages("authn-api-messages-embedded", Locale.ENGLISH);
        }
        catch (MissingResourceException e) {
            this.log.warn((Object)"Could not find embedded resource bundle authn-api-messages-embedded");
            return;
        }
        try {
            externalMessages = new LanguagePackMessages("authn-api-messages", Locale.ENGLISH);
        }
        catch (MissingResourceException e) {
            this.log.warn((Object)"Could not find resource bundle authn-api-messages");
            return;
        }
        LinkedHashMap<String, String> missingMessages = new LinkedHashMap<String, String>();
        for (String string : embeddedMessages.getResourceBundle().keySet()) {
            String embeddedMessage = embeddedMessages.getMessage(string);
            String externalMessage = externalMessages.getMessage(string);
            if (externalMessage != null && !externalMessage.equals(string)) continue;
            missingMessages.put(string, embeddedMessage);
        }
        if (!missingMessages.isEmpty()) {
            this.log.info((Object)"The installed Authentication API SDK (pf-authn-api-sdk) includes the new messages listed below. To allow customization and localization, these messages should be added to authn-api-messages.properties and any localized versions of this file.");
            for (Map.Entry entry : missingMessages.entrySet()) {
                this.log.info((Object)("New message: " + (String)entry.getKey() + "=" + (String)entry.getValue()));
            }
        }
    }
}

