/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet;

import com.pingidentity.common.util.LogGuard;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrackedHttpParamManager;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.DisplayableException;
import org.sourceid.websso.ExceptionHandler;
import org.sourceid.websso.profiles.NoSuchProcessException;
import org.sourceid.websso.servlet.EnforcerServletBase;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class ProtocolControllerServlet
extends EnforcerServletBase {
    private static final long serialVersionUID = 1L;
    private static final String IDP_ADAPTER_PASSWORD = "pf.pass";
    private Set<String> sensitiveParamNames;

    public void init() throws ServletException {
        super.init();
        ConfigStore configStore = ConfigStoreFarm.getConfig(((Object)((Object)this)).getClass());
        List<String> defaults = Arrays.asList("token", Parameters.CLIENT_SECRET, "password", "refresh_token", IDP_ADAPTER_PASSWORD, "code", "device_code", "subject_token", "actor_token", "logout_token", "id_token_hint");
        List<String> list = configStore.getListValue("sensitive-parameter-names", defaults);
        this.sensitiveParamNames = new HashSet<String>(list);
    }

    @Override
    protected void checkSessionRevoked(HttpServletRequest req, HttpServletResponse resp) {
    }

    private void doIt(HttpServletRequest request, HttpServletResponse response, boolean isPost) throws BindingException, NoSuchProcessException, IOException, RedirectException, RenderPageException, HttpStatusCodeException {
        if (this.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("---REQUEST (").append(LogGuard.encode(request.getMethod())).append(")").append(LogGuard.encode(request.getServletPath())).append(" from ").append(LogGuard.encode(request.getRemoteAddr())).append(": ");
            sb.append(Util.LINE_BREAK);
            OAuthIssuer oAuthIssuer = this.getOAuthIssuerService().getOAuthIssuerFromRequest(request);
            if (oAuthIssuer != null) {
                sb.append("---OAUTH ISSUER---").append(Util.LINE_BREAK);
                sb.append("hostname:").append(Util.LINE_BREAK);
                sb.append("   ").append(oAuthIssuer.getHost()).append(Util.LINE_BREAK);
                sb.append("path:").append(Util.LINE_BREAK);
                sb.append("   ").append(oAuthIssuer.getPath()).append(Util.LINE_BREAK);
            }
            sb.append("---PARAMETERS---").append(Util.LINE_BREAK);
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(name);
                sb.append(LogGuard.encode(name)).append(":").append(Util.LINE_BREAK);
                for (String value : values) {
                    value = this.sensitiveParamNames.contains(name) || this.maskTrackedParam(name) ? "********" : value;
                    sb.append("   ").append(LogGuard.encode(value)).append(Util.LINE_BREAK);
                }
            }
            this.log.debug((Object)sb);
        }
        if (this.processMgmtSvc.isBasicHttpRequest(request)) {
            this.processMgmtSvc.doHandleBasicHttpRequest(request, response);
        } else {
            Role partnerRole = this.processMgmtSvc.getType(request);
            InMessageContext inMsgCtx = this.bindingSvc.receive(request, response, isPost, partnerRole);
            if (inMsgCtx.isRequest()) {
                OutMessageContext outMsgCtx = this.processMgmtSvc.doHandleRequest(inMsgCtx, request, response);
                this.bindingSvc.transportResponse(request, response, inMsgCtx, outMsgCtx);
            } else {
                this.processMgmtSvc.doHandleResponse(inMsgCtx.getOriginalRequest(), inMsgCtx, request, response);
            }
        }
    }

    @Override
    public void process(HttpServletRequest request, HttpServletResponse response, boolean isPost) throws ServletException, IOException, RenderPageException, NoSuchProcessException, RedirectException, HttpStatusCodeException {
        try {
            this.doIt(request, response, isPost);
        }
        catch (IOException | NoSuchProcessException | HttpStatusCodeException | RedirectException | RenderPageException e) {
            throw e;
        }
        catch (DisplayableException e) {
            this.log.error((Object)("Exception occurred in request processing: " + e));
            ExceptionHandler.handle(e, request, response);
        }
        catch (Exception e) {
            this.bindingSvc.handleException(request, response, isPost, e);
        }
    }

    private boolean maskTrackedParam(String paramName) {
        TrackedHttpParamManager mgr = MgmtFactory.getTrackedHttpParamManager();
        return mgr.isMaskTrackedParams() && mgr.getTrackedParamSettings().getTrackedParamNames().contains(paramName);
    }
}

