/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet.localidentity;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.servlet.adapter.HandlerRegistry;
import org.sourceid.websso.servlet.localidentity.LipHandler;

public class LipHandlerRegistry {
    private static Log log = LogFactory.getLog(HandlerRegistry.class);
    private static Map<String, LipHandler> handlers = new HashMap<String, LipHandler>();
    private static Map<String, LipHandler> jwtAuthnHandlers = new HashMap<String, LipHandler>();
    private static LipHandler handler404 = (req, resp, lip, dto, attributeMap) -> resp.sendError(404);

    public static synchronized void registerHandler(String path, LipHandler handler, boolean isJwtAuthenticated) {
        log.info((Object)("Registering " + handler + " at " + path));
        if (isJwtAuthenticated) {
            jwtAuthnHandlers.put(path, handler);
        } else {
            handlers.put(path, handler);
        }
    }

    public static synchronized LipHandler getHandler(String path, boolean isJwtAuthenticated) {
        LipHandler handler = isJwtAuthenticated ? jwtAuthnHandlers.get(path) : handlers.get(path);
        return handler != null ? handler : handler404;
    }
}

