/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet.reqparam;

import com.pingidentity.configservice.Reloadable;
import com.pingidentity.locale.LocaleUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.servlet.reqparam.ParamValidator;

public class ValidationHub
implements Reloadable {
    static final String CONFIG_NAME = "http-request-parameter-validation";
    private volatile Map<String, List<ParamValidator>> validators = new LinkedHashMap<String, List<ParamValidator>>();
    private final Log log = LogFactory.getLog(this.getClass());

    ValidationHub() {
        this.reload();
        ConfigStoreFarm.registerForReloadEvents(this);
    }

    ValidationHub(String configName) {
        this.loadConfig(configName);
    }

    @Override
    public synchronized void reload() {
        this.loadConfig(CONFIG_NAME);
    }

    private void loadConfig(String configName) {
        ConfigStore config = ConfigStoreFarm.getConfig(configName);
        LinkedHashMap<String, List<ParamValidator>> tempValidators = new LinkedHashMap<String, List<ParamValidator>>();
        for (String paramName : config.getKeys()) {
            try {
                Map validatorMap = config.getMapValue(paramName);
                int counter = 0;
                for (Map.Entry e : validatorMap.entrySet()) {
                    String validatorName = (String)e.getKey();
                    String validatorArgs = (String)e.getValue();
                    try {
                        ParamValidator validator = this.createValidatorFromName(validatorName, validatorArgs);
                        this.addValidator(paramName, validator, tempValidators);
                        ++counter;
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Unable to create validator " + validatorName + "(" + validatorArgs + ") for parameter " + paramName + ". " + t));
                    }
                }
                this.log.info((Object)("Created " + counter + " validators for parameter " + paramName));
            }
            catch (NoSuchValueException e) {
                this.log.warn((Object)("Validation configuration for parameter " + paramName + " is incorrect."));
            }
        }
        this.validators = tempValidators;
    }

    private void addValidator(String paramName, ParamValidator validator, Map<String, List<ParamValidator>> validatorMap) {
        List paramValidators = validatorMap.computeIfAbsent(paramName, k -> new ArrayList());
        paramValidators.add(validator);
    }

    public String getParam(HttpServletRequest req, String name) {
        String value = req.getParameter(name);
        List<ParamValidator> validatorsList = this.validators.get(name);
        if (validatorsList != null && !StringUtils.isBlank((String)value)) {
            for (ParamValidator validator : validatorsList) {
                validator.validate(name, value);
            }
        }
        return value;
    }

    public static void checkThrowIRPE(String name, String desc, boolean isValid) throws InvalidRequestParameterException {
        if (!isValid) {
            ValidationHub.throwIRPE(name, desc);
        }
    }

    public static void throwIRPE(String name, String description) throws InvalidRequestParameterException {
        StringBuilder sb = new StringBuilder().append("Value for parameter \"");
        sb.append(name).append("\" is invalid. ").append(LocaleUtil.getLocalizedString(Locale.ENGLISH, "pingfederate-messages", description, null));
        String[] errorDetailParameters = new String[]{name, description};
        throw new InvalidRequestParameterException(sb.toString(), "errorDetail.invalidParameter", errorDetailParameters);
    }

    private ParamValidator createValidatorFromName(String name, String args) throws Exception {
        String fullName = this.getClass().getPackage().getName() + "." + name.trim();
        Class<?> clazz = Class.forName(fullName);
        ParamValidator validator = (ParamValidator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        validator.initialize(args);
        return validator;
    }
}

