/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.wrapper;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.protocol.GeneralXmlUtil;
import org.sourceid.util.ExternalizationEncoder;
import org.sourceid.util.log.internal.AttrMaskingXmlObjFactoryIn;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class InMessageContext
extends BaseMessageContext {
    protected static final AttrMaskingXmlObjFactoryIn MASKING_XML_OBJ_FACTORY = new AttrMaskingXmlObjFactoryIn();
    private SignatureResult signatureResult = new SignatureResult();
    protected boolean signatureRequired;
    protected boolean unsolicitedResponse;
    protected OutMessageContext originalRequest;
    protected Boolean isRequest;

    public InMessageContext() {
    }

    public InMessageContext(Role role) {
        super(role);
    }

    public SignatureStatus getSignatureStatus() {
        return this.signatureResult.getStatus();
    }

    public void setSignatureStatus(SignatureStatus signatureStatus) {
        this.signatureResult.setStatus(signatureStatus);
    }

    public SignatureResult getSignatureResult() {
        return this.signatureResult;
    }

    public void setSignatureResult(SignatureResult signatureResult) {
        this.signatureResult = signatureResult;
    }

    public boolean isSignatureRequired() {
        return this.signatureRequired;
    }

    public void setSignatureRequired(boolean bindingDictatesSinging) {
        this.signatureRequired = bindingDictatesSinging;
    }

    public boolean isUnsolicitedResponse() {
        return this.unsolicitedResponse;
    }

    public void setUnsolicitedResponse(boolean unsolicitedResponse) {
        this.unsolicitedResponse = unsolicitedResponse;
    }

    public OutMessageContext getOriginalRequest() {
        return this.originalRequest;
    }

    public void setOriginalRequestCtx(OutMessageContext originalRequest) {
        this.originalRequest = originalRequest;
    }

    @Override
    protected XmlObject mask() {
        return MASKING_XML_OBJ_FACTORY.getMasked(this);
    }

    public boolean isRequest() {
        if (this.isRequest == null) {
            this.isRequest = GeneralXmlUtil.isRequest(this.getXmlObject());
        }
        return this.isRequest;
    }

    public void setIsRequest(boolean isRequest) {
        this.isRequest = isRequest;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.getSignatureStatus() != null) {
            sb.append("SignatureStatus: ").append((Object)this.getSignatureStatus()).append(TO_STRING_DELIM);
            if (this.signatureResult.hasCommentary()) {
                sb.append("Signature comments: ").append(this.signatureResult.getCommentary()).append(TO_STRING_DELIM);
            }
            sb.append("Binding says to sign: ").append(this.signatureRequired).append(TO_STRING_DELIM);
        }
        return sb.toString();
    }

    @Override
    public StringBuilder getEnhancedInfo() {
        StringBuilder sb = new StringBuilder(super.getEnhancedInfo());
        if (this.getSignatureStatus() != null) {
            sb.append(" | ").append("SignatureStatus: ").append((Object)this.getSignatureStatus());
        }
        return sb;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.setSignatureStatus(ExternalizationEncoder.readEnum(in, SignatureStatus.class));
        this.signatureRequired = ExternalizationEncoder.readBoolean(in);
        this.unsolicitedResponse = ExternalizationEncoder.readBoolean(in);
        this.originalRequest = (OutMessageContext)in.readObject();
        this.isRequest = ExternalizationEncoder.readBoolean(in);
        this.isBackChannelBinding = ExternalizationEncoder.readBoolean(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizationEncoder.writeEnum(out, SignatureStatus.class, this.getSignatureStatus());
        ExternalizationEncoder.writeBoolean(out, this.signatureRequired);
        ExternalizationEncoder.writeBoolean(out, this.unsolicitedResponse);
        out.writeObject(this.originalRequest);
        ExternalizationEncoder.writeBoolean(out, this.isRequest);
        ExternalizationEncoder.writeBoolean(out, this.isBackChannelBinding);
    }
}

