/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.wrapper;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.util.ExternalizationEncoder;
import org.sourceid.util.log.internal.AttrMaskingXmlObjFactoryOut;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.wrapper.BaseMessageContext;

public class OutMessageContext
extends BaseMessageContext {
    public static final String HANDLE_FAILURES_LOCALLY = "handleFailuresLocally";
    static final AttrMaskingXmlObjFactoryOut MASKING_XML_OBJ_FACTORY = new AttrMaskingXmlObjFactoryOut();
    private static final Log LOG = LogFactory.getLog(OutMessageContext.class);
    protected SignaturePolicy signaturePolicy = SignaturePolicy.BINDING_DEFAULT;
    protected String endpoint;
    private Set<String> maskedAttributeNames = Collections.emptySet();
    private Map<String, Object> supplementalContext;

    public OutMessageContext() {
    }

    public OutMessageContext(Role role) {
        super(role);
    }

    public void setSupplementalContext(String key, Object value) {
        this.checkSupCtx();
        if (value != null) {
            this.supplementalContext.put(key, value);
        } else {
            this.supplementalContext.remove(key);
        }
    }

    public Object getSupplementalContext(String key) {
        return this.supplementalContext == null ? null : this.supplementalContext.get(key);
    }

    public <T> T getSupplementalContext(String name, Class<T> type) {
        Object obj = this.getSupplementalContext(name);
        return type.cast(obj);
    }

    private void checkSupCtx() {
        if (this.supplementalContext == null) {
            this.supplementalContext = new HashMap<String, Object>();
        }
    }

    public SignaturePolicy getSignaturePolicy() {
        return this.signaturePolicy;
    }

    public void setSignaturePolicy(SignaturePolicy signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setMaskedAttributeNames(Set<String> maskedAttributeNames) {
        this.maskedAttributeNames = maskedAttributeNames;
        this.setMaskedXmlObject(null);
    }

    public Set<String> getMaskedAttributeNames() {
        return this.maskedAttributeNames;
    }

    @Override
    protected XmlObject mask() {
        return MASKING_XML_OBJ_FACTORY.getMasked(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (LOG.isTraceEnabled()) {
            if (this.endpoint != null) {
                sb.append("Endpoint: ").append(this.endpoint).append(TO_STRING_DELIM);
            }
        } else {
            String resourceUri = this.getEndpointResourceUrl();
            if (StringUtils.isNotBlank((String)resourceUri)) {
                sb.append("Endpoint: ").append(resourceUri).append(" (masked) ").append(TO_STRING_DELIM);
            }
        }
        if (this.signaturePolicy != null) {
            sb.append("SignaturePolicy: ").append(this.signaturePolicy).append(TO_STRING_DELIM);
        }
        return sb.toString();
    }

    private String getEndpointResourceUrl() {
        if (StringUtils.isBlank((String)this.endpoint)) {
            return null;
        }
        try {
            URI uri = new URI(this.endpoint);
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null).toString();
        }
        catch (URISyntaxException e) {
            LOG.debug((Object)"Endpoint parse failed");
            return null;
        }
    }

    @Override
    public StringBuilder getStandardInfo() {
        StringBuilder sb = new StringBuilder(super.getStandardInfo());
        sb.append(" | ").append("Endpoint: ").append(this.endpoint);
        return sb;
    }

    @Override
    public StringBuilder getEnhancedInfo() {
        Map<String, Object> maskedParams;
        StringBuilder sb = new StringBuilder(super.getEnhancedInfo());
        if (this.signaturePolicy != null) {
            sb.append(" | ").append("SignaturePolicy: ").append(this.signaturePolicy);
        }
        if (!(maskedParams = this.getMaskedParams()).isEmpty()) {
            sb.append(" | ").append("HTTP Request Parameters: ").append(maskedParams);
        }
        return sb;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.signaturePolicy = ExternalizationEncoder.readEnum(in, SignaturePolicy.class);
        this.endpoint = ExternalizationEncoder.readString(in);
        this.maskedAttributeNames = ExternalizationEncoder.readStringSet(in);
        this.supplementalContext = ExternalizationEncoder.readStringObjectMap(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizationEncoder.writeEnum(out, SignaturePolicy.class, this.signaturePolicy);
        ExternalizationEncoder.writeString(out, this.endpoint);
        ExternalizationEncoder.writeStringSet(out, this.maskedAttributeNames);
        ExternalizationEncoder.writeStringObjectMap(out, this.supplementalContext);
    }

    public void populateOutUrlAuditLogParameter() {
        String endpointResourceUrl = this.getEndpointResourceUrl();
        if (endpointResourceUrl != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_URL.toString(), (String)endpointResourceUrl);
        }
    }

    public void populateRequestJtiAuditLogParameter() {
        if (this.getParam("jti") != null) {
            AuditLogger.setRequestJti(this.getParam("jti"));
        }
    }
}

