/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.wrapper;

import org.apache.commons.lang.StringUtils;
import org.sourceid.saml1x.profiles.ap.ProfileSupport;
import org.sourceid.saml1x.profiles.ap.Saml1xRespOutMessageContext;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.protocol.ResponseDocOutMsgCtxUtil;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class OutMessageContextUtil {
    public static OutMessageContext buildDefaultSaml20RespCtx(InMessageContext inMsgCtx, SpConnection spConnection) {
        OutMessageContext outMsgCtx = ResponseDocOutMsgCtxUtil.newCtx(inMsgCtx);
        outMsgCtx.setEntityId(inMsgCtx.getEntityId());
        outMsgCtx.setRelayState(inMsgCtx.getRelayState());
        IndexedEndpoints acss = spConnection.getAssertionConsumerServiceEndpoints();
        Endpoint assertionConsumerService = acss.getDefault();
        outMsgCtx.setBinding(assertionConsumerService.getBinding());
        outMsgCtx.setEndpoint(assertionConsumerService.getFullLocation());
        if (inMsgCtx.isBackChannelBinding()) {
            outMsgCtx.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP(ECP)");
            Endpoint endpointByBinding = acss.getEndpointByBinding("urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
            if (endpointByBinding != null) {
                outMsgCtx.setEndpoint(endpointByBinding.getFullResponseLocation());
            }
        }
        return outMsgCtx;
    }

    public static OutMessageContext buildDefaultSaml1xRespCtx(InMessageContext inMsgCtx, SpConnection spConnection) {
        ProfileSupport profileSupport = new ProfileSupport();
        Saml1xRespOutMessageContext outMsgCtx = profileSupport.getInitialOutMsgCtx(inMsgCtx);
        String targetResource = inMsgCtx.getTargetResource();
        if (StringUtils.isBlank((String)targetResource) && spConnection.hasDefaultTargetResource()) {
            targetResource = spConnection.getDefaultTargetResource();
        }
        outMsgCtx.setTargetResource(targetResource);
        IndexedEndpoints acsEndpoints = spConnection.getAssertionConsumerServiceEndpoints();
        Endpoint acs = acsEndpoints.getDefault();
        outMsgCtx.setBinding(acs.getBinding());
        String acsUrl = acs.getFullLocation();
        outMsgCtx.setEndpoint(acsUrl);
        return outMsgCtx;
    }
}

