/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.bindings;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.RelayStateSupport;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.servlet.ServletExceptionSupport;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class WSFedBaseBinding
implements Binding {
    private final RelayStateSupport relayStateSupport = new RelayStateSupport();

    abstract void doTransport(HttpServletRequest var1, HttpServletResponse var2, OutMessageContext var3, boolean var4) throws IOException, BindingException;

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException {
        this.relayStateSupport.associate(msgCtx, req, resp, true);
        this.transport(req, resp, msgCtx, true);
        return null;
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException {
        this.transport(request, response, msgCtx, false);
    }

    void transport(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx, boolean isReq) throws IOException, BindingException {
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(msgCtx);
        String virtualEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)msgCtx, connection).getVirtualEntityId(DomainMode.RUNTIME);
        msgCtx.setParam("wtrealm", virtualEntityId);
        msgCtx.setParam("wctx", msgCtx.getRelayState());
        this.doTransport(req, resp, msgCtx, isReq);
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RenderPageException {
        String xmlStr;
        InMessageContext inMsgCtx = new InMessageContext(partnerRole);
        String realm = request.getParameter("wtrealm");
        inMsgCtx.setEntityId(realm);
        if (realm != null) {
            String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, request).getVirtualEntityId(DomainMode.RUNTIME);
            inMsgCtx.setVirtualServerId(virtualServerId);
        }
        String responseStr = request.getParameter("wresult");
        inMsgCtx.setIsRequest(StringUtils.isBlank((String)responseStr));
        String string = xmlStr = inMsgCtx.isRequest() ? request.getParameter("wreq") : responseStr;
        if (!StringUtils.isBlank((String)xmlStr)) {
            try {
                XmlObject xmlObject = XmlBeansUtil.parse(xmlStr, XmlObject.class);
                inMsgCtx.setXmlObject(xmlObject);
            }
            catch (XmlException e) {
                throw new BindingException(e);
            }
        }
        inMsgCtx.setSignatureRequired(false);
        inMsgCtx.setSignatureStatus(SignatureStatus.UNVERIFIED);
        String azureWsFedUserId = request.getParameter("username");
        if (StringUtils.isNotBlank((String)azureWsFedUserId)) {
            inMsgCtx.setRequestedUserId(azureWsFedUserId);
        }
        this.setParam(request, "wa", inMsgCtx);
        this.setParam(request, "wreply", inMsgCtx);
        this.setParam(request, "wres", inMsgCtx);
        this.setParam(request, "wct", inMsgCtx);
        String relayState = request.getParameter("wctx");
        this.relayStateSupport.lookupAssociation(inMsgCtx, relayState, request, response);
        if (inMsgCtx.getEntityId() == null) {
            this.retrieveEntityIdFromOrigRequest(inMsgCtx);
        }
        return inMsgCtx;
    }

    private void retrieveEntityIdFromOrigRequest(InMessageContext inMsgCtx) {
        OutMessageContext originalRequest = inMsgCtx.getOriginalRequest();
        if (originalRequest != null) {
            inMsgCtx.setEntityId(originalRequest.getEntityId());
        }
    }

    private void setParam(HttpServletRequest request, String name, InMessageContext inMsgCtx) {
        String value = request.getParameter(name);
        if (value != null) {
            inMsgCtx.setParam(name, value);
        }
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException {
        ServletExceptionSupport.throwServletException(e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public boolean isEntityIdRequired() {
        return true;
    }
}

