/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.domain;

import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.wsfed.domain.WSFedConnectionWrapper;

public class WsFedSpConnectionWrapper
extends WSFedConnectionWrapper {
    private final SpConnection spConnection;
    private static final int INDEX = 1;

    public WsFedSpConnectionWrapper(SpConnection spConnection) {
        this.spConnection = spConnection;
    }

    @Override
    public void setWsFedEndpointUrl(String url) {
        IndexedEndpoints acsEndPts = new IndexedEndpoints();
        Endpoint endpoint = new Endpoint("wsfed:prp:http:post", url);
        acsEndPts.setEndpoint(1, endpoint);
        acsEndPts.setDefault(1);
        this.spConnection.setAssertionConsumerServiceEndpoints(acsEndPts);
        this.setSignOutUrlForWsFed(url);
    }

    @Override
    public String getWsFedEndpointUrl() {
        String endpointUrl = null;
        IndexedEndpoints acsEndPts = this.spConnection.getAssertionConsumerServiceEndpoints();
        if (acsEndPts != null && acsEndPts.hasDefault()) {
            Endpoint endpt = acsEndPts.getDefault();
            endpointUrl = endpt.getLocation();
        }
        return endpointUrl;
    }

    @Override
    public SpConnection getConn() {
        return this.spConnection;
    }
}

