/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.idp;

import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.RequestSecurityTokenResponseCollectionDocument;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.RequestSecurityTokenResponseCollectionType;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.RequestSecurityTokenResponseDocument;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.RequestSecurityTokenResponseType;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.RequestedSecurityTokenDocument;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.RequestedSecurityTokenType;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.TokenTypeDocument;
import org.sourceid.protocol.saml11.xml.AssertionDocument;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AssertionDocument;
import org.sourceid.wsfed.profiles.idp.ClaimsUtil;
import org.sourceid.wstrust.model.WsTrustTokenType;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.w3.x2005.x08.addressing.AttributedURIType;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public final class ClaimsWsTrust13Handler
extends ClaimsUtil {
    @Override
    public XmlObject assembleRSTR(XmlObject assertionType, String partnerId, boolean isSaml2) {
        RequestSecurityTokenResponseDocument rstrDoc = RequestSecurityTokenResponseDocument.Factory.newInstance();
        RequestSecurityTokenResponseType rstrType = rstrDoc.addNewRequestSecurityTokenResponse();
        RequestedSecurityTokenDocument requestedSecurityTokenDocument = RequestedSecurityTokenDocument.Factory.newInstance();
        if (partnerId.equals("urn:federation:MicrosoftOnline")) {
            this.appendSaml11TokenTypeElementO365((XmlObject)rstrType);
        } else if (isSaml2) {
            this.appendTokenTypeElement((XmlObject)rstrType, WsTrustTokenType.SAML20.getUri());
        } else {
            this.appendTokenTypeElement((XmlObject)rstrType, WsTrustTokenType.SAML11.getUri());
        }
        if (isSaml2) {
            this.appendRequestSecurityTokenElement((org.sourceid.saml20.xmlbinding.assertion.AssertionType)assertionType, (XmlObject)rstrType, requestedSecurityTokenDocument);
        } else {
            this.appendRequestSecurityTokenElement((AssertionType)assertionType, (XmlObject)rstrType, requestedSecurityTokenDocument);
        }
        this.appendAppliesElement(partnerId, (XmlObject)rstrType);
        RequestSecurityTokenResponseCollectionDocument requestSecurityTokenResponseObjectDocument = RequestSecurityTokenResponseCollectionDocument.Factory.newInstance();
        RequestSecurityTokenResponseCollectionType requestSecurityTokenResponseCollectionType = requestSecurityTokenResponseObjectDocument.addNewRequestSecurityTokenResponseCollection();
        this.appendElement((XmlObject)requestSecurityTokenResponseCollectionType, (XmlObject)rstrDoc);
        return requestSecurityTokenResponseObjectDocument;
    }

    private void appendRequestSecurityTokenElement(org.sourceid.saml20.xmlbinding.assertion.AssertionType assertionType, XmlObject rstrType, RequestedSecurityTokenDocument requestedSecurityTokenDocument) {
        RequestedSecurityTokenType rstType = requestedSecurityTokenDocument.addNewRequestedSecurityToken();
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        assertionDoc.setAssertion(assertionType);
        this.appendElement((XmlObject)rstType, (XmlObject)assertionDoc);
        this.appendElement(rstrType, (XmlObject)requestedSecurityTokenDocument);
    }

    private void appendRequestSecurityTokenElement(AssertionType assertionType, XmlObject rstrType, RequestedSecurityTokenDocument requestedSecurityTokenDocument) {
        RequestedSecurityTokenType rstType = requestedSecurityTokenDocument.addNewRequestedSecurityToken();
        org.sourceid.protocol.saml11.xml.AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        assertionDoc.setAssertion(assertionType);
        this.appendElement((XmlObject)rstType, (XmlObject)assertionDoc);
        this.appendElement(rstrType, (XmlObject)requestedSecurityTokenDocument);
    }

    private void appendSaml11TokenTypeElementO365(XmlObject rstrType) {
        TokenTypeDocument tokenTypeDoc = TokenTypeDocument.Factory.newInstance();
        tokenTypeDoc.setTokenType("urn:oasis:names:tc:SAML:1.0:assertion");
        this.appendElement(rstrType, (XmlObject)tokenTypeDoc);
    }

    EndpointReferenceDocument getEndpointReferenceDocument(String partnerId) {
        EndpointReferenceDocument endPointRefDoc = EndpointReferenceDocument.Factory.newInstance();
        EndpointReferenceType endpointRefType = endPointRefDoc.addNewEndpointReference();
        AttributedURIType address = endpointRefType.addNewAddress();
        address.setStringValue(partnerId);
        return endPointRefDoc;
    }

    @Override
    public String getResponseTypeName() {
        return WSTrustVersion.v13.getResponseType();
    }
}

