/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.idp;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.RequestSecurityTokenResponseCollectionDocument;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml1x.protocol.AssertionAssembler;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WhitelistData;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.validation.RedirectValidationHelper;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupport;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.FailedAuthnSsoException;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.idp.SsoRespSupport;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;
import org.sourceid.wsfed.profiles.idp.ClaimsUtil;
import org.sourceid.wsfed.profiles.idp.HandleWsFedRequest;
import org.sourceid.wsfed.profiles.idp.WsFedRequestHandler;
import org.sourceid.wstrust.handlers.JwtTokenCreator;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.RequestSecurityTokenResponse;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustTokenType;
import org.sourceid.wstrust.model.mapper.WSTrustXmlMapper;
import org.sourceid.wstrust.protocol.WSTrustProtocolManager;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.wsse.WsseProcessor;
import org.xmlsoap.schemas.ws.x2005.x02.trust.RequestSecurityTokenResponseCollectionDocument;
import org.xmlsoap.schemas.ws.x2005.x02.trust.RequestSecurityTokenResponseDocument;

public class HandleRST
implements WsFedRequestHandler,
ResumeRequestFromAuthnResponseHandler {
    private static final AuthnPolicy AUTHN_POLICY = new AuthnPolicy(true, false);
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private final SignatureEngine signatureEngine = GlobalRegistry.getService(SignatureEngine.class);
    private final SsoRespSupport respSupport = new SsoRespSupport();
    private final AuthnSourceSupport adapterSupport = new AuthnSourceSupport();
    private final AssertionAssembler assembler = new AssertionAssembler();
    private final org.sourceid.saml20.protocol.AssertionAssembler saml2Assembler;
    private final HandleWsFedRequest mainHandler;

    public HandleRST(HandleWsFedRequest mainHandler) {
        this.mainHandler = mainHandler;
        this.saml2Assembler = new org.sourceid.saml20.protocol.AssertionAssembler();
    }

    @Override
    public OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx) {
        SpConnection spConnection = this.metadataDirectory.getSpConnectionMetadata(inMsgCtx.getEntityId());
        LicenseManager.checkLicenseForConnection(spConnection);
        OutMessageContext outMsgCtx = new OutMessageContext(Role.SP);
        outMsgCtx.setEntityId(inMsgCtx.getEntityId());
        outMsgCtx.setVirtualServerId(inMsgCtx.getVirtualServerId());
        IndexedEndpoints acsEndpoints = spConnection.getAssertionConsumerServiceEndpoints();
        Endpoint acs = acsEndpoints.getDefault();
        outMsgCtx.setBinding(acs.getBinding());
        outMsgCtx.setEndpoint(acs.getFullLocation());
        if (inMsgCtx.getParam("wreply") != null) {
            outMsgCtx.setEndpoint(inMsgCtx.getParam("wreply"));
        }
        return outMsgCtx;
    }

    @Override
    public Map<String, Object> handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        StateMgmtFactory.checkSessionRevoked(req, resp);
        HashMap<String, Object> otherState = new HashMap<String, Object>();
        otherState.put("PartnerEntityId", inMsgCtx.getEntityId());
        SpConnection spConnection = this.metadataDirectory.getSpConnectionMetadata(inMsgCtx.getEntityId());
        RedirectValidationHelper validationHelper = new RedirectValidationHelper();
        WhitelistData wlData = new WhitelistData();
        wlData.setDefaultURLs(Collections.singletonList(spConnection.getAssertionConsumerServiceEndpoints().getDefault().getFullLocation()));
        wlData.setEntries(spConnection.getRedirectValidationWhitelist());
        try {
            validationHelper.validate(wlData, outMsgCtx.getEndpoint());
        }
        catch (InvalidRedirectValidationException e) {
            throw new RequestProcessingException("The requested partner endpoint is not allowed: " + outMsgCtx.getEndpoint());
        }
        return otherState;
    }

    @Override
    public Map<String, Object> invokeAdapter(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws IOException, GeneralAdapterException, AuthnProcessorException, AuthorizationException {
        String partnerEntityId = inMsgCtx.getEntityId();
        IdpAuditLogger.setPartnerId(partnerEntityId);
        IdpAuditLogger.setVirtualServerId(inMsgCtx.getVirtualServerId());
        SpConnection spConnection = MetadataSupport.getSpConnection(partnerEntityId);
        IdpAuditLogger.setProtocol(spConnection.getProtocol().toString());
        String resumePath = this.mainHandler.doSaveState(req, resp, inMsgCtx, outMsgCtx, otherState);
        IdpAuthenticationResult authnResult = this.adapterSupport.lookupAuthNs(req, resp, AUTHN_POLICY, resumePath, otherState, inMsgCtx, outMsgCtx, this, false);
        HashMap<String, Object> params = new HashMap<String, Object>(otherState);
        params.put("sso-authn-result", authnResult);
        return params;
    }

    @Override
    public void finalize(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws RequestProcessingException {
        IdpAuthenticationResult authnResult;
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"Request");
        String partnerEntityId = inMsgCtx.getEntityId();
        IdpAuditLogger.setPartnerId(partnerEntityId);
        SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(outMsgCtx.getEntityId());
        if (sp != null) {
            IdpAuditLogger.setProtocol(sp.getProtocol().toString());
        }
        if ((authnResult = (IdpAuthenticationResult)params.get("sso-authn-result")) == null || Util.isEmpty(authnResult.getAuthnAttrs())) {
            FailedAuthnSsoException failedAuthn = new FailedAuthnSsoException();
            throw new RequestProcessingException("Unable to authenticate the user.", failedAuthn);
        }
        AttributeValue authnMethod = this.respSupport.getAuthnCtxFromAuthnAttrs(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans(), "urn:oasis:names:tc:SAML:1.0:am:unspecified");
        this.doResumeSsoFromIdp(authnResult, req, resp, inMsgCtx, outMsgCtx, params, authnMethod, sp);
    }

    @Override
    public void resumeSsoFromIdp(IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, InMessageContext reqInMsgCtx, OutMessageContext respOutMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue) throws RequestProcessingException {
        String partnerEntityId = reqInMsgCtx.getEntityId();
        SpConnection spConnection = MetadataSupport.getSpConnection(partnerEntityId);
        IdpAuditLogger.setPartnerId(partnerEntityId);
        IdpAuditLogger.setVirtualServerId(reqInMsgCtx.getVirtualServerId());
        IdpAuditLogger.setProtocol(spConnection.getProtocol().toString());
        this.doResumeSsoFromIdp(authnResult, req, resp, reqInMsgCtx, respOutMsgCtx, otherState, authnCtxValue, spConnection);
    }

    private void doResumeSsoFromIdp(IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, InMessageContext reqInMsgCtx, OutMessageContext respOutMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue, SpConnection sp) throws RequestProcessingException {
        String partnerEntityId = reqInMsgCtx.getEntityId();
        AttributeMap incomingAttrs = authnResult.getAuthnAttrs();
        if (incomingAttrs != null && incomingAttrs.get((Object)"TargetResource") != null) {
            IdpAuditLogger.setAppUrl(((AttributeValue)incomingAttrs.get((Object)"TargetResource")).getValue());
        }
        IdpAuditLogger.setAuthnSourceId(AuthnSourceSupport.getAuthnSourceKeys(authnResult.getAuthnBeans()));
        LinkedList authenticatingAuthorities = (LinkedList)otherState.get("authnAuthorityEntityIds");
        AttributeMap contextAttributes = new AttributeMap();
        contextAttributes.putIfNotPresent(SourceContextType.AUTHN_CTX.getId(), authnCtxValue);
        contextAttributes.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
        contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        contextAttributes.put(SourceContextType.VIRTUAL_SERVER_ID.getId(), reqInMsgCtx.getVirtualServerId());
        if (authenticatingAuthorities != null && !authenticatingAuthorities.isEmpty()) {
            AttributeValue authnAuthoritiesAttributeValue = new AttributeValue((Collection)authenticatingAuthorities);
            contextAttributes.put(SourceContextType.AUTHENTICATING_AUTHORITY.getId(), authnAuthoritiesAttributeValue);
        }
        AttributeMap attributes = this.respSupport.executeAuthnSourceToAssertionMapping(authnResult, sp, contextAttributes, otherState);
        respOutMsgCtx.setMaskedAttributeNames(attributes.getMaskedAttributeNames());
        IdpAuditLogger.setUserName((Map<String, AttributeValue>)attributes);
        AttributeValue nameIdAttribute = (AttributeValue)attributes.get((Object)AssertionMapKeys.getNameIdValueKey());
        IdpAuditLogger.setAttributes(attributes.toString());
        String myEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)reqInMsgCtx, sp).getVirtualEntityId(DomainMode.RUNTIME);
        if (sp.getWsFedSettings().getTokenType() == WsTrustTokenType.SAML11) {
            attributes.putIfNotPresent(AssertionMapKeys.getAuthnCtxKey(), authnCtxValue);
            AssertionType assertionType = this.buildSaml11Rstr(sp, attributes, authnResult, req, resp, respOutMsgCtx, partnerEntityId, myEntityId, otherState);
            if (sp.supportsSLO()) {
                NameIDType nameID = NameIDType.Factory.newInstance();
                nameID.setStringValue(nameIdAttribute.getValue());
                IdpSessionRegistrySupport.registerAssertionIssued(req, resp, otherState, authnResult.getAuthnBeans(), assertionType, partnerEntityId, nameID, nameIdAttribute.isMasked(), reqInMsgCtx.getVirtualServerId());
            }
        } else if (sp.getWsFedSettings().getTokenType() == WsTrustTokenType.JWT) {
            this.buildJwtRstr(sp, attributes, authnResult.getAuthnBeans(), req, resp, respOutMsgCtx, otherState);
            if (sp.supportsSLO()) {
                IdpSessionRegistrySupport.registerAuthnBeansForSlo(req, resp, otherState, authnResult.getAuthnBeans());
            }
        } else if (sp.getWsFedSettings().getTokenType() == WsTrustTokenType.SAML20) {
            attributes.putIfNotPresent(AssertionMapKeys.getAuthnCtxKey(), authnCtxValue);
            org.sourceid.saml20.xmlbinding.assertion.AssertionType assertionType = this.buildSaml2Rstr(sp, attributes, authnResult, req, resp, respOutMsgCtx, partnerEntityId, myEntityId, otherState);
            if (sp.supportsSLO()) {
                NameIDType nameID = NameIDType.Factory.newInstance();
                nameID.setStringValue(nameIdAttribute.getValue());
                IdpSessionRegistrySupport.registerAssertionIssued(req, resp, otherState, authnResult.getAuthnBeans(), assertionType, partnerEntityId, nameID, nameIdAttribute.isMasked(), reqInMsgCtx.getVirtualServerId());
            }
        }
        if (respOutMsgCtx != null) {
            respOutMsgCtx.populateOutUrlAuditLogParameter();
            ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(respOutMsgCtx).toString());
        }
        this.cleanUpFedHubMessageStateParams(otherState);
        IdpAuditLogger.setVirtualServerId(myEntityId);
        IdpAuditLogger.setEvent("SSO");
        IdpAuditLogger.setStatus("success");
        IdpAuditLogger.log("issuing security token");
    }

    private AssertionType buildSaml11Rstr(SpConnection sp, AttributeMap attributes, IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, OutMessageContext respOutMsgCtx, String partnerEntityId, String myEntityId, Map<String, Object> otherState) throws RequestProcessingException {
        AttributeMap copyOfAttributes = null;
        ClaimsUtil wsTrustClaimsUtil = this.getClaimsUtil(sp);
        if (sp.hasMessageCustomizationHook("assertion") || sp.hasMessageCustomizationHook("authn-response")) {
            copyOfAttributes = new AttributeMap((Map)attributes);
        }
        Calendar authnInst = this.respSupport.getAuthnInstantValue(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans());
        AssertionType assertionType = this.assembler.assemble((Map<String, AttributeValue>)attributes, sp, "http://schemas.xmlsoap.org/claims", myEntityId, null, authnInst);
        Map<String, Object> assertionCustomizeContext = MessageCustomization.getAssertionCustomisationContext((XmlObject)assertionType, copyOfAttributes, authnResult.getAuthnBeans());
        assertionType = sp.customizeAssertion(req, resp, assertionType, assertionCustomizeContext, otherState);
        try {
            assertionType = this.signatureEngine.signAssertion(respOutMsgCtx, assertionType);
        }
        catch (SigningException ex) {
            throw new RequestProcessingException("Unable to sign the assertion. ", ex);
        }
        XmlObject rstr = wsTrustClaimsUtil.assembleRSTR((XmlObject)assertionType, partnerEntityId, false);
        Map<String, Object> respCustomizeContext = MessageCustomization.getResponseCustomizeContext(sp, copyOfAttributes, authnResult.getAuthnBeans());
        rstr = sp.customizeResponse(XmlObject.class, req, resp, rstr, wsTrustClaimsUtil.getResponseTypeName(), respCustomizeContext, otherState);
        respOutMsgCtx.setXmlObject(rstr);
        return assertionType;
    }

    private org.sourceid.saml20.xmlbinding.assertion.AssertionType buildSaml2Rstr(SpConnection sp, AttributeMap attributes, IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, OutMessageContext respOutMsgCtx, String partnerEntityId, String myEntityId, Map<String, Object> otherState) throws RequestProcessingException {
        org.sourceid.saml20.xmlbinding.assertion.AssertionType assertionType;
        AttributeMap copyOfAttributes = null;
        ClaimsUtil wsTrustClaimsUtil = this.getClaimsUtil(sp);
        if (sp.hasMessageCustomizationHook("assertion") || sp.hasMessageCustomizationHook("authn-response")) {
            copyOfAttributes = new AttributeMap((Map)attributes);
        }
        Calendar authnInst = this.respSupport.getAuthnInstantValue(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans());
        try {
            assertionType = this.saml2Assembler.assemble((Map<String, AttributeValue>)attributes, sp, myEntityId, authnInst);
        }
        catch (StatusResponseException sse) {
            throw new RequestProcessingException("Unable to sign the assertion. ", sse);
        }
        Map<String, Object> assertionCustomizeContext = MessageCustomization.getAssertionCustomisationContext((XmlObject)assertionType, copyOfAttributes, authnResult.getAuthnBeans());
        assertionType = sp.messageCustomize("assertion", org.sourceid.saml20.xmlbinding.assertion.AssertionType.class, req, resp, assertionType, "AssertionType", assertionCustomizeContext, otherState);
        boolean encryptSubject = sp.getEncryptionSettings().getEncryptionPolicy().isEncryptSubjectNameID();
        if (encryptSubject) {
            this.saml2Assembler.encryptSubjectNameID(sp, assertionType.getSubject(), false);
        }
        try {
            assertionType = this.signatureEngine.signAssertion(respOutMsgCtx, assertionType);
        }
        catch (SigningException ex) {
            throw new RequestProcessingException("Unable to sign the assertion. ", ex);
        }
        XmlObject rstr = wsTrustClaimsUtil.assembleRSTR((XmlObject)assertionType, partnerEntityId, true);
        Map<String, Object> respCustomizeContext = MessageCustomization.getResponseCustomizeContext(sp, copyOfAttributes, authnResult.getAuthnBeans());
        rstr = sp.customizeResponse(XmlObject.class, req, resp, rstr, wsTrustClaimsUtil.getResponseTypeName(), respCustomizeContext, otherState);
        respOutMsgCtx.setXmlObject(rstr);
        return assertionType;
    }

    private ClaimsUtil getClaimsUtil(SpConnection sp) {
        return ClaimsUtil.getInstance(sp.getWsFedSettings().getWsTrustVersion());
    }

    private void buildJwtRstr(SpConnection sp, AttributeMap attributes, IdpHashableAuthnBean[] authnBeans, HttpServletRequest req, HttpServletResponse resp, OutMessageContext respOutMsgCtx, Map<String, Object> otherState) throws RequestProcessingException {
        AttributeMap copyOfAttributes = null;
        if (sp.hasMessageCustomizationHook("assertion") || sp.hasMessageCustomizationHook("authn-response")) {
            copyOfAttributes = new AttributeMap((Map)attributes);
        }
        JwtTokenCreator jwtCreator = new JwtTokenCreator();
        SecurityToken token = null;
        try {
            token = jwtCreator.createTokenForPassive(attributes, sp, respOutMsgCtx);
        }
        catch (WSTrustException ex) {
            throw new RequestProcessingException("Unable to sign the RSTR JWT.", ex);
        }
        WSTrustVersion wstVersion = sp.getWsFedSettings() != null && WSTrustVersion.v13.getVersion().equals(sp.getWsFedSettings().getWsTrustVersion()) ? WSTrustVersion.v13 : WSTrustVersion.v2005;
        WSTrustProtocolManager wstProtocolMgr = GlobalRegistry.getService(wstVersion.getProtocolManagerServiceId(), WSTrustProtocolManager.class);
        RequestSecurityTokenResponse rstr = wstProtocolMgr.transmit(token);
        rstr.setTokenType(WsTrustTokenType.JWT.getUri());
        rstr.setAppliesTo(new AppliesTo(sp.getEntityId()));
        WsseProcessor wsseProcessor = new WsseProcessor();
        Object rstrXml = WSTrustXmlMapper.map(rstr, wstVersion, this.getVersionURI(wstVersion), wsseProcessor);
        try {
            rstrXml = WSTrustVersion.v13 == wstVersion ? RequestSecurityTokenResponseCollectionDocument.Factory.parse((String)rstrXml.xmlText(XmlBeansUtil.getXmlOptions())) : (wstVersion.useResponseCollection() ? RequestSecurityTokenResponseCollectionDocument.Factory.parse((String)rstrXml.xmlText(XmlBeansUtil.getXmlOptions())) : RequestSecurityTokenResponseDocument.Factory.parse((String)rstrXml.xmlText(XmlBeansUtil.getXmlOptions())));
        }
        catch (XmlException e) {
            throw new RequestProcessingException("Unable to apply message customization hook.", e);
        }
        if (sp.getMessageCustomizationHooks().get(wstVersion.getResponseType()) != null) {
            Map<String, Object> respCustomizeContext = MessageCustomization.getResponseCustomizeContext(sp, copyOfAttributes, authnBeans);
            rstrXml = sp.customizeResponse(XmlObject.class, req, resp, rstrXml, wstVersion.getResponseType(), respCustomizeContext, otherState);
        }
        respOutMsgCtx.setXmlObject((XmlObject)rstrXml);
    }

    @Override
    public void resumeAuthn(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) {
        try {
            this.mainHandler.resume(inMsgCtx, req, resp, outMsgCtx, otherState);
        }
        catch (Exception e) {
            this.mainHandler.handleEx(e, inMsgCtx, outMsgCtx, otherState, req, resp);
        }
    }

    private String getVersionURI(WSTrustVersion wstVersion) {
        if (WSTrustVersion.v13 == wstVersion && !wstVersion.getDocumentNamespace().getUri().endsWith("/")) {
            return wstVersion.getDocumentNamespace().getUri() + "/";
        }
        return wstVersion.getDocumentNamespace().getUri();
    }

    private void cleanUpFedHubMessageStateParams(Map<String, Object> stateParams) {
        stateParams.remove("FEDHUB_IN_REQ_CONTEXT");
        stateParams.remove("FEDHUB_IN_RESP_CONTEXT");
        stateParams.remove("FEDHUB_OUT_REQ_CONTEXT");
    }
}

