/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.idp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.state.State;
import org.sourceid.websso.DisplayableException;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumableRequestHandlerBase;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wsfed.profiles.idp.ClaimsUtil;
import org.sourceid.wsfed.profiles.idp.HandleRST;
import org.sourceid.wsfed.profiles.idp.HandleSignoutRequest;
import org.sourceid.wsfed.profiles.idp.WsFedRequestHandler;

public class HandleWsFedRequest
extends ResumableRequestHandlerBase {
    private HandleSignoutRequest signoutRequestHandler = new HandleSignoutRequest();
    private HandleRST rstHandler = new HandleRST(this);

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        WsFedRequestHandler handler = this.getHandler(inMsgCtx.getParam("wa"));
        return handler.getInitialOutMsgCtx(inMsgCtx);
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        WsFedRequestHandler handler = this.getHandler(inMsgCtx.getParam("wa"));
        Map<String, Object> params = handler.handle(inMsgCtx, req, resp, outMsgCtx);
        if (params != null) {
            this.addTrackedParams(req, params);
            String policyAction = ProprietaryURLParams.getParam(req, "PolicyAction");
            params.put("PolicyAction", policyAction);
        }
        this.resume(inMsgCtx, req, resp, outMsgCtx, params);
    }

    @Override
    public void resume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException {
        super.resume(inMsgCtx, req, resp, outMsgCtx, otherState);
    }

    @Override
    protected void exeResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException {
        Map<String, Object> params;
        WsFedRequestHandler handler = this.getHandler(inMsgCtx.getParam("wa"));
        try {
            params = handler.invokeAdapter(inMsgCtx, req, resp, outMsgCtx, otherState);
        }
        catch (AuthorizationException | AuthnProcessorException e) {
            throw new RequestProcessingException(e.getMessage(), e);
        }
        if (!resp.isCommitted()) {
            handler.finalize(inMsgCtx, req, resp, outMsgCtx, params);
        }
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) {
        ClaimsUtil.handleException(e, inMsgCtx, outMsgCtx, stateParams, req, resp);
    }

    private WsFedRequestHandler getHandler(String action) {
        if ("wsignin1.0".equals(action)) {
            return this.rstHandler;
        }
        if ("wsignout1.0".equals(action)) {
            return this.signoutRequestHandler;
        }
        String error = "Unrecognized value for the parameter wa";
        throw new DisplayableException(error);
    }

    @Override
    protected boolean isStateAppropriate(State state) {
        return true;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }

    protected String doSaveState(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherInfo) {
        return this.saveState(req, resp, inMsgCtx, outMsgCtx, otherInfo);
    }

    public void registerRstHandlerAsResumeFromResponseHandler(Map<String, ResumeRequestFromAuthnResponseHandler> class2HandlerMap) {
        class2HandlerMap.put(this.rstHandler.getClass().getName(), this.rstHandler);
    }
}

