/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.sp;

import java.math.BigInteger;
import java.util.List;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.saml11.xml.AttributeStatementType;
import org.sourceid.protocol.saml11.xml.AuthenticationStatementType;
import org.sourceid.protocol.saml11.xml.SubjectType;
import org.sourceid.saml1x.protocol.ValidateAssertionConditions;
import org.sourceid.saml1x.protocol.ValidateAssertionIssuer;
import org.sourceid.saml1x.wrapper.AssertionStatus;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;

public class AssertionValidator {
    private static final ValidateAssertionIssuer validateAssertionIssuer = new ValidateAssertionIssuer();
    private static final ValidateAssertionConditions validateAssertionConditions = new ValidateAssertionConditions();

    static void validateAssertion(AssertionType assertionType, List<String> myAudienceIds, String partnerEntityId) throws InvalidResponseException {
        AssertionStatus assertionStatus = new AssertionStatus(assertionType);
        validateAssertionIssuer.validate(assertionStatus, partnerEntityId);
        validateAssertionConditions.validate(assertionStatus, myAudienceIds);
        if (!assertionType.isSetConditions()) {
            assertionStatus.addInvalidRemark("Conditions not set on assertion.");
        } else if (assertionType.getConditions().sizeOfAudienceRestrictionConditionArray() == 0) {
            assertionStatus.addInvalidRemark("<AudienceRestrictionCondition> is required.");
        }
        BigInteger majorVersion = assertionType.getMajorVersion();
        BigInteger minorVersion = assertionType.getMinorVersion();
        if (!majorVersion.equals(BigInteger.ONE) || !minorVersion.equals(BigInteger.ONE)) {
            assertionStatus.addInvalidRemark("assertion version (" + majorVersion + "." + minorVersion + ") is not supported");
        }
        SubjectType subject = null;
        AttributeStatementType[] attrStmts = assertionType.getAttributeStatementArray();
        if (attrStmts.length > 0) {
            subject = attrStmts[attrStmts.length - 1].getSubject();
        }
        if (assertionType.sizeOfAuthenticationStatementArray() > 0) {
            AuthenticationStatementType authnStatementType = assertionType.getAuthenticationStatementArray(0);
            subject = authnStatementType.getSubject();
        }
        if (subject == null || !subject.isSetNameIdentifier()) {
            assertionStatus.addInvalidRemark("<NameIdentifier> is required for WS-FED's assertion subject.");
        }
        if (!assertionStatus.isValid()) {
            throw new InvalidSsoResponseException(assertionStatus.toString() + ". " + assertionType);
        }
    }
}

