/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.sp;

import com.pingidentity.sdk.DeviceSharingType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeStatementType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeType;
import org.sourceid.saml20.xmlbinding.assertion.ConditionsType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.wsfed.domain.WsFedParsedRequest;
import org.sourceid.wsfed.profiles.sp.Saml2AssertionValidator;
import org.sourceid.wsfed.profiles.sp.SamlRstrHandler;

public class HandleSaml2RSTR
implements SamlRstrHandler {
    private static final AssertionAssembler assertionAssembler = new AssertionAssembler();
    private static final EncryptionEngine encryptionEngine = GlobalRegistry.getService(EncryptionEngine.class);
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public AttributeMap getAttributeMap(Object assertionType, Set<String> maskedAttributeNames) {
        return assertionAssembler.disassemble((AssertionType)assertionType, maskedAttributeNames);
    }

    @Override
    public IdpConnHashableAuthnBean getIdpAuthBean(HttpServletRequest req, HttpServletResponse resp, Set<String> maskedAttributeNames, Map<String, Object> params, Object assertionType, String localSessionId, String partnerEntityId, String virtualServerId, String connectionId, NameIDType newAssertionId) throws IOException {
        IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)params.get("idpConnBean");
        if (idpConnBean == null) {
            AttributeMap assertionAttributes = assertionAssembler.disassemble((AssertionType)assertionType, maskedAttributeNames);
            DeviceSharingType deviceSharingType = IdpSessionRegistrySupport.getDeviceSharingTypeFromStateParams(params);
            idpConnBean = new IdpConnHashableAuthnBean(assertionAttributes, localSessionId, (AuthnSourceKey)new IdpConnAuthnSourceKey(connectionId), partnerEntityId, localSessionId, virtualServerId, null, null, newAssertionId, deviceSharingType);
            params.put("idpConnBean", idpConnBean);
        }
        return idpConnBean;
    }

    @Override
    public void registerSessionReceived(SpHashableAuthnBean authnBean, Object assertionType, String partnerEntityId, String virtualServerId) {
        SpSessionRegistrySupport.registerSessionReceived(authnBean, (AssertionType)assertionType, partnerEntityId, virtualServerId);
    }

    @Override
    public void verifySignature(InMessageContext respMsgCtx, HttpServletRequest request, Object assertionType) throws InvalidResponseException {
        if (assertionType == null) {
            throw new InvalidResponseException("Unable to find a SAML assertion in the RSTS.");
        }
        AssertionType assertion = (AssertionType)assertionType;
        SignatureResult sigResult = signatureEngine.verifyAssertionSignature(assertion);
        SignatureStatus sigStatus = sigResult.getStatus();
        if (sigStatus != SignatureStatus.VALID) {
            StringBuilder sb = new StringBuilder();
            sb.append(sigResult).append(" signature on assertion (ID=").append(assertion.getID());
            sb.append("). ").append("All assertions must have valid signatures. ");
            throw new InvalidSsoResponseException(sb.toString());
        }
        request.setAttribute("AssertionSigsVerified", (Object)true);
    }

    @Override
    public Object validateResponse(WsFedParsedRequest wsFedParsedRequest) throws InvalidResponseException {
        if (wsFedParsedRequest == null || wsFedParsedRequest.getAssertion() == null) {
            throw new InvalidSsoResponseException("No SAML Assertion is found in RSTR.");
        }
        String partnerEntityId = wsFedParsedRequest.getPartnerEntityId();
        List<String> myEntityIds = wsFedParsedRequest.getEntityIds();
        IdpConnection idpConnection = wsFedParsedRequest.getConnection();
        AssertionType assertion = (AssertionType)wsFedParsedRequest.getAssertion();
        if (idpConnection.getEncryptionSettings().getDecryptionPolicy() != null && idpConnection.getEncryptionSettings().getDecryptionPolicy().isSubjectNameIDEncrypted()) {
            if (!assertion.getSubject().isSetEncryptedID()) {
                throw new InvalidResponseException("The connection is configured to handle encrypted SAML Subject but couldn't find it.");
            }
            EncryptedElementType encryptedNameId = assertion.getSubject().getEncryptedID();
            try {
                String myRecip = VirtualIdentityUtil.resolve(wsFedParsedRequest.getRequestedVsId(), idpConnection, false).getVirtualEntityId(DomainMode.RUNTIME);
                NameIDType nameId = encryptionEngine.decryptNameID(idpConnection, encryptedNameId, myRecip);
                SubjectType subject = assertion.getSubject();
                subject.unsetEncryptedID();
                subject.setNameID(nameId);
            }
            catch (XMLEncryptionException ex) {
                throw new ProcessRuntimeException("Unable to decrypt the NameID.", ex);
            }
            catch (NoEncryptionKeyException ex) {
                throw new ProcessRuntimeException("No decryption key to decrypt the NameID.", ex);
            }
        } else if (assertion.getSubject().isSetEncryptedID() && !assertion.getSubject().isSetNameID()) {
            throw new InvalidResponseException("The connection is configured to handle unencrypted SAML Subject but couldn't find it.");
        }
        if (idpConnection.getEncryptionSettings().getDecryptionPolicy() != null && idpConnection.getEncryptionSettings().getDecryptionPolicy().isAttributeEncrypted()) {
            boolean attributeEncrypted = false;
            for (AttributeStatementType attibStmt : assertion.getAttributeStatementArray()) {
                EncryptedElementType[] encryptedAttribs = attibStmt.getEncryptedAttributeArray();
                try {
                    for (EncryptedElementType encryptedAttrib : encryptedAttribs) {
                        attributeEncrypted = true;
                        String virtualEntityId = VirtualIdentityUtil.resolve(wsFedParsedRequest.getRequestedVsId(), idpConnection, false).getVirtualEntityId(DomainMode.RUNTIME);
                        AttributeType attribute = encryptionEngine.decryptAttribute(idpConnection, encryptedAttrib, virtualEntityId);
                        attibStmt.addNewAttribute().set((XmlObject)attribute);
                    }
                    attibStmt.setEncryptedAttributeArray(new EncryptedElementType[0]);
                }
                catch (Exception ex) {
                    this.log.warn((Object)("Unable to decrypt an attribute. " + ex.getMessage()));
                }
            }
            if (!attributeEncrypted && assertion.getAttributeStatementArray() != null && assertion.getAttributeStatementArray().length > 0) {
                throw new InvalidResponseException("The connection is configured to handle encrypted attributes but did not find any encrypted attributes.");
            }
        }
        Saml2AssertionValidator saml2Validator = new Saml2AssertionValidator(assertion);
        saml2Validator.validateAssertion(myEntityIds, partnerEntityId);
        return assertion;
    }

    @Override
    public NameIDType getNameId(Object assertionType) {
        return ((AssertionType)assertionType).getSubject().getNameID();
    }

    @Override
    public boolean hasDoNotCacheAssertion(XmlObject assertionType) {
        ConditionsType conditions = ((AssertionType)assertionType).getConditions();
        return conditions.sizeOfOneTimeUseArray() > 0;
    }
}

