/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wsfed.profiles.sp;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml1x.protocol.ValidateAssertionIssuer;
import org.sourceid.saml20.protocol.ValidateAssertionConditions;
import org.sourceid.saml20.protocol.ValidateAssertionHasSubjectStatements;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;

public class Saml2AssertionValidator {
    private AssertionType assertionType;
    private final Log log = LogFactory.getLog(this.getClass());
    private final ValidateAssertionConditions validateAssertionConditions;
    private final ValidateAssertionHasSubjectStatements validateAssertionHasSubjectStmts;
    private final ValidateAssertionIssuer issuerValidator = new ValidateAssertionIssuer();

    public Saml2AssertionValidator(AssertionType assertionType) {
        this.assertionType = assertionType;
        this.validateAssertionHasSubjectStmts = new ValidateAssertionHasSubjectStatements();
        this.validateAssertionHasSubjectStmts.setRequireStatements(false);
        this.validateAssertionConditions = new ValidateAssertionConditions();
    }

    public void validateAssertion(List<String> myAudienceIds, String partnerEntityId) throws InvalidResponseException {
        Assertion assertionStatus = new Assertion(this.assertionType);
        this.validateVersion(assertionStatus);
        this.issuerValidator.validate(assertionStatus, partnerEntityId);
        this.validateAssertionConditions.validate(assertionStatus, myAudienceIds);
        this.validateAssertionHasSubjectStmts.validate(assertionStatus);
        if (!assertionStatus.isValid()) {
            throw new InvalidSsoResponseException(assertionStatus.toString() + ". " + this.assertionType);
        }
    }

    private void validateVersion(Assertion assertionStatus) {
        if (!this.assertionType.getVersion().equals("2.0")) {
            assertionStatus.addInvalidRemark("assertion version (" + this.assertionType.getVersion() + ") is not supported");
        }
    }
}

