/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.bindings;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.SoapServerSupport;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.websso.bindings.ProtocolBindingGroup;
import org.sourceid.wstrust.bindings.WSTrustBinding;
import org.sourceid.wstrust.bindings.WSTrustSoap11Binding;
import org.sourceid.wstrust.bindings.WSTrustSoap12Binding;

public class WSTrustBindingGroup
extends ProtocolBindingGroup {
    public WSTrustBindingGroup() {
        this.bindings = new Binding[]{new WSTrustSoap11Binding(), new WSTrustSoap12Binding()};
    }

    @Override
    public String ascertainBindingName(HttpServletRequest req, boolean isPost) throws IOException {
        if (isPost) {
            SoapServerSupport soapSupport = SoapServerSupport.getSupport(req);
            try {
                return soapSupport.getXmlNamespaceURI();
            }
            catch (InvalidRequestException e) {
                IOException ioException = new IOException("Problem with SOAP message:" + e.getMessage());
                ioException.initCause(e);
                throw ioException;
            }
        }
        return WSTrustBinding.GET.uri();
    }
}

