/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.crypto;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.sourceid.common.XmlEncryption;
import org.sourceid.util.Defense;
import org.sourceid.wstrust.model.KeyType;
import org.sourceid.wstrust.plugin.TokenProcessingException;

public class KeyProvider {
    public static final KeyType DefaultType = KeyType.Symmetric;
    private String defaultAlgo;
    private static Map<Integer, String> sizeToAlgo = new HashMap<Integer, String>();

    public KeyProvider() {
        this.setIfAvaliable("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.setIfAvaliable("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        this.setIfAvaliable("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        sizeToAlgo.put(128, "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        sizeToAlgo.put(192, "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        sizeToAlgo.put(256, "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
    }

    private void setIfAvaliable(String algo) {
        if (XmlEncryption.isEncryptionAlgorithmAvailable(algo)) {
            this.defaultAlgo = algo;
        }
    }

    public SecretKey deriveSymmetricKeyFromEntropy(byte[] entropy, byte[] seed) throws TokenProcessingException {
        try {
            P_SHA1 psha1 = new P_SHA1();
            return new SecretKeySpec(psha1.createKey(entropy, seed, 0, (long)entropy.length), "HmacSHA1");
        }
        catch (ConversationException e) {
            throw new TokenProcessingException("Unable to create P_SHA1 hash of entropy and seed data:", (Throwable)e);
        }
    }

    public SecretKey newSymmetricKeyFromEntropy(String entropy, int keySize) throws TokenProcessingException {
        this.ensureSupportedKeySize(keySize);
        try {
            return XmlEncryption.getDataEncryptionKey(entropy, sizeToAlgo.get(keySize));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TokenProcessingException("Unable to use entropy as symmetric key. AES, size:" + keySize, (Throwable)e);
        }
    }

    public SecretKey newSymmetricKey(int keySize) throws TokenProcessingException {
        this.ensureSupportedKeySize(keySize);
        try {
            return XmlEncryption.generateDataEncryptionKey(sizeToAlgo.get(keySize));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TokenProcessingException("Unable to issue new symmetric key. AES, size:" + keySize, (Throwable)e);
        }
    }

    public boolean isSupportedSymmetricKeySize(int keySize) {
        return sizeToAlgo.containsKey(keySize);
    }

    private void ensureSupportedKeySize(int keySize) throws TokenProcessingException {
        if (!sizeToAlgo.containsKey(keySize)) {
            throw new TokenProcessingException("Unknown key size requested:" + keySize);
        }
    }

    public Key newKey(String algo) throws TokenProcessingException {
        Defense.notNull(algo, "Key algorithm is not set. Key generation impossible.");
        try {
            return XmlEncryption.generateDataEncryptionKey(algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TokenProcessingException("Unable to issue key: " + algo, (Throwable)e);
        }
    }

    public Key newDefaultKey() throws TokenProcessingException {
        Defense.notNull(this.defaultAlgo, "Default key algorithm is not set. Key generation impossible.");
        try {
            return XmlEncryption.generateDataEncryptionKey(this.defaultAlgo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TokenProcessingException("Unable to issue default key: " + this.defaultAlgo, (Throwable)e);
        }
    }

    public String getDefaultAlgorithm() {
        return this.defaultAlgo;
    }
}

