/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.crypto;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.RevocationChecker;
import com.pingidentity.crypto.RevokedCertException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.XmlEncryption;
import org.sourceid.common.dsig.XmlSignatureUtil;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EncryptionPolicy;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.xmlbinding.assertion.AssertionDocument;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedAssertionDocument;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.wstrust.crypto.IdBasedResolver;
import org.sourceid.wstrust.crypto.XmlSignatureException;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlCryptoProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private RevocationChecker checker = GlobalRegistry.getService(RevocationChecker.class);

    public RevocationChecker getChecker() {
        return this.checker;
    }

    public void setChecker(RevocationChecker checker) {
        this.checker = checker;
    }

    public boolean verify(XmlObject signature, Key key, IdBasedResolver resolver) throws XmlSignatureException {
        try {
            Element sigElement = XmlSignatureUtil.toDomElement(signature);
            XMLSignature sig = XmlSignatureVerifier.createXmlSignature(sigElement, false);
            sig.addResourceResolver((ResourceResolverSpi)resolver);
            boolean valid = sig.checkSignatureValue(key);
            if (sig.getObjectLength() > 0) {
                throw new XmlSignatureException("Signature contains disallowed xmldsig:Object children");
            }
            return valid;
        }
        catch (XMLSecurityException e) {
            throw new XmlSignatureException("Signature validation failed", e);
        }
    }

    public EncryptedAssertionDocument encryptAssertion(ConnectionBase connection, AssertionType assertion) throws XMLEncryptionException, NoEncryptionKeyException, NoSuchAlgorithmException {
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        EncryptionPolicy encryptionPolicy = encryptionSettings.getEncryptionPolicy();
        String encryptionAlg = encryptionPolicy.getEncryptionAlgorithm();
        String keyTransportAlg = encryptionPolicy.getKeyTransportAlgorithm();
        AssertionType canonicalized = this.canonicalize(assertion).getAssertion();
        X509Certificate encCert = this.obtainAndVerifyCert(connection);
        return this.encrypt(encryptionAlg, keyTransportAlg, canonicalized, encCert);
    }

    public SecurityToken decryptSaml11Assertion(XmlObject encryptedAssertion, PkCert pkCert) throws XMLEncryptionException {
        Element assertion = XmlEncryption.decryptToDomElement(encryptedAssertion, pkCert);
        Saml11SecurityToken saml11 = new Saml11SecurityToken();
        try {
            saml11.setAssertionDom(assertion);
            saml11.setAssertion(((org.sourceid.protocol.saml11.xml.AssertionDocument)XmlObject.Factory.parse((Node)assertion)).getAssertion());
        }
        catch (XmlException e) {
            throw new XMLEncryptionException("Error occured parsing decrypted data: ", (Exception)((Object)e));
        }
        return saml11;
    }

    public SecurityToken decryptSaml20Assertion(XmlObject encryptedAssertion, PkCert pkCert) throws XMLEncryptionException {
        Element assertion = XmlEncryption.decryptToDomElement(encryptedAssertion, pkCert);
        Saml20SecurityToken saml20 = new Saml20SecurityToken();
        try {
            saml20.setAssertionDom(assertion);
            saml20.setAssertion(((AssertionDocument)XmlObject.Factory.parse((Node)assertion)).getAssertion());
        }
        catch (XmlException e) {
            throw new XMLEncryptionException("Error occured parsing decrypted data: ", (Exception)((Object)e));
        }
        return saml20;
    }

    private EncryptedAssertionDocument encrypt(String encryptionAlg, String keyTransportAlg, AssertionType canonicalized, X509Certificate encCert) throws XMLEncryptionException, NoSuchAlgorithmException {
        EncryptedElementType encData = XmlEncryption.encryptWithKeyReference((XmlObject)canonicalized, encCert, encryptionAlg, keyTransportAlg);
        EncryptedAssertionDocument res = EncryptedAssertionDocument.Factory.newInstance();
        res.setEncryptedAssertion(encData);
        return res;
    }

    private X509Certificate obtainAndVerifyCert(ConnectionBase connection) throws NoEncryptionKeyException {
        Cert cert = connection.getEncryptionSettings().getEncryptionCert();
        if (cert == null) {
            throw new NoEncryptionKeyException("No encryption key is configured for " + connection.getEntityId());
        }
        try {
            this.checker.check(cert.getChain());
        }
        catch (RevokedCertException e) {
            String id = connection.getEncodedEntityId();
            String msg = "The certificate configured for encryption " + id + "  has been revoked";
            throw new NoEncryptionKeyException(msg, e);
        }
        return cert.getX509Certificate();
    }

    private AssertionDocument canonicalize(AssertionType assertion) throws XMLEncryptionException {
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        assertionDoc.setAssertion(assertion);
        if (assertion.isSetSignature()) {
            try {
                assertionDoc = XmlBeansUtil.canonicalize(assertionDoc, AssertionDocument.class);
            }
            catch (Exception e) {
                throw new XMLEncryptionException("Problem c14ning assertion prior to encryption", e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Assertion before encryption: " + assertionDoc));
        }
        return assertionDoc;
    }
}

