/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.generator.saml;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.protocol.AssertionTypeUtil;
import org.sourceid.saml20.xmlbinding.assertion.AssertionDocument;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.generator.saml.AbstractSamlGenerator;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.plugin.generate.TokenContext;

public class Saml20TokenGenerator
extends AbstractSamlGenerator {
    AssertionTypeUtil assertionTypeUtil = new AssertionTypeUtil();

    public Saml20TokenGenerator() {
        this.confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
    }

    @Override
    String getGeneratorName() {
        return String.format("SAML %s Token Generator", "2.0");
    }

    @Override
    String getTokenType() {
        return Saml20SecurityToken.TYPE;
    }

    public SecurityToken generateToken(TokenContext attributeContext) throws TokenProcessingException {
        AssertionType assertionType;
        AttributeMap attributes = new AttributeMap(attributeContext.getSubjectAttributes());
        AssertionAssembler assertionAssembler = new AssertionAssembler();
        if (this.confirmationMethod.equals("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key")) {
            Key secretKey = attributeContext.getSecretKey();
            attributeContext.setUseHolderOfKey(true);
            assertionType = assertionAssembler.assembleForWSTrust(attributes, this.assertionValidityBeforeMinutes, this.assertionValidityAfterMinutes, this.issuer, this.audience, null, this.confirmationMethod, this.encryptionCertificate, secretKey);
        } else {
            assertionType = assertionAssembler.assembleForWSTrust(attributes, this.assertionValidityBeforeMinutes, this.assertionValidityAfterMinutes, this.issuer, this.audience, null, this.confirmationMethod);
        }
        AssertionDocument assertionDoc = this.handleMessageCustomisation(assertionType, attributes, attributeContext.getInParameters());
        this.sign((XmlObject)assertionDoc);
        Saml20SecurityToken outToken = new Saml20SecurityToken();
        outToken.setAssertion(assertionDoc.getAssertion());
        return outToken;
    }

    private AssertionDocument handleMessageCustomisation(AssertionType assertionType, AttributeMap attributes, Map<String, Object> inParams) {
        AssertionType customisedMessage = this.handleMessageCustomisation(AssertionType.class, assertionType, attributes, inParams);
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        assertionDoc.setAssertion(customisedMessage);
        return assertionDoc;
    }

    @Override
    List<String> getConfirmationMethods() {
        ArrayList<String> confirmationMethods = new ArrayList<String>();
        confirmationMethods.add("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        confirmationMethods.add("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        confirmationMethods.add("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        return confirmationMethods;
    }

    @Override
    protected String getVersion() {
        return "1.1";
    }
}

