/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.generator.saml;

import com.pingidentity.access.KeyAccessor;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.crypto.SignatureAlgorithms;
import javax.security.auth.x500.X500PrivateCredential;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class SamlTokenGeneratorConfigurationValidator
implements ConfigurationValidator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(Configuration configuration) throws ValidationException {
        String messageCustomizationExpression;
        KeyAccessor keyAccessor;
        X500PrivateCredential signingCertificate;
        String confirmationMethod = configuration.getFieldValue("Confirmation Method");
        String encryptionCertificateAlias = configuration.getFieldValue("Encryption Certificate");
        if (("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key".equals(confirmationMethod) || "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(confirmationMethod)) && StringUtils.isEmpty((String)encryptionCertificateAlias)) {
            throw new ValidationException("An encryption certificate must be specified when using the holder-of-key confirmation method.");
        }
        String signingCertificateAlias = configuration.getFieldValue("Signing Certificate");
        boolean includeRawKeyInKeyValue = configuration.getBooleanFieldValue("Include Raw Key in KeyValue");
        if (signingCertificateAlias != null && (signingCertificate = (keyAccessor = new KeyAccessor()).getDsigKeypair(signingCertificateAlias)) != null) {
            String keyAlgorithm = signingCertificate.getCertificate().getPublicKey().getAlgorithm();
            SignatureAlgorithms signingAlgUtils = SignatureAlgorithms.getInstance();
            boolean isSignatureAlgSupported = signingAlgUtils.isSignatureAlgorithmSupported(keyAlgorithm);
            if (!isSignatureAlgSupported) throw new ValidationException(String.format("The current configuration does not support '%s' signing algorithm", keyAlgorithm));
            if ("EC".equals(keyAlgorithm) && includeRawKeyInKeyValue) {
                throw new ValidationException("Including the raw key in the <KeyValue> element is not supported for elliptic curve signing certificates.");
            }
            String signingAlgFieldValue = configuration.getFieldValue("Signing Algorithm");
            if (!StringUtils.isEmpty((String)signingAlgFieldValue) && !signingAlgFieldValue.trim().startsWith(keyAlgorithm)) {
                String errorMessage = this.getIncompatableErrorMessage(keyAlgorithm);
                if (!signingAlgFieldValue.equals("SHA1")) throw new ValidationException(errorMessage);
                if (!"DSA".equals(keyAlgorithm) && !"RSA".equals(keyAlgorithm)) {
                    throw new ValidationException(errorMessage);
                }
            }
        }
        if (StringUtils.isEmpty((String)(messageCustomizationExpression = configuration.getFieldValue("Message Customization Expression")))) return;
        if (!ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
            throw new ValidationException("Message Customisations is not supported because OGNL expressions are not enabled.");
        }
        try {
            Ognl.parseExpression((String)messageCustomizationExpression);
            return;
        }
        catch (OgnlException e) {
            throw new ValidationException("Invalid Message Customisation OGNL expression.");
        }
    }

    private String getIncompatableErrorMessage(String keyAlgorithm) {
        String errorMessage = null;
        String aOrAn = null;
        if ("DSA".equals(keyAlgorithm)) {
            aOrAn = "a";
        } else if ("EC".equals(keyAlgorithm) || "RSA".equals(keyAlgorithm)) {
            aOrAn = "an";
        }
        errorMessage = String.format("Select %s '%s' signing algorithm to match the key algorithm of signing certificate.", aOrAn, keyAlgorithm);
        return errorMessage;
    }
}

