/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import java.security.Key;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsSx.wsTrust.x200512.RequestSecurityTokenResponseCollectionDocument;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.handlers.JwtAssertionGrantTokenCreator;
import org.sourceid.wstrust.handlers.OAuthViaJwtAssertionGrantTokenCreator;
import org.sourceid.wstrust.handlers.OAuthViaSaml20BearerTokenCreator;
import org.sourceid.wstrust.handlers.OAuthViaSaml20TokenCreator;
import org.sourceid.wstrust.handlers.Saml11O365TokenCreator;
import org.sourceid.wstrust.handlers.Saml11TokenCreator;
import org.sourceid.wstrust.handlers.Saml20OAuthSAMLTokenCreator;
import org.sourceid.wstrust.handlers.Saml20ResponseTokenCreator;
import org.sourceid.wstrust.handlers.Saml20TokenCreator;
import org.sourceid.wstrust.handlers.TokenCreator;
import org.sourceid.wstrust.handlers.TokenPluginSupport;
import org.sourceid.wstrust.handlers.WSTrustBaseRequestHandler;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.handlers.WSTrustLicenseChecker;
import org.sourceid.wstrust.log.STSAuditLogger;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.model.KeyType;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.RequestSecurityTokenResponse;
import org.sourceid.wstrust.model.RequestedProofToken;
import org.sourceid.wstrust.model.Saml11O365SecurityToken;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.SecurityTokenReference;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;
import org.sourceid.wstrust.protocol.WSTrustProtocolManager;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.transport.HttpAuthnChallenge;
import org.sourceid.wstrust.validator.RequestContractValidator;
import org.w3c.dom.Node;
import org.xmlsoap.schemas.ws.x2005.x02.trust.RequestSecurityTokenResponseDocument;

public class IdpWSTrustRequestHandler
extends WSTrustBaseRequestHandler {
    private RequestContractValidator contractValidator = new RequestContractValidator();
    private TokenPluginSupport pluginSupport = new TokenPluginSupport();
    private final Map<String, TokenCreator> tokenCreators = new HashMap<String, TokenCreator>();
    private final Log log = LogFactory.getLog(this.getClass());

    public IdpWSTrustRequestHandler() {
        this.setTokenCreator(Saml20SecurityToken.TYPE, new Saml20TokenCreator());
        this.setTokenCreator(Saml11SecurityToken.TYPE, new Saml11TokenCreator());
        this.setTokenCreator(Saml11O365SecurityToken.TYPE, new Saml11O365TokenCreator());
        this.setTokenCreator("urn:ietf:params:oauth:grant-type:saml2-bearer", new Saml20OAuthSAMLTokenCreator());
        Saml20ResponseTokenCreator srtc = new Saml20ResponseTokenCreator();
        this.setTokenCreator(srtc.getType(), srtc);
        OAuthViaSaml20TokenCreator ovstc = new OAuthViaSaml20TokenCreator();
        this.setTokenCreator(ovstc.getType(), ovstc);
        OAuthViaSaml20BearerTokenCreator ovsbtc = new OAuthViaSaml20BearerTokenCreator();
        this.setTokenCreator(ovsbtc.getType(), ovsbtc);
        JwtAssertionGrantTokenCreator jagtc = new JwtAssertionGrantTokenCreator();
        this.setTokenCreator(jagtc.getType(), jagtc);
        OAuthViaJwtAssertionGrantTokenCreator ovjagtc = new OAuthViaJwtAssertionGrantTokenCreator();
        this.setTokenCreator(ovjagtc.getType(), ovjagtc);
    }

    void setTokenCreator(String type, TokenCreator creator) {
        this.tokenCreators.put(type, creator);
    }

    public RequestContractValidator getContractValidator() {
        return this.contractValidator;
    }

    public void setContractValidator(RequestContractValidator contractValidator) {
        this.contractValidator = contractValidator;
    }

    public void setPluginSupport(TokenPluginSupport pluginSupport) {
        this.pluginSupport = pluginSupport;
    }

    @Override
    String determinePartnerId(WsTrustInMessageContext wstInMsgCtx, RequestSecurityToken rst) {
        AppliesTo appliesTo = rst.getAppliesTo();
        if (appliesTo == null) {
            STSAuditLogger.setRole("IdP");
            throw new WSTrustException("Unable to determine partner SP connection. AppliesTo is absent.");
        }
        SpConnection spConnectionByAppliesTo = this.metadataDirectory.getSpConnectionByAppliesTo(appliesTo);
        if (spConnectionByAppliesTo == null) {
            STSAuditLogger.setRole("IdP");
            throw new WSTrustException("Unable to determine partner SP connection by AppliesTo: " + appliesTo);
        }
        return spConnectionByAppliesTo.getEntityId();
    }

    @Override
    void handleIssueRequest(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, WsTrustInMessageContext inCtx, WSTrustProtocolManager protocol, WsTrustOutMessageContext outCtx) {
        SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(inCtx.getEntityId());
        STSAuditLogger.setRole("IdP");
        STSAuditLogger.setConnectionId(sp.getEntityId());
        STSAuditLogger.setConnectionName(sp.getName());
        this.locateSubjectToken(inCtx);
        SecurityToken inToken = inCtx.getSubjectSecurityToken();
        TokenProcessorInstance processorInstance = null;
        String virtualServerId = VirtualIdentityUtil.resolve(sp, req).getVirtualEntityId(DomainMode.RUNTIME);
        STSAuditLogger.setVirtualServerId(virtualServerId);
        processorInstance = inCtx.getRequestTokenProcessorId() != null ? this.pluginSupport.getProcessorInstanceFromId(inCtx.getRequestTokenProcessorId()) : this.pluginSupport.getIdpProcessorInstanceFromType(inToken, sp, virtualServerId);
        STSAuditLogger.setSTSPluginId(processorInstance.getId());
        WsTrustFederatedWscSettings wsTrustSettings = sp.getWsTrustSettings();
        TokenPluginAttributeMapping mapping = wsTrustSettings.getTokenToAssertionMappingByProcessorId(processorInstance.getId());
        inCtx.setVirtualServerId(virtualServerId);
        if (mapping.isRestrictVirtualServerIds() && inCtx.getVirtualServerId() != null && !mapping.getRestrictedVirtualServerIds().contains(inCtx.getVirtualServerId())) {
            throw new WSTrustException("mapping " + mapping.getPluginId() + " is not allowed with mapping " + inCtx.getVirtualServerId());
        }
        AttributeMap srcAttributes = this.pluginSupport.processToken(processorInstance, inToken, inCtx);
        this.contractValidator.verify(wsTrustSettings, rst.getMetadata());
        if (rst.hasMetadata()) {
            AttributeMap requestAttributes = rst.getMetadata();
            srcAttributes.putAll((Map)requestAttributes);
        }
        WSTrustLicenseChecker.checkLicense(sp);
        this.processClaims(rst.getClaims(), wsTrustSettings.getAttributeContract(), wsTrustSettings.getTokenType(), true);
        AttributeMap contextAttributes = this.getContextAttributes(req);
        contextAttributes.put(SourceContextType.VIRTUAL_SERVER_ID.getId(), virtualServerId);
        HandlerUtil.addExtPropertiesToAttrMap(sp.getExtendedProperties(), contextAttributes);
        AttributeMap mappedAttrs = this.mapAttributes(srcAttributes, mapping, contextAttributes);
        AttributeValue tokenSubject = (AttributeValue)mappedAttrs.remove((Object)AssertionMapKeys.getGenericNameIdValueKey());
        if (tokenSubject != null) {
            mappedAttrs.put(AssertionMapKeys.getNameIdValueKey(), tokenSubject);
        }
        outCtx.setMaskedAttributeNames(mappedAttrs.getMaskedAttributeNames());
        outCtx.setVirtualServerId(inCtx.getVirtualServerId());
        STSAuditLogger.setUserName(mappedAttrs.getSingleValue("SAML_SUBJECT", true));
        STSAuditLogger.setAttributes(mappedAttrs);
        String tokenType = this.detectTokenType(outCtx, sp, wsTrustSettings);
        String algorithm = this.getKeyProvider().getDefaultAlgorithm();
        if (sp.getEncryptionSettings() != null && sp.getEncryptionSettings().getEncryptionPolicy() != null) {
            algorithm = sp.getEncryptionSettings().getEncryptionPolicy().getEncryptionAlgorithm();
        }
        boolean proofKeyNeeded = rst.getKeyType() == null ? wsTrustSettings.isUseSamlHoK() : rst.getKeyType() == KeyType.Symmetric;
        Key serverEntropy = this.createServerEntropy(rst, algorithm);
        WSTrustBaseRequestHandler.KeyTypeKeyPair secretKeyPair = this.createProofKey(rst, serverEntropy, algorithm, true, proofKeyNeeded);
        Key secretKey = secretKeyPair == null ? null : secretKeyPair.getKey();
        RequestedProofToken proofToken = this.createProofToken(rst, secretKeyPair, serverEntropy, proofKeyNeeded);
        SecurityToken outToken = this.createToken(tokenType, mappedAttrs, sp, outCtx, secretKey, req, resp);
        STSAuditLogger.auditOutTokenForRst(outToken);
        RequestSecurityTokenResponse rstr = protocol.transmit(outToken);
        rstr.setAppliesTo(rst.getAppliesTo());
        rstr.setAddressNamespace(rst.getAddressNamespace());
        if (proofToken != null) {
            rstr.setRequestedProofToken(proofToken);
        }
        if (outToken instanceof SamlSecurityToken) {
            SecurityTokenReference tokenReference = new SecurityTokenReference();
            tokenReference.setIdentifier(outToken.getId());
            if (outToken instanceof Saml11O365SecurityToken) {
                tokenType = "urn:oasis:names:tc:SAML:1.0:assertion";
                tokenReference.setTokenType("urn:oasis:names:tc:SAML:1.0:assertion");
            } else {
                tokenReference.setTokenType(outToken.getType());
            }
            tokenReference.setValueType(((SamlSecurityToken)outToken).getIdentifierTypeUri());
            rstr.setRequestedAttachedReference(tokenReference);
        }
        this.fillOutContext(inCtx, outCtx, rstr, tokenType);
        this.handleMessageCustomisation(req, resp, outCtx, sp, mappedAttrs, inCtx.getWsTrustVersion());
    }

    private void handleMessageCustomisation(HttpServletRequest req, HttpServletResponse resp, WsTrustOutMessageContext outCtx, SpConnection sp, AttributeMap mappedAttrs, WSTrustVersion version) {
        if (sp.hasWsTrustMessageCustomizationHook("authn-response")) {
            Map<String, Object> respCustomizeContext = MessageCustomization.getResponseCustomizeContext(mappedAttrs, null, true);
            Node responseNode = outCtx.getXmlObject().getDomNode();
            try {
                if (WSTrustVersion.v13 == version) {
                    RequestSecurityTokenResponseCollectionDocument responseCollectionDocument = RequestSecurityTokenResponseCollectionDocument.Factory.parse((Node)responseNode);
                    RequestSecurityTokenResponseCollectionDocument customisedResponseCollectionDocument = sp.customizeWsTrustResponse(RequestSecurityTokenResponseCollectionDocument.class, req, resp, responseCollectionDocument, version.getResponseType(), respCustomizeContext);
                    outCtx.setXmlObject((XmlObject)customisedResponseCollectionDocument);
                } else if (WSTrustVersion.v2005 == version) {
                    RequestSecurityTokenResponseDocument responseDocument = RequestSecurityTokenResponseDocument.Factory.parse((Node)responseNode);
                    RequestSecurityTokenResponseDocument customisedResponseDocument = sp.customizeWsTrustResponse(RequestSecurityTokenResponseDocument.class, req, resp, responseDocument, version.getResponseType(), respCustomizeContext);
                    outCtx.setXmlObject((XmlObject)customisedResponseDocument);
                }
            }
            catch (XmlException e) {
                throw new WSTrustException("Unable to parse request security token response document to evaluate the message customisation expression.");
            }
        }
    }

    @Override
    void handleValidateRequest(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, WsTrustInMessageContext inCtx, WSTrustProtocolManager protocol, WsTrustOutMessageContext outCtx) {
        STSAuditLogger.setRole("IdP");
        throw new WSTrustException("Validate request not supported in this context");
    }

    private String detectTokenType(WsTrustOutMessageContext outCtx, SpConnection sp, WsTrustFederatedWscSettings wsTrustSettings) {
        String tokenType;
        if (StringUtils.isNotEmpty((String)outCtx.getTokenType())) {
            tokenType = outCtx.getTokenType();
            this.log.debug((Object)("Overriding configured issue TokenType with TokenType from RST: " + tokenType));
        } else if (wsTrustSettings.getTokenType() != null) {
            tokenType = wsTrustSettings.getTokenType();
            this.log.debug((Object)("Using configured issue TokenType from wsTrustSettings: " + tokenType));
        } else {
            switch (sp.getProtocol()) {
                case SAML20: {
                    tokenType = Saml20SecurityToken.TYPE;
                    break;
                }
                case SAML11: {
                    tokenType = Saml11SecurityToken.TYPE;
                    break;
                }
                default: {
                    throw new WSTrustException("Unsupported protocol for token issuance");
                }
            }
            this.log.debug((Object)("Using protocol from web sso connection as issue TokenType: " + tokenType));
        }
        return tokenType;
    }

    protected SecurityToken createToken(String tokenType, AttributeMap attrs, SpConnection sp, WsTrustOutMessageContext outCtx, Key key, HttpServletRequest req, HttpServletResponse resp) {
        TokenCreator tokenCreator = this.tokenCreators.get(tokenType);
        if (tokenCreator == null) {
            throw new WSTrustException("Invalid request: issue token type not supported in this context: " + tokenType);
        }
        return tokenCreator.createToken(attrs, sp, outCtx, key, req, resp);
    }

    @Override
    protected LinkedHashSet<String> getSupportedChallengeTypes(WsTrustInMessageContext inCtx, WsTrustOutMessageContext outCtx) {
        SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(inCtx.getEntityId());
        STSAuditLogger.setConnectionId(sp.getEntityId());
        STSAuditLogger.setConnectionName(sp.getName());
        WsTrustFederatedWscSettings wsTrustSettings = sp.getWsTrustSettings();
        LinkedHashSet<String> supportedChallengeTypes = new LinkedHashSet<String>(4);
        for (String tokenProcessorId : wsTrustSettings.getIncomingTokenProcessors()) {
            TokenProcessorInstance currTokenProcessor = this.pluginSupport.getProcessorInstanceFromId(tokenProcessorId);
            HttpAuthnChallenge challenge = HttpAuthnChallenge.fromTokenType(currTokenProcessor.getTokenType());
            if (challenge == null) continue;
            supportedChallengeTypes.add(challenge.getChallengeType());
        }
        return supportedChallengeTypes;
    }
}

