/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.xml.XmlIDUtil;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.crypto.jws.JwsSignatureUtil;
import java.security.Key;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.handlers.TokenCreator;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;

public class JwtAssertionGrantTokenCreator
extends TokenCreator {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public SecurityToken createTokenForActive(AttributeMap attrs, Calendar authnInst, SpConnection sp, WsTrustOutMessageContext outCtx, Key proofToken, HttpServletRequest req, HttpServletResponse resp) {
        this.checkEnableOAuthAssertionProfiles(sp);
        String jwt = this.makeJwt(attrs, sp, outCtx);
        BinarySecurityToken token = new BinarySecurityToken(XmlIDUtil.createID(), this.getType());
        token.setEncodingType("http://tools.ietf.org/rfc/rfc4648.txt#base64url");
        token.setEncodedData(Base64URL.encodeToString((byte[])Util.utf8bytes(jwt)));
        return token;
    }

    @Override
    public SecurityToken createTokenForPassive(AttributeMap attrs, SpConnection sp, OutMessageContext outCtx) {
        throw new UnsupportedOperationException();
    }

    protected String makeJwt(AttributeMap attrs, SpConnection sp, WsTrustOutMessageContext outCtx) {
        JwtClaims claims = this.makeClaims(attrs, sp, outCtx);
        return this.makeJwtFromClaims(claims, sp);
    }

    protected String makeJwtFromClaims(JwtClaims claims, SpConnection sp) {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        PkCert signingPkCert = sp.getSigningPkCert();
        if (signingPkCert.getPublicKeyAlgorithm().equals("RSA") && signingPkCert.getPublicKeySize() < 2048) {
            throw new WSTrustException("An RSA key of size 2048 bits or larger must be used when signing JWT tokens (connection's signing key is only " + signingPkCert.getPublicKeySize() + " bits)");
        }
        if (signingPkCert.getPublicKeyAlgorithm().equals("DSA")) {
            throw new WSTrustException("DSA keys cannot be used to sign JWT tokens");
        }
        jws.setKey((Key)sp.getSigningKey());
        SignatureAlgorithms sigAlgos = SignatureAlgorithms.getInstance();
        String signingAlgorithm = sp.getSigningAlgorithm();
        if (!sigAlgos.getJwaAlgorithmIds().contains(signingAlgorithm) && (signingAlgorithm = sigAlgos.algUriToJwaAlgorithmId(signingAlgorithm)) == null && sp.getSigningAlgorithm() != null && sp.getSigningAlgorithm().equals(sigAlgos.algNameToUriForRuntime("SHA1withRSA"))) {
            signingAlgorithm = "RS256";
            this.log.warn((Object)"Configured signing algorithm RSA_SHA1 is not supported for JWT tokens - using RSA_SHA256 instead");
        }
        jws.setAlgorithmHeaderValue(signingAlgorithm);
        jws.setX509CertSha1ThumbprintHeaderValue(sp.getSigningKeyCertificate().getX509Certificate());
        JwsSignatureUtil.applyProviderOverrideContextIfNeeded(jws, sp.getSigningPkCert());
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new WSTrustException(e);
        }
    }

    protected JwtClaims makeClaims(AttributeMap attrs, SpConnection sp, WsTrustOutMessageContext outCtx) {
        JwtClaims claims = new JwtClaims();
        claims.setGeneratedJwtId();
        claims.setIssuedAtToNow();
        claims.setIssuer(outCtx.getVirtualServerId());
        claims.setAudience(outCtx.getInMessageContext().getRst().getAppliesTo().toString());
        WsTrustFederatedWscSettings settings = sp.getWsTrustSettings();
        claims.setExpirationTimeMinutesInTheFuture((float)settings.getAssertionValidityAfterMinutes());
        claims.setNotBeforeMinutesInThePast((float)settings.getAssertionValidityBeforeMinutes());
        attrs = new AttributeMap((Map)attrs);
        AttributeValue subjectAttr = (AttributeValue)attrs.remove((Object)AssertionMapKeys.getNameIdValueKey());
        if (subjectAttr != null) {
            claims.setStringClaim("sub", subjectAttr.getValue());
        }
        for (Map.Entry attrEntry : attrs.entrySet()) {
            String attrName = (String)attrEntry.getKey();
            AttributeValue attrValue = (AttributeValue)attrEntry.getValue();
            if (attrValue.isMultiValue()) {
                ArrayList valueList = new ArrayList(attrValue.getValuesAsCollection());
                claims.setStringListClaim(attrName, valueList);
                continue;
            }
            String valueStr = attrValue.getValue();
            if (valueStr == null) continue;
            claims.setStringClaim(attrName, valueStr);
        }
        return claims;
    }

    protected String getType() {
        return "urn:ietf:params:oauth:grant-type:jwt-bearer";
    }

    protected void checkEnableOAuthAssertionProfiles(SpConnection sp) {
        if (!sp.getWsTrustSettings().isEnableOAuthAssertionProfiles()) {
            throw new WSTrustException("Invalid request: issue token type not supported in this context: " + this.getType());
        }
    }
}

