/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import java.security.Key;
import java.util.Calendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml1x.profiles.ap.CreateResponse;
import org.sourceid.saml1x.protocol.AssertionAssembler;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.handlers.TokenCreator;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.Saml11O365SecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;

public class Saml11O365TokenCreator
extends TokenCreator {
    private final ConfigStore createResponseConfig = ConfigStoreFarm.getConfig(CreateResponse.class);
    private AssertionAssembler assembler = new AssertionAssembler();

    public void setAssembler(AssertionAssembler assembler) {
        this.assembler = assembler;
    }

    @Override
    public SecurityToken createTokenForActive(AttributeMap attrs, Calendar authnInst, SpConnection sp, WsTrustOutMessageContext outCtx, Key key, HttpServletRequest req, HttpServletResponse resp) {
        AssertionType assertion;
        String vEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)outCtx, sp).getVirtualEntityId(DomainMode.RUNTIME);
        String ns = this.createResponseConfig.getStringValue("ns", "ns:unspecified");
        if (key != null) {
            try {
                String keyTransportAlgo = sp.getEncryptionSettings().getEncryptionPolicy().getKeyTransportAlgorithm();
                assertion = this.assembler.assembleForWSTrust((Map<String, AttributeValue>)attrs, sp, ns, vEntityId, "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key", authnInst, key, keyTransportAlgo);
            }
            catch (XMLEncryptionException | XmlException e) {
                throw new WSTrustException("Unable to assemble SAML 1.1 with holder-of-key confirmation.", e);
            }
        } else {
            assertion = this.assembler.assembleForWSTrust((Map<String, AttributeValue>)attrs, sp, ns, vEntityId, "urn:oasis:names:tc:SAML:1.0:cm:bearer", authnInst);
        }
        assertion = this.handleMessageCustomisation(attrs, sp, assertion, req, resp);
        try {
            assertion = this.signatureEngine.signAssertion((OutMessageContext)outCtx, assertion);
        }
        catch (SigningException e) {
            throw new WSTrustException("Problem encountered during SAML1.x assertion signing", e);
        }
        Saml11O365SecurityToken outToken = new Saml11O365SecurityToken();
        outToken.setAssertion(assertion);
        return outToken;
    }

    private AssertionType handleMessageCustomisation(AttributeMap attrs, SpConnection sp, AssertionType assertion, HttpServletRequest req, HttpServletResponse resp) {
        Map<String, Object> respCustomizeContext;
        AssertionType customisedAssertion;
        if (sp.hasWsTrustMessageCustomizationHook("assertion") && (customisedAssertion = sp.wsTrustmessageCustomize("assertion", AssertionType.class, req, resp, assertion, "AssertionType", respCustomizeContext = MessageCustomization.getAssertionCustomisationContext((XmlObject)assertion, attrs, null))) != null) {
            assertion = customisedAssertion;
        }
        return assertion;
    }

    @Override
    public SecurityToken createTokenForPassive(AttributeMap attrs, SpConnection spConn, OutMessageContext outCtx) {
        throw new UnsupportedOperationException();
    }
}

