/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import java.security.Key;
import java.util.Calendar;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.assertion.AssertionDocument;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.Saml2Masker;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.handlers.TokenCreator;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.BinarySecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;

public class Saml20OAuthSAMLTokenCreator
extends TokenCreator {
    private final AssertionAssembler assembler = new AssertionAssembler();
    private final Saml2Masker masker = new Saml2Masker();
    private final Log log = LogFactory.getLog(this.getClass());

    String getEncodedAssertion(AttributeMap attrs, Calendar authnInst, SpConnection sp, WsTrustOutMessageContext ctx) {
        String virtualEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)ctx, sp).getVirtualEntityId(DomainMode.RUNTIME);
        WsTrustFederatedWscSettings settings = sp.getWsTrustSettings();
        int before = settings.getAssertionValidityBeforeMinutes();
        int after = settings.getAssertionValidityAfterMinutes();
        AssertionType assertion = null;
        assertion = this.assembler.assembleForWSTrust(attrs, before, after, virtualEntityId, sp.getEntityId(), authnInst, "urn:oasis:names:tc:SAML:2.0:cm:bearer");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Assertion: " + this.getMaskedAssertion(assertion, ctx.getMaskedAttributeNames())));
        }
        try {
            assertion = this.signatureEngine.signAssertion(assertion, sp);
        }
        catch (SigningException e) {
            throw new WSTrustException("Problem encountered during SAML2 assertion signing", e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Signed assertion: " + this.getMaskedAssertion(assertion, ctx.getMaskedAttributeNames())));
        }
        AssertionDocument assertionDocument = AssertionDocument.Factory.newInstance();
        assertionDocument.setAssertion(assertion);
        byte[] bytes = Util.utf8bytes(XmlBeansUtil.xmlText((XmlObject)assertionDocument));
        return Base64URL.encodeToString((byte[])bytes);
    }

    private XmlObject getMaskedAssertion(AssertionType assertion, Set<String> maskedAttrs) {
        AssertionType maskedDoc = assertion;
        if (maskedAttrs != null && !maskedAttrs.isEmpty()) {
            maskedDoc = this.masker.mask((XmlObject)assertion, maskedAttrs);
        }
        return maskedDoc;
    }

    @Override
    BinarySecurityToken createTokenForActive(AttributeMap attrs, Calendar authnInst, SpConnection sp, WsTrustOutMessageContext outCtx, Key proofToken, HttpServletRequest req, HttpServletResponse resp) {
        this.checkEnableOAuthSAMLBearer(sp);
        BinarySecurityToken token = new BinarySecurityToken(XmlIDUtil.createID(), this.getType());
        token.setEncodedData(this.getEncodedAssertion(attrs, authnInst, sp, outCtx));
        token.setEncodingType("http://tools.ietf.org/rfc/rfc4648.txt#base64url");
        return token;
    }

    void checkEnableOAuthSAMLBearer(SpConnection sp) {
        if (!sp.getWsTrustSettings().isEnableOAuthAssertionProfiles()) {
            throw new WSTrustException("Invalid request: issue token type not supported in this context: " + this.getType());
        }
    }

    String getType() {
        return "urn:ietf:params:oauth:grant-type:saml2-bearer";
    }

    @Override
    public SecurityToken createTokenForPassive(AttributeMap attrs, SpConnection spConn, OutMessageContext outCtx) {
        throw new UnsupportedOperationException();
    }
}

