/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedAssertionDocument;
import org.sourceid.util.Defense;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.crypto.XmlCryptoProcessor;
import org.sourceid.wstrust.handlers.TokenCreator;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.model.EncryptedSaml20SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;

public class Saml20TokenCreator
extends TokenCreator {
    private XmlCryptoProcessor cryptoProcessor = new XmlCryptoProcessor();
    private AssertionAssembler assembler = new AssertionAssembler();

    public void setCryptoProcessor(XmlCryptoProcessor cryptoProcessor) {
        this.cryptoProcessor = cryptoProcessor;
    }

    public void setAssembler(AssertionAssembler assembler) {
        this.assembler = assembler;
    }

    @Override
    public SecurityToken createTokenForActive(AttributeMap attrs, Calendar authnInst, SpConnection sp, WsTrustOutMessageContext outCtx, Key key, HttpServletRequest req, HttpServletResponse resp) {
        boolean encrypt = sp.getWsTrustSettings().isEncryptAssertion();
        WsTrustFederatedWscSettings settings = sp.getWsTrustSettings();
        int before = settings.getAssertionValidityBeforeMinutes();
        int after = settings.getAssertionValidityAfterMinutes();
        String virtualEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)outCtx, sp).getVirtualEntityId(DomainMode.RUNTIME);
        AssertionType assertion = null;
        if (settings.isUseSamlHoK()) {
            Defense.notNull(sp.getEncryptionSettings().getEncryptionCert(), "SP Encryption certificate is not defined.");
            X509Certificate spCert = sp.getEncryptionSettings().getEncryptionCert().getX509Certificate();
            String keyTransportAlgo = sp.getEncryptionSettings().getEncryptionPolicy().getKeyTransportAlgorithm();
            assertion = this.assembler.assembleForWSTrust(attrs, before, after, virtualEntityId, sp.getEntityId(), authnInst, "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key", spCert, key, keyTransportAlgo);
        } else {
            assertion = this.assembler.assembleForWSTrust(attrs, before, after, virtualEntityId, sp.getEntityId(), authnInst, "urn:oasis:names:tc:SAML:2.0:cm:bearer");
        }
        assertion = this.handleMessageCustomisation(attrs, sp, assertion, req, resp);
        try {
            assertion = this.signatureEngine.signAssertion((OutMessageContext)outCtx, assertion);
        }
        catch (SigningException e) {
            throw new WSTrustException("Problem encountered during SAML2 assertion signing", e);
        }
        if (encrypt) {
            try {
                EncryptedAssertionDocument encrypted = this.cryptoProcessor.encryptAssertion(sp, assertion);
                EncryptedSaml20SecurityToken outToken = new EncryptedSaml20SecurityToken();
                outToken.setAssertion(encrypted);
                outToken.setUnencrypted(assertion);
                return outToken;
            }
            catch (NoSuchAlgorithmException | XMLEncryptionException | NoEncryptionKeyException e) {
                throw new WSTrustException("Problem encountered during SAML2 assertion encryption", e);
            }
        }
        Saml20SecurityToken outToken = new Saml20SecurityToken();
        outToken.setAssertion(assertion);
        return outToken;
    }

    private AssertionType handleMessageCustomisation(AttributeMap attrs, SpConnection sp, AssertionType assertion, HttpServletRequest req, HttpServletResponse resp) {
        Map<String, Object> respCustomizeContext;
        AssertionType customisedAssertion;
        if (sp.hasWsTrustMessageCustomizationHook("assertion") && (customisedAssertion = sp.wsTrustmessageCustomize("assertion", AssertionType.class, req, resp, assertion, "AssertionType", respCustomizeContext = MessageCustomization.getAssertionCustomisationContext((XmlObject)assertion, attrs, null))) != null) {
            assertion = customisedAssertion;
        }
        return assertion;
    }

    @Override
    public SecurityToken createTokenForPassive(AttributeMap attrs, SpConnection sp, OutMessageContext outCtx) {
        throw new UnsupportedOperationException();
    }
}

