/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import java.security.Key;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.a2a.domain.Token2TokenMapping;
import org.sourceid.a2a.domain.mgmt.Token2TokenManager;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.handlers.TokenPluginSupport;
import org.sourceid.wstrust.handlers.WSTrustBaseRequestHandler;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.handlers.WSTrustLicenseChecker;
import org.sourceid.wstrust.log.STSAuditLogger;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.RequestSecurityTokenResponse;
import org.sourceid.wstrust.model.RequestedProofToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;
import org.sourceid.wstrust.plugin.generate.TokenContext;
import org.sourceid.wstrust.protocol.WSTrustProtocolManager;

public class StsWSTrustRequestHandler
extends WSTrustBaseRequestHandler {
    private static final String EXCEPTION_NO_TOKEN_MAPPING = "No token mapping found";
    private static final String EXCEPTION_ATTR_LOOKUP_FAILED = "Failed to lookup attribute";
    private static final String EXCEPTION_TOKEN_TYPE_NOT_SUPPORTED = "The requested token type is not supported";
    private final Log log = LogFactory.getLog(StsWSTrustRequestHandler.class);
    private TokenPluginSupport pluginSupport = new TokenPluginSupport();
    private Token2TokenManager token2TokenManager = MgmtFactory.getToken2TokenManager();

    @Override
    String determinePartnerId(WsTrustInMessageContext inMsgCtx, RequestSecurityToken rst) throws WSTrustException {
        return null;
    }

    @Override
    void handleIssueRequest(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, WsTrustInMessageContext inCtx, WSTrustProtocolManager protocol, WsTrustOutMessageContext outCtx) {
        AttributeMap s2tAttributeMapping;
        STSAuditLogger.setRole("STS");
        this.locateSubjectToken(inCtx);
        SecurityToken inToken = inCtx.getSubjectSecurityToken();
        TokenProcessorInstance processorInstance = this.getProcessorInstance(inCtx);
        TokenGeneratorInstance generatorInstance = this.getTokenGeneratorInstance(inCtx, outCtx);
        Token2TokenMapping s2tMapping = this.getSource2TargetMapping(processorInstance.getId(), generatorInstance.getId());
        WSTrustLicenseChecker.checkLicense(s2tMapping);
        STSAuditLogger.setSTSPluginId(processorInstance.getId() + " " + generatorInstance.getId());
        if (rst.getClaims() != null) {
            AttributeContract attributeContract = new AttributeContract();
            for (String attributeName : s2tMapping.getAttributeMapping().keySet()) {
                attributeContract.addMutableAttributeInfo(attributeName, null);
            }
            this.processClaims(rst.getClaims(), attributeContract, null, false);
        }
        String algorithm = this.getKeyProvider().getDefaultAlgorithm();
        Key serverEntropy = this.createServerEntropy(rst, algorithm);
        WSTrustBaseRequestHandler.KeyTypeKeyPair secretKey = this.createProofKey(rst, serverEntropy, algorithm, false, true);
        AttributeMap srcAttributes = this.pluginSupport.processToken(processorInstance, inToken, inCtx);
        try {
            s2tAttributeMapping = s2tMapping.executeMapping(srcAttributes, null, this.getContextAttributes(req));
        }
        catch (AuthorizationException e) {
            WSTrustException wsTrustException = new WSTrustException(e.getMessage(), e);
            wsTrustException.setFaultReason(e.getErrorDetail());
            throw wsTrustException;
        }
        catch (AttrLookupException e) {
            throw new WSTrustException(EXCEPTION_ATTR_LOOKUP_FAILED, e);
        }
        TokenContext generatorTokenContext = new TokenContext();
        generatorTokenContext.setSecretKey(secretKey.getKey());
        generatorTokenContext.setSubjectAttributes((Map)s2tAttributeMapping);
        STSAuditLogger.setAttributes(s2tAttributeMapping);
        outCtx.setMaskedAttributeNames(s2tAttributeMapping.getMaskedAttributeNames());
        SecurityToken outToken = this.pluginSupport.generateToken(generatorInstance, generatorTokenContext);
        STSAuditLogger.auditOutTokenForRst(outToken);
        RequestSecurityTokenResponse rstr = protocol.transmit(outToken);
        RequestedProofToken proofToken = this.createProofToken(rst, secretKey, serverEntropy, generatorTokenContext.isUseHolderOfKey());
        if (proofToken != null) {
            rstr.setRequestedProofToken(proofToken);
        }
        this.fillOutContext(inCtx, outCtx, rstr, outToken.getType());
    }

    @Override
    void handleValidateRequest(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, WsTrustInMessageContext inCtx, WSTrustProtocolManager protocol, WsTrustOutMessageContext outCtx) {
        STSAuditLogger.setRole("STS");
        String outTokenType = outCtx.getTokenType();
        if (outTokenType != null && !inCtx.getWsTrustVersion().getStatus().getUri().equals(outTokenType)) {
            throw new WSTrustException(EXCEPTION_TOKEN_TYPE_NOT_SUPPORTED);
        }
        this.locateSubjectToken(inCtx);
        SecurityToken inToken = inCtx.getSubjectSecurityToken();
        TokenProcessorInstance processorInstance = this.getProcessorInstance(inCtx);
        STSAuditLogger.setSTSPluginId(processorInstance.getId());
        boolean valid = true;
        try {
            AttributeMap attributeMap = this.pluginSupport.processToken(processorInstance, inToken, inCtx);
            STSAuditLogger.setAttributes(attributeMap);
        }
        catch (WSTrustException e) {
            this.log.info((Object)("Processed token is invalid. Failed with message: " + e.getMessage()));
            valid = false;
        }
        this.fillOutContext(inCtx, outCtx, protocol.transmit(valid), inToken.getType());
    }

    private Token2TokenMapping getSource2TargetMapping(String sourceId, String targetId) {
        Token2TokenMapping mapping = (Token2TokenMapping)this.token2TokenManager.getMapping(sourceId, targetId);
        if (mapping == null) {
            throw new WSTrustException(EXCEPTION_NO_TOKEN_MAPPING);
        }
        return mapping;
    }

    private TokenProcessorInstance getProcessorInstance(WsTrustInMessageContext inCtx) {
        TokenProcessorInstance tokenProcessorInstance = null;
        tokenProcessorInstance = inCtx.getRequestTokenProcessorId() != null ? this.pluginSupport.getProcessorInstanceFromId(inCtx.getRequestTokenProcessorId()) : this.pluginSupport.getT2TProcessorInstanceFromType(inCtx.getRst().getRequestType(), inCtx.getSubjectSecurityToken());
        return tokenProcessorInstance;
    }

    private TokenGeneratorInstance getTokenGeneratorInstance(WsTrustInMessageContext inCtx, WsTrustOutMessageContext outCtx) {
        TokenGeneratorInstance tokentGeneratorInstance = null;
        String outTokenType = outCtx.getTokenType();
        tokentGeneratorInstance = inCtx.getRequestTokenGeneratorId() != null ? this.pluginSupport.getGeneratorInstanceFromId(inCtx.getRequestTokenGeneratorId(), outTokenType) : this.pluginSupport.getT2TGeneratorInstanceFromType(outTokenType);
        return tokentGeneratorInstance;
    }
}

