/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import com.pingidentity.crypto.PkCert;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.auth.BasicAuthHelp;
import org.sourceid.auth.BasicAuthValue;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml1x.protocol.AssertionAssembler;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.Claim;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.RequestHandler;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.crypto.KeyProvider;
import org.sourceid.wstrust.crypto.XmlCryptoProcessor;
import org.sourceid.wstrust.handlers.NoAuthnTokenException;
import org.sourceid.wstrust.handlers.WSTrustException;
import org.sourceid.wstrust.log.STSAuditLogger;
import org.sourceid.wstrust.mgmt.WsTrustBasicAuthManager;
import org.sourceid.wstrust.mgmt.WsTrustClientCertAuthManager;
import org.sourceid.wstrust.model.BinarySecret;
import org.sourceid.wstrust.model.EncryptedSaml11SecurityToken;
import org.sourceid.wstrust.model.EncryptedSaml20SecurityToken;
import org.sourceid.wstrust.model.EncryptedSamlSecurityToken;
import org.sourceid.wstrust.model.KeyType;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.RequestSecurityTokenResponse;
import org.sourceid.wstrust.model.RequestType;
import org.sourceid.wstrust.model.RequestedProofToken;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.WsTrustInMessageContext;
import org.sourceid.wstrust.model.WsTrustOutMessageContext;
import org.sourceid.wstrust.model.mapper.WSTrustXmlMapper;
import org.sourceid.wstrust.plugin.TokenProcessingException;
import org.sourceid.wstrust.protocol.WSTrustProtocolManager;
import org.sourceid.wstrust.wsse.WsseProcessingException;
import org.sourceid.wstrust.wsse.WsseProcessor;

public abstract class WSTrustBaseRequestHandler
implements RequestHandler {
    private static final String EXCEPTION_UNDEFINED_REQ_TYPE = "Undefined request type";
    private static final String EXCEPTION_UNSUPPORTED_REQ_TYPE = "Unsupported request type";
    MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private XmlCryptoProcessor processor = new XmlCryptoProcessor();
    private KeyProvider keyProvider = new KeyProvider();
    protected org.sourceid.saml20.protocol.AssertionAssembler saml20Assembler = new org.sourceid.saml20.protocol.AssertionAssembler();
    protected AssertionAssembler saml1xAssembler = new AssertionAssembler();
    protected SignatureEngine signatureEngine = GlobalRegistry.getService(SignatureEngine.class);
    private final WsTrustBasicAuthManager authnManager = GlobalRegistry.getService(WsTrustBasicAuthManager.class);
    private String endpoint;

    abstract String determinePartnerId(WsTrustInMessageContext var1, RequestSecurityToken var2) throws WSTrustException;

    abstract void handleIssueRequest(HttpServletRequest var1, HttpServletResponse var2, RequestSecurityToken var3, WsTrustInMessageContext var4, WSTrustProtocolManager var5, WsTrustOutMessageContext var6);

    abstract void handleValidateRequest(HttpServletRequest var1, HttpServletResponse var2, RequestSecurityToken var3, WsTrustInMessageContext var4, WSTrustProtocolManager var5, WsTrustOutMessageContext var6);

    @Override
    public OutMessageContext process(InMessageContext msgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        WsTrustOutMessageContext outCtx = null;
        WsTrustInMessageContext inMsgCtx = (WsTrustInMessageContext)msgCtx;
        String msgId = null;
        String entityId = null;
        boolean shouldAuditLog = true;
        try {
            RequestSecurityToken rst = inMsgCtx.getRst();
            this.processEmbeddedTokens(rst);
            entityId = this.determinePartnerId(inMsgCtx, inMsgCtx.getRst());
            inMsgCtx.setEntityId(entityId);
            outCtx = new WsTrustOutMessageContext(inMsgCtx);
            outCtx.setRequestType(inMsgCtx.getRst().getRequestType());
            outCtx.setTokenType(inMsgCtx.getRst().getTokenType());
            SoapHeaders headers = new SoapHeaders();
            headers.setTo("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous");
            msgId = inMsgCtx.getSoapHeaders().getMessageId();
            if (msgId != null) {
                headers.setRelatesTo(msgId);
            }
            outCtx.setHeaders(headers);
            STSAuditLogger.setOutMsgCtx(outCtx);
            WSTrustProtocolManager protocol = GlobalRegistry.getService(inMsgCtx.getWsTrustVersion().getProtocolManagerServiceId(), WSTrustProtocolManager.class);
            if (inMsgCtx.getRst().getRequestType() == null) {
                throw new WSTrustException(EXCEPTION_UNDEFINED_REQ_TYPE);
            }
            switch (inMsgCtx.getRst().getRequestType()) {
                case ISSUE: {
                    headers.setAction(inMsgCtx.getWsTrustVersion().getIssueActionRstr().getUri());
                    this.handleIssueRequest(req, resp, inMsgCtx.getRst(), inMsgCtx, protocol, outCtx);
                    break;
                }
                case VALIDATE: {
                    headers.setAction(inMsgCtx.getWsTrustVersion().getValidateActionRstr().getUri());
                    this.handleValidateRequest(req, resp, inMsgCtx.getRst(), inMsgCtx, protocol, outCtx);
                    break;
                }
                default: {
                    throw new WSTrustException(EXCEPTION_UNSUPPORTED_REQ_TYPE);
                }
            }
            STSAuditLogger.setOutMsgCtx(outCtx);
            WsTrustOutMessageContext wsTrustOutMessageContext = outCtx;
            return wsTrustOutMessageContext;
        }
        catch (NoAuthnTokenException e) {
            LinkedHashSet<String> challengeTypes = this.getSupportedChallengeTypes(inMsgCtx, outCtx);
            if (challengeTypes != null && !challengeTypes.isEmpty()) {
                resp.setStatus(401);
                for (String challengeType : challengeTypes) {
                    resp.setHeader("WWW-Authenticate", challengeType);
                }
                resp.getOutputStream().flush();
                shouldAuditLog = false;
                Iterator iterator = null;
                return iterator;
            }
            this.handleException(e, outCtx);
            throw e;
        }
        catch (WSTrustException e) {
            WSTrustException wsTrustException = e;
            wsTrustException.setPartnerEntityId(entityId);
            this.handleException(e, outCtx);
            throw e;
        }
        catch (WsseProcessingException e) {
            WsseProcessingException wsseProcessingException = e;
            wsseProcessingException.setPartnerEntityId(entityId);
            this.handleException(e, outCtx);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleException(e, outCtx);
            throw e;
        }
        finally {
            if (shouldAuditLog) {
                STSAuditLogger.log();
            }
        }
    }

    private void processEmbeddedTokens(RequestSecurityToken rst) {
        try {
            if (rst.getValidateTarget() != null) {
                rst.setValidateTarget(this.decrypt(rst.getValidateTarget()));
            }
            if (rst.getOnBehalfOf() != null) {
                rst.setOnBehalfOf(this.decrypt(rst.getOnBehalfOf()));
            }
        }
        catch (XMLEncryptionException e) {
            throw new WSTrustException("Unable to decrypt incoming SAML assertion.", e);
        }
    }

    protected void processClaims(Map<String, Claim> expectedClaims, AttributeContract attributeContract, String outTokenType, boolean addNameFormatToSaml11Attrs) {
        if (expectedClaims != null) {
            HashSet<Object> availableClaims = new HashSet<Object>();
            if (attributeContract != null && attributeContract.getMutableAttributeNames() != null) {
                for (String string : attributeContract.getMutableAttributeNames()) {
                    if (addNameFormatToSaml11Attrs && Saml11SecurityToken.TYPE.equals(outTokenType)) {
                        String nameFormat = attributeContract.getMutableAttributeNameFormat(string);
                        if (nameFormat != null) {
                            try {
                                URI uri = new URI(nameFormat);
                                if (uri.isOpaque() && !nameFormat.endsWith(":")) {
                                    availableClaims.add(nameFormat + ":" + string);
                                    continue;
                                }
                                if (!uri.isOpaque() && !nameFormat.endsWith("/")) {
                                    availableClaims.add(nameFormat + "/" + string);
                                    continue;
                                }
                                availableClaims.add(nameFormat + string);
                            }
                            catch (URISyntaxException e) {
                                availableClaims.add(string);
                            }
                            continue;
                        }
                        availableClaims.add(string);
                        continue;
                    }
                    availableClaims.add(string);
                }
                for (Map.Entry entry : expectedClaims.entrySet()) {
                    if (((Claim)entry.getValue()).isOptional() || availableClaims.contains(((Claim)entry.getValue()).getUri())) continue;
                    throw new WSTrustException("Problem encountered during claim fulfillment.  Claim '" + ((Claim)entry.getValue()).getUri() + "' requested but not being offered via attribute contract.");
                }
            }
        }
    }

    protected SecurityToken decrypt(SecurityToken token) throws XMLEncryptionException {
        if (token instanceof EncryptedSaml20SecurityToken) {
            EncryptedSaml20SecurityToken encSaml = (EncryptedSaml20SecurityToken)token;
            return this.processor.decryptSaml20Assertion(encSaml.getEncryptedData(), this.findDecryptionKey(encSaml));
        }
        if (token instanceof EncryptedSaml11SecurityToken) {
            EncryptedSaml11SecurityToken encSaml = (EncryptedSaml11SecurityToken)token;
            return this.processor.decryptSaml11Assertion(encSaml.getEncryptedData(), this.findDecryptionKey(encSaml));
        }
        return token;
    }

    private PkCert findDecryptionKey(EncryptedSamlSecurityToken encSaml) {
        PkCert decryptionCert = null;
        if (encSaml.getCertificateThumbpint() != null) {
            decryptionCert = MgmtFactory.getDsigPkCertManager().findByThumbprint(encSaml.getCertificateThumbpint());
            if (decryptionCert == null) {
                throw new ConfigurationException("No key pair found for thumbprint: " + encSaml.getCertificateThumbpint());
            }
        } else if (encSaml.getCertificateSerial() != null && (decryptionCert = MgmtFactory.getDsigPkCertManager().findBySerialNumber(encSaml.getCertificateSerial())) == null) {
            throw new ConfigurationException("No key pair found for serial: " + encSaml.getCertificateSerial());
        }
        return decryptionCert;
    }

    protected LinkedHashSet<String> getSupportedChallengeTypes(WsTrustInMessageContext inCtx, WsTrustOutMessageContext outCtx) {
        return null;
    }

    private void handleException(RuntimeException e, WsTrustOutMessageContext outCtx) {
        STSAuditLogger.setStatus("failure");
        STSAuditLogger.setOutMsgCtx(outCtx);
        STSAuditLogger.setDescription(e.getMessage());
    }

    protected void locateSubjectToken(WsTrustInMessageContext inCtx) {
        SecurityToken inToken;
        this.ensureOneToken(inCtx);
        if (RequestType.ISSUE.equals((Object)inCtx.getRst().getRequestType())) {
            if (inCtx.getRst().getOnBehalfOf() != null) {
                inCtx.setSubjectSecurityToken(inCtx.getRst().getOnBehalfOf());
            } else if (inCtx.getRst().getActAs() != null) {
                inCtx.setSubjectSecurityToken(inCtx.getRst().getActAs());
            }
        } else if (RequestType.VALIDATE.equals((Object)inCtx.getRst().getRequestType()) && inCtx.getRst().getValidateTarget() != null) {
            inCtx.setSubjectSecurityToken(inCtx.getRst().getValidateTarget());
        }
        if (inCtx.getSubjectSecurityToken() == null) {
            inCtx.setSubjectSecurityToken(inCtx.getFirstToken());
        }
        if ((inToken = inCtx.getSubjectSecurityToken()) == null) {
            String msg = "Unable to locate security token in the request.";
            WSTrustException trustException = new WSTrustException(msg);
            trustException.setFaultCode(WSTrustException.FaultCode.BAD_REQUEST, inCtx.getWsTrustVersion());
            trustException.setFaultReason(msg);
            trustException.setRelatesTo(inCtx.getSoapHeaders().getMessageId());
            trustException.setWsaVersion(inCtx.getWsaVersion());
            throw trustException;
        }
        STSAuditLogger.auditInTokenForRst(inToken, inCtx.getRst());
    }

    private void ensureOneToken(WsTrustInMessageContext ctx) {
        int noOfTokens = ctx.countUniqueTokens();
        if (noOfTokens == 0) {
            throw new NoAuthnTokenException(ctx.getWsTrustVersion());
        }
        if (noOfTokens > 1 && ctx.getRoleType().equals((Object)Role.IDP)) {
            throw new WSTrustException("STS requests with more than one token are unsupported.");
        }
    }

    protected void fillOutContext(WsTrustInMessageContext inCtx, WsTrustOutMessageContext outCtx, RequestSecurityTokenResponse rstr, String tokenType) {
        outCtx.setEndpoint(this.getEndpoint());
        outCtx.setRstr(rstr);
        outCtx.setEntityId(inCtx.getEntityId());
        outCtx.setTokenType(tokenType);
        WsseProcessor wsseProcessor = new WsseProcessor();
        XmlObject xmlObject = WSTrustXmlMapper.map(rstr, inCtx.getWsTrustVersion(), inCtx.getActualWsTrustNamespace(), wsseProcessor);
        outCtx.setXmlObject(xmlObject);
    }

    protected AttributeMap mapAttributes(AttributeMap attributes, TokenPluginAttributeMapping mapping, AttributeMap contextAttributes) {
        try {
            return mapping.executeAttributeMapping(attributes, null, contextAttributes);
        }
        catch (AuthorizationException e) {
            WSTrustException wste = new WSTrustException(e.getMessage(), e);
            wste.setFaultReason(e.getErrorDetail());
            throw wste;
        }
        catch (AttrLookupException e) {
            throw new WSTrustException("Problem encountered during attribute mapping", e);
        }
    }

    protected Key createServerEntropy(RequestSecurityToken rst, String algorithm) {
        if (rst.getEntropy() != null && rst.getComputedKeyAlgorithm() != null) {
            try {
                return this.keyProvider.newKey(algorithm);
            }
            catch (TokenProcessingException e) {
                throw new WSTrustException("Error deriving key from entropy", e);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected KeyTypeKeyPair createProofKey(RequestSecurityToken rst, Key serverEntropy, String algorithm, boolean allowBearer, boolean proofKeyRequired) {
        secretKey = null;
        if (rst.getEntropy() == null) {
            try {
                if (rst.getKeyType() == null) ** GOTO lbl26
                keyType = rst.getKeyType();
                if (keyType == KeyType.Symmetric) {
                    if (!this.keyProvider.isSupportedSymmetricKeySize(rst.getKeySize())) ** GOTO lbl26
                    secretKey = new KeyTypeKeyPair(this.keyProvider.newSymmetricKey(rst.getKeySize()), keyType);
                }
                if ((keyType == KeyType.Bearer || keyType == KeyType.NoProof) && allowBearer) ** GOTO lbl26
                throw new WSTrustException("Unsupported key type requested:" + keyType);
            }
            catch (TokenProcessingException e) {
                throw new WSTrustException("Error during key generation", e);
            }
        } else {
            if (rst.getEntropy() != null && rst.getComputedKeyAlgorithm() != null) {
                try {
                    secretKey = new KeyTypeKeyPair(this.keyProvider.deriveSymmetricKeyFromEntropy(rst.getEntropy().getBinarySecret().getDecodedBytes(), serverEntropy.getEncoded()), KeyProvider.DefaultType);
                }
                catch (TokenProcessingException e) {
                    throw new WSTrustException("Error deriving key from entropy", e);
                }
            }
            if (rst.getEntropy() != null) {
                try {
                    secretKey = new KeyTypeKeyPair(this.keyProvider.newSymmetricKeyFromEntropy(rst.getEntropy().getBinarySecret().getValue(), rst.getKeySize()), KeyProvider.DefaultType);
                }
                catch (TokenProcessingException e) {
                    throw new WSTrustException("Error using entropy as key", e);
                }
            }
        }
lbl26:
        // 8 sources

        if (secretKey == null && proofKeyRequired) {
            try {
                secretKey = new KeyTypeKeyPair(this.keyProvider.newKey(algorithm), KeyProvider.DefaultType);
            }
            catch (TokenProcessingException e) {
                throw new WSTrustException("Error during key generation", e);
            }
        }
        return secretKey;
    }

    protected RequestedProofToken createProofToken(RequestSecurityToken rst, KeyTypeKeyPair proofKey, Key serverEntropy, boolean isProofTokenRequired) {
        RequestedProofToken proofToken = null;
        if (proofKey == null) {
            return null;
        }
        if (rst.getEntropy() == null) {
            KeyType keyType = rst.getKeyType();
            if (keyType != null && keyType != KeyType.Bearer && keyType != KeyType.NoProof) {
                proofToken = new RequestedProofToken();
                proofToken.setBinarySecret(new BinarySecret(proofKey.getKeyType(), proofKey.getKey()));
                proofToken.setEntropyMode(2);
            }
        } else if (rst.getEntropy() != null && rst.getComputedKeyAlgorithm() != null) {
            proofToken = new RequestedProofToken();
            proofToken.setComputedKey(new BinarySecret(KeyType.Nonce, serverEntropy));
            proofToken.getComputedKey().setAlgorithmUri(rst.getComputedKeyAlgorithm());
            proofToken.setEntropyMode(1);
        } else if (rst.getEntropy() != null) {
            isProofTokenRequired = false;
        }
        if (proofToken == null && isProofTokenRequired) {
            proofToken = new RequestedProofToken();
            proofToken.setBinarySecret(new BinarySecret(proofKey.getKeyType(), proofKey.getKey()));
            proofToken.setEntropyMode(2);
        }
        return proofToken;
    }

    public SignatureEngine getSignatureEngine() {
        return this.signatureEngine;
    }

    public void setSignatureEngine(SignatureEngine signatureEngine) {
        this.signatureEngine = signatureEngine;
    }

    public XmlCryptoProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(XmlCryptoProcessor processor) {
        this.processor = processor;
    }

    String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public KeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    public void setKeyProvider(KeyProvider keyProvider) {
        this.keyProvider = keyProvider;
    }

    protected AttributeMap getContextAttributes(HttpServletRequest req) {
        X509Certificate[] clientCerts;
        String authnHeaderValue;
        AttributeMap contextAttributes = new AttributeMap();
        contextAttributes.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
        contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
        if (this.authnManager.isAuthenticationEnabled() && (authnHeaderValue = BasicAuthHelp.getAuthTokenFromHeaders(req)) != null) {
            try {
                BasicAuthValue values = BasicAuthHelp.getValues(authnHeaderValue);
                if (values.getUsername() != null) {
                    contextAttributes.put(SourceContextType.STS_BASIC_AUTH_USERNAME.getId(), values.getUsername());
                }
            }
            catch (LoginException values) {
                // empty catch block
            }
        }
        if ((clientCerts = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate")) != null && clientCerts.length > 0) {
            WsTrustClientCertAuthManager authnManager;
            X509Certificate[] certChain;
            String subjectDN = clientCerts[0].getSubjectX500Principal().getName();
            if (!subjectDN.isEmpty()) {
                contextAttributes.put(SourceContextType.STS_SSL_CLIENT_CERT_SUBJECT_DN.getId(), subjectDN);
            }
            if ((certChain = (authnManager = GlobalRegistry.getService(WsTrustClientCertAuthManager.class)).getExtendedCertificateChain(clientCerts)) == null) {
                certChain = clientCerts;
            }
            ArrayList<X509Certificate[]> certChainValue = new ArrayList<X509Certificate[]>(1);
            certChainValue.add(certChain);
            AttributeValue certChainAttr = new AttributeValue(Arrays.asList(subjectDN), certChainValue);
            contextAttributes.put(SourceContextType.STS_SSL_CLIENT_CERT_CHAIN.getId(), certChainAttr);
        }
        return contextAttributes;
    }

    protected void setSaml20Assembler(org.sourceid.saml20.protocol.AssertionAssembler saml20Assembler) {
        this.saml20Assembler = saml20Assembler;
    }

    protected static class KeyTypeKeyPair {
        private final Key key;
        private final KeyType keyType;

        public KeyTypeKeyPair(Key key, KeyType keyType) {
            this.key = key;
            this.keyType = keyType;
        }

        public Key getKey() {
            return this.key;
        }

        public KeyType getKeyType() {
            return this.keyType;
        }
    }
}

