/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.handlers;

import javax.xml.namespace.QName;
import org.sourceid.common.soap.SoapFaultAware;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.protocol.addressing.WsaVersion;

public class WSTrustException
extends RuntimeException
implements SoapFaultAware {
    private static final long serialVersionUID = 1L;
    private QName faultCode;
    private String faultReason;
    private String relatesTo;
    private WsaVersion wsaVersion;
    private String partnerEntityId;

    public WSTrustException() {
    }

    public WSTrustException(String s) {
        super(s);
    }

    public WSTrustException(String s, Throwable throwable) {
        super(s, throwable);
    }

    public WSTrustException(Throwable throwable) {
        super(throwable);
    }

    public void setFaultCode(FaultCode faultCode, WSTrustVersion version) {
        this.faultCode = new QName(version.getDocumentNamespace().getUri(), faultCode.getFaultCodeValue());
    }

    @Override
    public QName getFaultCode() {
        return this.faultCode;
    }

    public void setFaultReason(String faultReason) {
        this.faultReason = faultReason;
    }

    @Override
    public String getFaultReason() {
        return this.faultReason;
    }

    @Override
    public String getRelatesTo() {
        return this.relatesTo;
    }

    public void setRelatesTo(String relatesTo) {
        this.relatesTo = relatesTo;
    }

    @Override
    public WsaVersion getWsaVersion() {
        return this.wsaVersion;
    }

    public void setWsaVersion(WsaVersion wsaVersion) {
        this.wsaVersion = wsaVersion;
    }

    public String getPartnerEntityId() {
        return this.partnerEntityId;
    }

    public void setPartnerEntityId(String partnerEntityId) {
        this.partnerEntityId = partnerEntityId;
    }

    public void setFaultCode(QName faultCode) {
        this.faultCode = faultCode;
    }

    public static enum FaultCode {
        BAD_REQUEST("BadRequest"),
        INVALID_SECURITY_TOKEN("InvalidSecurityToken"),
        FAILED_AUTHENTICATION("FailedAuthentication");

        private final String faultCode;

        private FaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        public String getFaultCodeValue() {
            return this.faultCode;
        }
    }
}

