/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.mgmt;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.ConfigEventType;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.kerberos.KerberosRealmFieldDescriptor;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConfigurationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementFactory;
import org.sourceid.saml20.domain.mgmt.impl.TokenProcessorMgmtConfigSupport;
import org.sourceid.wstrust.mgmt.BaseTokenPluginManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.plugin.process.TokenProcessor;

public class TokenProcessorManagerImpl
extends BaseTokenPluginManager<TokenProcessorInstance>
implements TokenProcessorManager,
AutoReloadable {
    public TokenProcessorManagerImpl() {
        PluginManagementFactory pluginManagementFactory = new PluginManagementFactory();
        this.pluginMgmtSupport = pluginManagementFactory.makeTokenProcessorMgmtSupport();
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.pluginMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public TokenProcessor<SecurityToken> getTokenProcessor(String instanceId) {
        return (TokenProcessor)this.pluginMgmtSupport.getPlugin(instanceId);
    }

    @Override
    public void importTokenProcessorConfiguration(String instanceId, String className, String xml, String parentId, boolean allowUpdate) throws XmlException, ConfigurationException {
        if (this.getTokenProcessor(instanceId) != null && !allowUpdate) {
            throw new ConfigurationException("The token processor instance with id=" + instanceId + " already exists. [allowUpdate=false]");
        }
        TokenProcessorMgmtConfigSupport tokeProcessorMgmtConfigSupport = new TokenProcessorMgmtConfigSupport();
        TokenPluginInstance pluginInstance = tokeProcessorMgmtConfigSupport.parseXml(xml, className);
        pluginInstance.setId(instanceId);
        pluginInstance.setParentId(parentId);
        this.saveInstance(pluginInstance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        return MgmtFactory.getToken2TokenManager().isSourceInUse(pluginId) || MgmtFactory.getTokenExchangeProcessorPolicyManager().isTokenProcessorInUse(pluginId) || this.getSpConnectionsUsingId(pluginId).size() > 0;
    }

    @Override
    public List<SpConnection> getSpConnectionsUsingId(String pluginId) {
        Collection<SpConnection> spConnections = MgmtFactory.getConnectionManager().getFilteredSpConnections();
        ArrayList<SpConnection> spConns = new ArrayList<SpConnection>();
        for (SpConnection sp : spConnections) {
            if (!sp.doesWsTrustSettingsExist()) continue;
            Set<String> connectionProcessorIds = sp.getWsTrustSettings().getIncomingTokenProcessors();
            for (String connectionProcessorId : connectionProcessorIds) {
                if (!connectionProcessorId.equals(pluginId)) continue;
                spConns.add(sp);
            }
        }
        return spConns;
    }

    @Override
    public TokenProcessorInstance newInstance() {
        return new TokenProcessorInstance();
    }

    @Override
    public boolean isKerberosRealmInUse(String kerberosRealmName) {
        for (ConfigurablePluginInstance instance : this.getInstances()) {
            GuiConfigDescriptor guiConfigDescriptor = instance.getDescriptor().getGuiConfigDescriptor();
            ArrayList tokenProcessorGuiFields = new ArrayList();
            tokenProcessorGuiFields.addAll(guiConfigDescriptor.getFields());
            tokenProcessorGuiFields.addAll(guiConfigDescriptor.getAdvancedFields());
            ArrayList<FieldDescriptor> adapterKerberosRealms = new ArrayList<FieldDescriptor>();
            for (FieldDescriptor field : tokenProcessorGuiFields) {
                if (!(field instanceof KerberosRealmFieldDescriptor)) continue;
                adapterKerberosRealms.add(field);
            }
            ArrayList configurationList = new ArrayList();
            configurationList.addAll(instance.getConfiguration().getFields());
            configurationList.addAll(instance.getConfiguration().getAdvancedFields().getFields());
            for (FieldDescriptor kerberosRealmGuiField : adapterKerberosRealms) {
                for (Field field : configurationList) {
                    String kerberosRealmGuiFieldName = kerberosRealmGuiField.getName();
                    String configurationFieldName = field.getName();
                    String configurationFieldValue = field.getValue();
                    if (kerberosRealmGuiFieldName == null || !kerberosRealmGuiFieldName.equals(configurationFieldName) || configurationFieldValue == null || !configurationFieldValue.equals(kerberosRealmName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public TokenProcessorInstance getDefaultInstance() {
        return null;
    }

    @Override
    public void reloadConnBasedPluginOverrides(ConnectionBase conn) {
        if (conn instanceof SpConnection) {
            this.pluginMgmtSupport.reloadConnBasedInstances(conn);
        }
    }

    @Override
    public void removeConnBasedPluginOverrides(ConnectionBase conn) {
        if (conn instanceof SpConnection) {
            this.pluginMgmtSupport.removeConnBasedInstances(conn);
        }
    }

    @Override
    protected ConfigEventType getConfigEventType() {
        return ConfigEventType.TOKEN_PROCESSORS_RELOADED;
    }
}

