/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.Claim;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.wstrust.model.Entropy;
import org.sourceid.wstrust.model.KeyType;
import org.sourceid.wstrust.model.RequestType;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.protocol.WSTrustVersion;

public class RequestSecurityToken {
    private WSTrustVersion version;
    private RequestType requestType;
    private AppliesTo appliesTo;
    private SecurityToken onBehalfOf;
    private SecurityToken validateTarget;
    private SecurityToken actAs;
    private String computedKeyAlgorithm;
    private KeyType keyType;
    private int keySize;
    private AttributeMap metadata;
    private Entropy entropy;
    private Map<String, Claim> claims = new HashMap<String, Claim>();
    private String addressNamespace;
    private XmlObject message;
    private String tokenType;

    public String getAddressNamespace() {
        return this.addressNamespace;
    }

    public void setAddressNamespace(String addressNamespace) {
        this.addressNamespace = addressNamespace;
    }

    public boolean hasMetadata() {
        return this.metadata != null && this.metadata.size() > 0;
    }

    public void setMetadata(AttributeMap metadata) {
        this.metadata = metadata;
    }

    public AttributeMap getMetadata() {
        return this.metadata;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyType keyType) {
        this.keyType = keyType;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public SecurityToken getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public void setOnBehalfOf(SecurityToken onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public SecurityToken getValidateTarget() {
        return this.validateTarget;
    }

    public void setValidateTarget(SecurityToken validateTarget) {
        this.validateTarget = validateTarget;
    }

    public SecurityToken getActAs() {
        return this.actAs;
    }

    public void setActAs(SecurityToken actAs) {
        this.actAs = actAs;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public WSTrustVersion getVersion() {
        return this.version;
    }

    public void setVersion(WSTrustVersion version) {
        this.version = version;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(AppliesTo appliesTo) {
        this.appliesTo = appliesTo;
    }

    public void setXmlObject(XmlObject message) {
        this.message = message;
    }

    public XmlObject getXmlObject() {
        return this.message;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void addClaim(Claim claim) {
        this.claims.put(claim.getUri(), claim);
    }

    public Map<String, Claim> getClaims() {
        return this.claims;
    }

    public void setClaims(Map<String, Claim> claims) {
        this.claims = claims;
    }

    public Entropy getEntropy() {
        return this.entropy;
    }

    public void setEntropy(Entropy entropy) {
        this.entropy = entropy;
    }

    public String getComputedKeyAlgorithm() {
        return this.computedKeyAlgorithm;
    }

    public void setComputedKeyAlgorithm(String computedKeyAlgorithm) {
        this.computedKeyAlgorithm = computedKeyAlgorithm;
    }

    public String toString() {
        return "RequestSecurityToken{version=" + this.version + ", requestType=" + this.requestType + ", appliesTo=" + this.appliesTo + ", onBehalfOf=" + this.onBehalfOf + ", validateTarget=" + this.validateTarget + ", keyType=" + this.keyType + ", keySize=" + this.keySize + ", message=" + this.message + ", tokenType='" + this.tokenType + "'}";
    }
}

