/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.wstrust.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.util.log.internal.Masker;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.wstrust.crypto.IdBasedResolver;
import org.sourceid.wstrust.handlers.TokenPluginSupport;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.model.RequestSecurityToken;
import org.sourceid.wstrust.model.SamlSecurityToken;
import org.sourceid.wstrust.model.SecurityToken;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.TokenMaskerFactory;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.sourceid.wstrust.protocol.addressing.WsaVersion;

public class WsTrustInMessageContext
extends InMessageContext {
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    private SoapHeaders soapHeaders = new SoapHeaders();
    private final Set<SecurityToken> httpTokens = new HashSet<SecurityToken>(4);
    private final TokenPluginSupport pluginSupport = new TokenPluginSupport();
    private SecurityToken subjectSecurityToken;
    private WSTrustVersion wsTrustVersion;
    private XmlObject rstXmlObject;
    private WsaVersion wsaVersion;
    private String actualWsTrustNamespace;
    private IdBasedResolver resolver;
    private RequestSecurityToken rst;
    private String requestTokenProcessorId;
    private String requestTokenGeneratorId;
    private String requestIpAddress;
    private final Log log = LogFactory.getLog(this.getClass());

    public WsTrustInMessageContext() {
    }

    public WsTrustInMessageContext(Role role) {
        super(role);
    }

    public String getRequestTokenProcessorId() {
        return this.requestTokenProcessorId;
    }

    public void setRequestTokenProcessorId(String requestTokenProcessorId) {
        this.requestTokenProcessorId = requestTokenProcessorId;
    }

    public String getRequestTokenGeneratorId() {
        return this.requestTokenGeneratorId;
    }

    public void setRequestTokenGeneratorId(String requestTokenGeneratorId) {
        this.requestTokenGeneratorId = requestTokenGeneratorId;
    }

    public WsaVersion getWsaVersion() {
        return this.wsaVersion;
    }

    public void setWsaVersion(WsaVersion wsaVersion) {
        this.wsaVersion = wsaVersion;
    }

    public IdBasedResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(IdBasedResolver resolver) {
        this.resolver = resolver;
    }

    public XmlObject getRstXmlObject() {
        return this.rstXmlObject;
    }

    public void setRstXmlObject(XmlObject rstXmlObject) {
        this.rstXmlObject = rstXmlObject;
    }

    public SoapHeaders getSoapHeaders() {
        return this.soapHeaders;
    }

    public void setSoapHeaders(SoapHeaders soapHeaders) {
        this.soapHeaders = soapHeaders;
    }

    public SecurityToken getTokenById(String requestedTokenId) {
        SecurityToken securityToken = null;
        if (requestedTokenId != null) {
            Iterator<SecurityToken> tokenIterator = this.iterateAllTokens();
            while (tokenIterator.hasNext()) {
                SecurityToken token = tokenIterator.next();
                if (!requestedTokenId.equals(token.getId())) continue;
                securityToken = token;
                break;
            }
        }
        return securityToken;
    }

    public void addHttpHeaderSecurityToken(SecurityToken token) {
        this.httpTokens.add(token);
    }

    public void addSoapHeaderSecurityToken(SecurityToken token) {
        this.soapHeaders.addSecurityToken(token);
    }

    public boolean containsToken(String requestedTokenId) {
        return this.getTokenById(requestedTokenId) != null;
    }

    public int countUniqueTokens() {
        int noOfTokens = 0;
        SecurityToken validateTarget = null;
        SecurityToken onBehalfOf = null;
        SecurityToken actAs = null;
        if (this.rst != null) {
            validateTarget = this.rst.getValidateTarget();
            if (validateTarget != null) {
                ++noOfTokens;
            }
            if ((onBehalfOf = this.rst.getOnBehalfOf()) != null) {
                ++noOfTokens;
            }
            if ((actAs = this.rst.getActAs()) != null) {
                ++noOfTokens;
            }
        }
        noOfTokens += this.soapHeaders.getNoOfSecurityTokens();
        if (validateTarget != null && validateTarget.getId() != null && this.soapHeaders.getTokenById(validateTarget.getId()) != null) {
            --noOfTokens;
        }
        if (onBehalfOf != null && onBehalfOf.getId() != null && this.soapHeaders.getTokenById(onBehalfOf.getId()) != null) {
            --noOfTokens;
        }
        if (actAs != null && actAs.getId() != null && this.soapHeaders.getTokenById(actAs.getId()) != null) {
            --noOfTokens;
        }
        return noOfTokens += this.httpTokens.size();
    }

    public SecurityToken getFirstToken() {
        Iterator<SecurityToken> tokenIterator = this.iterateAllTokens();
        if (tokenIterator.hasNext()) {
            return tokenIterator.next();
        }
        return null;
    }

    public Iterator<SecurityToken> iterateAllTokens() {
        return new TokenIterator();
    }

    public SecurityToken getSubjectSecurityToken() {
        return this.subjectSecurityToken;
    }

    public void setSubjectSecurityToken(SecurityToken subjectSecurityToken) {
        this.subjectSecurityToken = subjectSecurityToken;
    }

    public WSTrustVersion getWsTrustVersion() {
        return this.wsTrustVersion;
    }

    public void setWsTrustVersion(WSTrustVersion wsTrustVersion) {
        this.wsTrustVersion = wsTrustVersion;
    }

    public void setActualWsTrustNamespace(String actualWsTrustNamespace) {
        this.actualWsTrustNamespace = actualWsTrustNamespace;
    }

    public String getActualWsTrustNamespace() {
        return this.actualWsTrustNamespace;
    }

    public RequestSecurityToken getRst() {
        return this.rst;
    }

    public void setRst(RequestSecurityToken rst) {
        this.rst = rst;
    }

    public boolean hasTokenOfType(String type) {
        Iterator<SecurityToken> tokenIterator = this.iterateAllTokens();
        while (tokenIterator.hasNext()) {
            SecurityToken token = tokenIterator.next();
            if (!token.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected XmlObject mask() {
        XmlObject xmlObj = this.getXmlObject();
        if (xmlObj == null) {
            return null;
        }
        Iterator<SecurityToken> tokenIterator = this.iterateAllTokens();
        block6: while (tokenIterator.hasNext()) {
            SecurityToken token = tokenIterator.next();
            Masker masker = TokenMaskerFactory.getTokenMasker(token.getType());
            if (masker == null) continue;
            TokenProcessorInstance processorInstance = null;
            switch (this.getRoleType()) {
                case IDP: {
                    SamlSecurityToken samlToken = null;
                    if (token instanceof SamlSecurityToken) {
                        samlToken = (SamlSecurityToken)token;
                        this.setEntityId(samlToken.getIssuer());
                        try {
                            xmlObj = MASKING_XML_OBJ_FACTORY.getMasked(this);
                        }
                        catch (ConfigurationException ex) {
                            this.log.warn((Object)("No masking will be applied to request body because no connection information can be found for entity ID: " + this.getEntityId()));
                        }
                        continue block6;
                    }
                    xmlObj = masker.mask(xmlObj, null);
                    continue block6;
                }
                case SP: {
                    if (this.getRequestTokenProcessorId() != null) {
                        processorInstance = this.pluginSupport.getProcessorInstanceFromId(this.getRequestTokenProcessorId());
                    } else if (this.rst.getAppliesTo() != null) {
                        SpConnection sp = this.metadataDirectory.getSpConnectionByAppliesTo(this.rst.getAppliesTo());
                        processorInstance = this.pluginSupport.getIdpProcessorInstanceFromType(token, sp, this.getVirtualServerId());
                    } else {
                        return null;
                    }
                    xmlObj = masker.mask(xmlObj, processorInstance.getMaskedFields());
                    continue block6;
                }
            }
            processorInstance = this.getRequestTokenProcessorId() != null ? this.pluginSupport.getProcessorInstanceFromId(this.getRequestTokenProcessorId()) : this.pluginSupport.getT2TProcessorInstanceFromType(this.rst.getRequestType(), token);
            xmlObj = masker.mask(xmlObj, processorInstance.getMaskedFields());
        }
        return xmlObj;
    }

    public String getRequestIpAddress() {
        return this.requestIpAddress;
    }

    public void setRequestIpAddress(String requestIpAddress) {
        this.requestIpAddress = requestIpAddress;
    }

    public class TokenIterator
    implements Iterator<SecurityToken> {
        private boolean checkedOnBehalfOf;
        private boolean checkedActAs;
        private boolean checkedValidateTarget;
        private Iterator<SecurityToken> soapHeaderIterator;
        private Iterator<SecurityToken> httpHeaderIterator;
        private SecurityToken nextToken = this.getNext();

        TokenIterator() {
        }

        private SecurityToken getNext() {
            if (WsTrustInMessageContext.this.rst != null) {
                if (!this.checkedOnBehalfOf) {
                    this.checkedOnBehalfOf = true;
                    if (WsTrustInMessageContext.this.rst.getOnBehalfOf() != null) {
                        return WsTrustInMessageContext.this.rst.getOnBehalfOf();
                    }
                }
                if (!this.checkedActAs) {
                    this.checkedActAs = true;
                    if (WsTrustInMessageContext.this.rst.getActAs() != null) {
                        return WsTrustInMessageContext.this.rst.getActAs();
                    }
                }
                if (!this.checkedValidateTarget) {
                    this.checkedValidateTarget = true;
                    if (WsTrustInMessageContext.this.rst.getValidateTarget() != null) {
                        return WsTrustInMessageContext.this.rst.getValidateTarget();
                    }
                }
            }
            if (this.soapHeaderIterator == null) {
                this.soapHeaderIterator = WsTrustInMessageContext.this.soapHeaders.getAllTokens().iterator();
            }
            if (this.soapHeaderIterator.hasNext()) {
                return this.soapHeaderIterator.next();
            }
            if (this.httpHeaderIterator == null) {
                this.httpHeaderIterator = WsTrustInMessageContext.this.httpTokens.iterator();
            }
            if (this.httpHeaderIterator.hasNext()) {
                return this.httpHeaderIterator.next();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.nextToken != null;
        }

        @Override
        public SecurityToken next() {
            if (this.nextToken == null) {
                throw new NoSuchElementException();
            }
            SecurityToken currentToken = this.nextToken;
            this.nextToken = this.getNext();
            return currentToken;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

